/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.MethodOrFunctionalExpressionCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiClassOrFunctionalExpressionListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerType {
    private final GutterIconNavigationHandler<PsiElement> handler;
    private final Function<PsiElement, String> myTooltip;
    @NotNull
    private final String myDebugName;
    static final MarkerType OVERRIDING_METHOD = new MarkerType("OVERRIDING_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiMethod method2;
        PsiElement parent = MarkerType.getParentMethod(element);
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        return MarkerType.calculateOverridingMethodTooltip(method2, (method2 = (PsiMethod)parent) != element.getParent());
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiMethod method2;
            PsiElement parent = MarkerType.getParentMethod(element);
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            MarkerType.navigateToOverridingMethod(e, method2, (method2 = (PsiMethod)parent) != element.getParent());
        }
    });
    static final MarkerType SIBLING_OVERRIDING_METHOD = new MarkerType("SIBLING_OVERRIDING_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = MarkerType.getParentMethod(element);
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method2 = (PsiMethod)parent;
        return MarkerType.calculateOverridingSiblingMethodTooltip(method2);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = MarkerType.getParentMethod(element);
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method2 = (PsiMethod)parent;
            MarkerType.navigateToSiblingOverridingMethod(e, method2);
        }
    });
    public static final String SEARCHING_FOR_OVERRIDING_METHODS = "Searching for Overriding Methods";
    static final MarkerType OVERRIDDEN_METHOD = new MarkerType("OVERRIDDEN_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method2 = (PsiMethod)parent;
        return MarkerType.getOverriddenMethodTooltip(method2);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            MarkerType.navigateToOverriddenMethod(e, (PsiMethod)parent);
        }
    });
    private static final String SEARCHING_FOR_OVERRIDDEN_METHODS = "Searching for Overridden Methods";
    static final MarkerType SUBCLASSED_CLASS = new MarkerType("SUBCLASSED_CLASS", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        return MarkerType.getSubclassedClassTooltip(aClass);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            MarkerType.navigateToSubclassedClass(e, aClass);
        }
    });

    public MarkerType(@NotNull Function<PsiElement, String> tooltip, @NotNull LineMarkerNavigator navigator) {
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/codeInsight/daemon/impl/MarkerType", "<init>"));
        }
        if (navigator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigator", "com/intellij/codeInsight/daemon/impl/MarkerType", "<init>"));
        }
        this("Unknown", tooltip, navigator);
    }

    public MarkerType(@NotNull String debugName, @NotNull Function<PsiElement, String> tooltip, @NotNull LineMarkerNavigator navigator) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/codeInsight/daemon/impl/MarkerType", "<init>"));
        }
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/codeInsight/daemon/impl/MarkerType", "<init>"));
        }
        if (navigator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigator", "com/intellij/codeInsight/daemon/impl/MarkerType", "<init>"));
        }
        this.myTooltip = tooltip;
        this.myDebugName = debugName;
        this.handler = (e, elt) -> {
            if (navigator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigator", "com/intellij/codeInsight/daemon/impl/MarkerType", "lambda$new$1"));
            }
            DumbService.getInstance((Project)elt.getProject()).withAlternativeResolveEnabled(() -> {
                if (navigator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigator", "com/intellij/codeInsight/daemon/impl/MarkerType", "lambda$null$0"));
                }
                navigator.browse(e, elt);
            });
        };
    }

    public String toString() {
        return this.myDebugName;
    }

    @NotNull
    public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
        GutterIconNavigationHandler<PsiElement> gutterIconNavigationHandler = this.handler;
        if (gutterIconNavigationHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/MarkerType", "getNavigationHandler"));
        }
        return gutterIconNavigationHandler;
    }

    @NotNull
    public Function<PsiElement, String> getTooltip() {
        Function<PsiElement, String> function = this.myTooltip;
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/MarkerType", "getTooltip"));
        }
        return function;
    }

    @Nullable
    private static String calculateOverridingMethodTooltip(@NotNull PsiMethod method2, boolean acceptSelf) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType", "calculateOverridingMethodTooltip"));
        }
        PsiMethod[] superMethods = MarkerType.composeSuperMethods(method2, acceptSelf);
        if (superMethods.length == 0) {
            return null;
        }
        PsiMethod superMethod = superMethods[0];
        boolean isAbstract = method2.hasModifierProperty("abstract");
        boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
        boolean sameSignature = superMethod.getSignature(PsiSubstitutor.EMPTY).equals(method2.getSignature(PsiSubstitutor.EMPTY));
        String key2 = isSuperAbstract && !isAbstract ? (sameSignature ? "method.implements" : "method.implements.in") : (sameSignature ? "method.overrides" : "method.overrides.in");
        return MarkerType.composeText((PsiElement[])superMethods, "", DaemonBundle.message((String)key2, (Object[])new Object[0]), "GotoSuperMethod");
    }

    @Nullable
    private static String calculateOverridingSiblingMethodTooltip(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType", "calculateOverridingSiblingMethodTooltip"));
        }
        FindSuperElementsHelper.SiblingInfo pair = FindSuperElementsHelper.getSiblingInfoInheritedViaSubClass(method2);
        if (pair == null) {
            return null;
        }
        PsiMethod superMethod = pair.superMethod;
        PsiClass subClass = pair.subClass;
        boolean isAbstract = method2.hasModifierProperty("abstract");
        boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
        String postfix = MessageFormat.format(" via sub-class <a href=\"#javaClass/{0}\">{0}</a>", ClassPresentationUtil.getNameForClass(subClass, true));
        String pattern = DaemonBundle.message((String)(isSuperAbstract && !isAbstract ? "method.implements" : "method.overrides"), (Object[])new Object[0]) + postfix;
        return MarkerType.composeText(new PsiElement[]{superMethod}, "", pattern, "GotoSuperMethod");
    }

    @NotNull
    private static String composeText(@NotNull PsiElement[] methods, @NotNull String start, @NotNull String pattern, @NotNull String actionId) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInsight/daemon/impl/MarkerType", "composeText"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/codeInsight/daemon/impl/MarkerType", "composeText"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/codeInsight/daemon/impl/MarkerType", "composeText"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/codeInsight/daemon/impl/MarkerType", "composeText"));
        }
        Object[] shortcuts = ActionManager.getInstance().getAction(actionId).getShortcutSet().getShortcuts();
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcuts);
        String postfix = "<br><div style='margin-top: 5px'><font size='2'>Click";
        if (shortcut != null) {
            postfix = postfix + " or press " + KeymapUtil.getShortcutText((Shortcut)shortcut);
        }
        postfix = postfix + " to navigate</font></div>";
        String string = GutterIconTooltipHelper.composeText(Arrays.asList(methods), start, pattern, postfix);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/MarkerType", "composeText"));
        }
        return string;
    }

    private static void navigateToOverridingMethod(MouseEvent e, @NotNull PsiMethod method2, boolean acceptSelf) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType", "navigateToOverridingMethod"));
        }
        PsiMethod[] superMethods = MarkerType.composeSuperMethods(method2, acceptSelf);
        if (superMethods.length == 0) {
            return;
        }
        boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])superMethods);
        PsiElementListNavigator.openTargets(e, (NavigatablePsiElement[])superMethods, DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method2.getName()}), DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{method2.getName()}), (ListCellRenderer)new MethodCellRenderer(showMethodNames));
    }

    private static void navigateToSiblingOverridingMethod(MouseEvent e, @NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType", "navigateToSiblingOverridingMethod"));
        }
        PsiMethod superMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method2);
        if (superMethod == null) {
            return;
        }
        PsiElementListNavigator.openTargets(e, new NavigatablePsiElement[]{superMethod}, DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method2.getName()}), DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{method2.getName()}), (ListCellRenderer)new MethodCellRenderer(false));
    }

    @NotNull
    private static PsiMethod[] composeSuperMethods(@NotNull PsiMethod method2, boolean acceptSelf) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType", "composeSuperMethods"));
        }
        Object[] superElements = FindSuperElementsHelper.findSuperElements((PsiElement)method2);
        Object[] superMethods = (PsiMethod[])ContainerUtil.map((Object[])superElements, element -> (PsiMethod)element, (Object[])PsiMethod.EMPTY_ARRAY);
        if (acceptSelf) {
            superMethods = (PsiMethod[])ArrayUtil.prepend((Object)method2, (Object[])superMethods);
        }
        if (superMethods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/MarkerType", "composeSuperMethods"));
        }
        return superMethods;
    }

    private static PsiElement getParentMethod(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/MarkerType", "getParentMethod"));
        }
        PsiElement parent = element.getParent();
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)parent);
        return interfaceMethod != null ? interfaceMethod : parent;
    }

    private static String getOverriddenMethodTooltip(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType", "getOverriddenMethodTooltip"));
        }
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)method2));
        OverridingMethodsSearch.search((PsiMethod)method2, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
        boolean isAbstract = method2.hasModifierProperty("abstract");
        if (processor2.isOverflow()) {
            return DaemonBundle.message((String)(isAbstract ? "method.is.implemented.too.many" : "method.is.overridden.too.many"), (Object[])new Object[0]);
        }
        PsiMethod[] overridings = (PsiMethod[])processor2.toArray((PsiElement[])PsiMethod.EMPTY_ARRAY);
        if (overridings.length == 0) {
            PsiClass aClass = method2.getContainingClass();
            if (aClass != null && isAbstract && FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null) {
                return "Has functional implementations";
            }
            return null;
        }
        Comparator comparator2 = new MethodCellRenderer(false).getComparator();
        Arrays.sort(overridings, comparator2);
        String start = DaemonBundle.message((String)(isAbstract ? "method.is.implemented.header" : "method.is.overriden.header"), (Object[])new Object[0]);
        String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#javaClass/{1}\">{1}</a>";
        return MarkerType.composeText((PsiElement[])overridings, start, pattern, "GotoImplementation");
    }

    private static void navigateToOverriddenMethod(MouseEvent e, @NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType", "navigateToOverriddenMethod"));
        }
        if (DumbService.isDumb((Project)method2.getProject())) {
            DumbService.getInstance((Project)method2.getProject()).showDumbModeNotification("Navigation to overriding classes is not possible during index update");
            return;
        }
        PsiElementProcessor.CollectElementsWithLimit collectProcessor = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
        PsiElementProcessor.CollectElementsWithLimit collectExprProcessor = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
        boolean isAbstract = method2.hasModifierProperty("abstract");
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType", "lambda$navigateToOverriddenMethod$6"));
            }
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)method2));
            OverridingMethodsSearch.search((PsiMethod)method2, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectProcessor));
            if (isAbstract && collectProcessor.getCollection().size() < 2) {
                PsiClass aClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method2).getContainingClass());
                if (aClass != null) {
                    FunctionalExpressionSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectExprProcessor));
                }
            }
        }, SEARCHING_FOR_OVERRIDING_METHODS, true, method2.getProject(), (JComponent)e.getComponent())) {
            return;
        }
        PsiMethod[] methodOverriders = (PsiMethod[])collectProcessor.toArray((PsiElement[])PsiMethod.EMPTY_ARRAY);
        ArrayList overridings = new ArrayList();
        overridings.addAll(collectProcessor.getCollection());
        overridings.addAll(collectExprProcessor.getCollection());
        if (overridings.isEmpty()) {
            return;
        }
        boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])methodOverriders);
        MethodOrFunctionalExpressionCellRenderer renderer = new MethodOrFunctionalExpressionCellRenderer(showMethodNames);
        Collections.sort(overridings, renderer.getComparator());
        OverridingMethodsUpdater methodsUpdater = new OverridingMethodsUpdater(method2, renderer);
        PsiElementListNavigator.openTargets(e, overridings.toArray(new NavigatablePsiElement[overridings.size()]), methodsUpdater.getCaption(overridings.size()), "Overriding methods of " + method2.getName(), renderer, methodsUpdater);
    }

    public static String getSubclassedClassTooltip(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/MarkerType", "getSubclassedClassTooltip"));
        }
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5, (Collection)new THashSet());
        ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
        if (processor2.isOverflow()) {
            return DaemonBundle.message((String)(aClass.isInterface() ? "interface.is.implemented.too.many" : "class.is.subclassed.too.many"), (Object[])new Object[0]);
        }
        PsiClass[] subclasses = (PsiClass[])processor2.toArray((PsiElement[])PsiClass.EMPTY_ARRAY);
        if (subclasses.length == 0) {
            PsiElementProcessor.CollectElementsWithLimit functionalImplementations = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
            FunctionalExpressionSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)functionalImplementations));
            if (!functionalImplementations.getCollection().isEmpty()) {
                return "Has functional implementations";
            }
            return null;
        }
        Comparator comparator2 = new PsiClassListCellRenderer().getComparator();
        Arrays.sort(subclasses, comparator2);
        String start = DaemonBundle.message((String)(aClass.isInterface() ? "interface.is.implemented.by.header" : "class.is.subclassed.by.header"), (Object[])new Object[0]);
        String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#javaClass/{0}\">{0}</a>";
        return MarkerType.composeText((PsiElement[])subclasses, start, pattern, "GotoImplementation");
    }

    public static void navigateToSubclassedClass(MouseEvent e, @NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/MarkerType", "navigateToSubclassedClass"));
        }
        if (DumbService.isDumb((Project)aClass.getProject())) {
            DumbService.getInstance((Project)aClass.getProject()).showDumbModeNotification("Navigation to overriding methods is not possible during index update");
            return;
        }
        PsiElementProcessor.FindElement collectProcessor = new PsiElementProcessor.FindElement();
        PsiElementProcessor.FindElement collectExprProcessor = new PsiElementProcessor.FindElement();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/MarkerType", "lambda$navigateToSubclassedClass$8"));
            }
            ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectProcessor));
            if (collectProcessor.getFoundElement() == null) {
                FunctionalExpressionSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectExprProcessor));
            }
        }, SEARCHING_FOR_OVERRIDDEN_METHODS, true, aClass.getProject(), (JComponent)e.getComponent())) {
            return;
        }
        ArrayList inheritors = new ArrayList();
        ContainerUtil.addIfNotNull(inheritors, (Object)collectProcessor.getFoundElement());
        ContainerUtil.addIfNotNull(inheritors, (Object)collectExprProcessor.getFoundElement());
        if (inheritors.isEmpty()) {
            return;
        }
        PsiClassOrFunctionalExpressionListCellRenderer renderer = new PsiClassOrFunctionalExpressionListCellRenderer();
        SubclassUpdater subclassUpdater = new SubclassUpdater(aClass, renderer);
        Collections.sort(inheritors, renderer.getComparator());
        PsiElementListNavigator.openTargets(e, inheritors.toArray(new NavigatablePsiElement[inheritors.size()]), subclassUpdater.getCaption(inheritors.size()), CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{aClass.getName()}), renderer, subclassUpdater);
    }

    private static class OverridingMethodsUpdater
    extends ListBackgroundUpdaterTask {
        private final PsiMethod myMethod;
        private final PsiElementListCellRenderer myRenderer;

        private OverridingMethodsUpdater(@NotNull PsiMethod method2, @NotNull PsiElementListCellRenderer renderer) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/MarkerType$OverridingMethodsUpdater", "<init>"));
            }
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/daemon/impl/MarkerType$OverridingMethodsUpdater", "<init>"));
            }
            super(method2.getProject(), MarkerType.SEARCHING_FOR_OVERRIDING_METHODS);
            this.myMethod = method2;
            this.myRenderer = renderer;
        }

        @Override
        public String getCaption(int size) {
            return DaemonBundle.message((String)(this.myMethod.hasModifierProperty("abstract") ? "navigation.title.implementation.method" : "navigation.title.overrider.method"), (Object[])new Object[]{this.myMethod.getName(), size});
        }

        @Override
        public void onFinished() {
            super.onFinished();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/MarkerType$OverridingMethodsUpdater", "run"));
            }
            super.run(indicator);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)this.myMethod));
            OverridingMethodsSearch.search((PsiMethod)this.myMethod, (SearchScope)scope, (boolean)true).forEach((Processor)new CommonProcessors.CollectProcessor<PsiMethod>(){

                public boolean process(PsiMethod psiMethod) {
                    if (!this.updateComponent((PsiElement)psiMethod, myRenderer.getComparator())) {
                        indicator.cancel();
                    }
                    indicator.checkCanceled();
                    return super.process((Object)psiMethod);
                }
            });
            if (((Boolean)ReadAction.compute(() -> this.myMethod.hasModifierProperty("abstract"))).booleanValue()) {
                PsiClass psiClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)this.myMethod).getContainingClass());
                FunctionalExpressionSearch.search((PsiClass)psiClass).forEach((Processor)new CommonProcessors.CollectProcessor<PsiFunctionalExpression>(){

                    public boolean process(PsiFunctionalExpression expr) {
                        if (!this.updateComponent((PsiElement)expr, myRenderer.getComparator())) {
                            indicator.cancel();
                        }
                        indicator.checkCanceled();
                        return super.process((Object)expr);
                    }
                });
            }
        }
    }

    private static class SubclassUpdater
    extends ListBackgroundUpdaterTask {
        private final PsiClass myClass;
        private final PsiClassOrFunctionalExpressionListCellRenderer myRenderer;

        private SubclassUpdater(@NotNull PsiClass aClass, @NotNull PsiClassOrFunctionalExpressionListCellRenderer renderer) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/MarkerType$SubclassUpdater", "<init>"));
            }
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/daemon/impl/MarkerType$SubclassUpdater", "<init>"));
            }
            super(aClass.getProject(), MarkerType.SEARCHING_FOR_OVERRIDDEN_METHODS);
            this.myClass = aClass;
            this.myRenderer = renderer;
        }

        @Override
        public String getCaption(int size) {
            String suffix = this.isFinished() ? "" : " so far";
            return this.myClass.isInterface() ? CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{this.myClass.getName(), size, suffix}) : DaemonBundle.message((String)"navigation.title.subclass", (Object[])new Object[]{this.myClass.getName(), size, suffix});
        }

        @Override
        public void onFinished() {
            super.onFinished();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/MarkerType$SubclassUpdater", "run"));
            }
            super.run(indicator);
            ClassInheritorsSearch.search((PsiClass)this.myClass, (SearchScope)((SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

                public SearchScope compute() {
                    return myClass.getUseScope();
                }
            })), (boolean)true).forEach((Processor)new CommonProcessors.CollectProcessor<PsiClass>(){

                public boolean process(PsiClass o) {
                    if (!this.updateComponent((PsiElement)o, myRenderer.getComparator())) {
                        indicator.cancel();
                    }
                    indicator.checkCanceled();
                    return super.process((Object)o);
                }
            });
            FunctionalExpressionSearch.search((PsiClass)this.myClass).forEach((Processor)new CommonProcessors.CollectProcessor<PsiFunctionalExpression>(){

                public boolean process(PsiFunctionalExpression expr) {
                    if (!this.updateComponent((PsiElement)expr, myRenderer.getComparator())) {
                        indicator.cancel();
                    }
                    indicator.checkCanceled();
                    return super.process((Object)expr);
                }
            });
        }
    }
}

