/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.ModuleHighlightUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleGraphUtil {
    private JavaModuleGraphUtil() {
    }

    @Nullable
    public static PsiJavaModule findDescriptorByElement(@Nullable PsiElement element) {
        if (element != null) {
            PsiFileSystemItem fsItem;
            Object object = fsItem = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
            if (fsItem != null) {
                return ModuleHighlightUtil.getModuleDescriptor(fsItem);
            }
        }
        return null;
    }

    @Nullable
    public static Collection<PsiJavaModule> findCycle(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "findCycle"));
        }
        Project project2 = module2.getProject();
        List cycles = (List)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.findCycles(project2), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        return (Collection)ContainerUtil.find((Iterable)cycles, set2 -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "lambda$findCycle$1"));
            }
            return set2.contains(module2);
        });
    }

    public static boolean exports(@NotNull PsiJavaModule source, @NotNull String packageName, @NotNull PsiJavaModule target) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        Map exports = (Map)CachedValuesManager.getCachedValue((PsiElement)source, () -> {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "lambda$exports$2"));
            }
            return CachedValueProvider.Result.create(JavaModuleGraphUtil.exportsMap(source), (Object[])new Object[]{source.getContainingFile()});
        });
        Set targets = (Set)exports.get(packageName);
        return targets != null && (targets.isEmpty() || targets.contains(target.getName()));
    }

    public static boolean reads(@NotNull PsiJavaModule source, @NotNull PsiJavaModule destination) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "reads"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "reads"));
        }
        return JavaModuleGraphUtil.getRequiresGraph(source).reads(source, destination);
    }

    @Nullable
    public static Trinity<String, PsiJavaModule, PsiJavaModule> findConflict(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "findConflict"));
        }
        return JavaModuleGraphUtil.getRequiresGraph(module2).findConflict(module2);
    }

    @Nullable
    public static PsiJavaModule findOrigin(@NotNull PsiJavaModule module2, @NotNull String packageName) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "findOrigin"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "findOrigin"));
        }
        return JavaModuleGraphUtil.getRequiresGraph(module2).findOrigin(module2, packageName);
    }

    private static List<Set<PsiJavaModule>> findCycles(Project project2) {
        HashSet projectModules = ContainerUtil.newHashSet();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            Collection<VirtualFile> files = FilenameIndex.getVirtualFilesByName(project2, "module-info.java", module2.getModuleScope());
            if (files.size() > 1) {
                return Collections.emptyList();
            }
            Optional.ofNullable(ContainerUtil.getFirstItem(files)).map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project2)).findFile(arg_0)).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).ifPresent(projectModules::add);
        }
        if (!projectModules.isEmpty()) {
            ChameleonGraph graph;
            DFSTBuilder builder;
            Collection components;
            MultiMap relations = MultiMap.create();
            for (PsiJavaModule module3 : projectModules) {
                for (PsiRequiresStatement statement2 : module3.getRequires()) {
                    PsiJavaModule dependency = PsiJavaModuleReference.resolve((PsiElement)statement2, statement2.getModuleName(), true);
                    if (dependency == null || !projectModules.contains(dependency)) continue;
                    relations.putValue((Object)module3, (Object)dependency);
                }
            }
            if (!relations.isEmpty() && !(components = (builder = new DFSTBuilder(graph = new ChameleonGraph(relations, false))).getComponents()).isEmpty()) {
                return components.stream().map(ContainerUtil::newLinkedHashSet).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Map<String, Set<String>> exportsMap(@NotNull PsiJavaModule source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exportsMap"));
        }
        HashMap map = ContainerUtil.newHashMap();
        for (PsiPackageAccessibilityStatement statement2 : source.getExports()) {
            String pkg = statement2.getPackageName();
            List targets = statement2.getModuleNames();
            map.put(pkg, targets.isEmpty() ? Collections.emptySet() : ContainerUtil.newTroveSet((Collection)targets));
        }
        return map;
    }

    private static RequiresGraph getRequiresGraph(PsiJavaModule module2) {
        Project project2 = module2.getProject();
        return (RequiresGraph)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> CachedValueProvider.Result.create((Object)JavaModuleGraphUtil.buildRequiresGraph(project2), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
    }

    private static RequiresGraph buildRequiresGraph(Project project2) {
        MultiMap relations = MultiMap.create();
        THashSet transitiveEdges = ContainerUtil.newTroveSet();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            Collection<VirtualFile> files = FilenameIndex.getVirtualFilesByName(project2, "module-info.java", module2.getModuleScope());
            Optional.ofNullable(ContainerUtil.getFirstItem(files)).map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project2)).findFile(arg_0)).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).ifPresent(arg_0 -> JavaModuleGraphUtil.lambda$buildRequiresGraph$6(relations, (Set)transitiveEdges, arg_0));
        }
        Graph graph = GraphGenerator.generate(new ChameleonGraph(relations, true));
        return new RequiresGraph((Graph<PsiJavaModule>)graph, (Set<String>)transitiveEdges);
    }

    private static void visit(PsiJavaModule module2, MultiMap<PsiJavaModule, PsiJavaModule> relations, Set<String> transitiveEdges) {
        if (!relations.containsKey((Object)module2)) {
            PsiJavaModule javaBase;
            relations.putValues((Object)module2, Collections.emptyList());
            boolean explicitJavaBase = false;
            for (PsiRequiresStatement statement2 : module2.getRequires()) {
                String moduleName = statement2.getModuleName();
                if ("java.base".equals(moduleName)) {
                    explicitJavaBase = true;
                }
                for (PsiJavaModule dependency : PsiJavaModuleReference.multiResolve((PsiElement)statement2, moduleName, false)) {
                    relations.putValue((Object)module2, (Object)dependency);
                    if (statement2.hasModifierProperty("transitive")) {
                        transitiveEdges.add(RequiresGraph.key(dependency, module2));
                    }
                    JavaModuleGraphUtil.visit(dependency, relations, transitiveEdges);
                }
            }
            if (!explicitJavaBase && !(module2 instanceof LightJavaModule) && (javaBase = PsiJavaModuleReference.resolve((PsiElement)module2, "java.base", false)) != null) {
                relations.putValue((Object)module2, (Object)javaBase);
            }
        }
    }

    private static /* synthetic */ void lambda$buildRequiresGraph$6(MultiMap relations, Set transitiveEdges, PsiJavaModule m) {
        JavaModuleGraphUtil.visit(m, (MultiMap<PsiJavaModule, PsiJavaModule>)relations, transitiveEdges);
    }

    private static class ChameleonGraph<N>
    implements Graph<N> {
        private final Set<N> myNodes = new THashSet();
        private final MultiMap<N, N> myEdges;
        private final boolean myInbound;

        public ChameleonGraph(MultiMap<N, N> edges, boolean inbound) {
            edges.entrySet().forEach(e -> {
                this.myNodes.add(e.getKey());
                this.myNodes.addAll((Collection)e.getValue());
            });
            this.myEdges = edges;
            this.myInbound = inbound;
        }

        public Collection<N> getNodes() {
            return this.myNodes;
        }

        public Iterator<N> getIn(N n) {
            return this.myInbound ? this.myEdges.get(n).iterator() : Collections.emptyIterator();
        }

        public Iterator<N> getOut(N n) {
            return this.myInbound ? Collections.emptyIterator() : this.myEdges.get(n).iterator();
        }
    }

    private static class RequiresGraph {
        private final Graph<PsiJavaModule> myGraph;
        private final Set<String> myTransitiveEdges;

        public RequiresGraph(Graph<PsiJavaModule> graph, Set<String> transitiveEdges) {
            this.myGraph = graph;
            this.myTransitiveEdges = transitiveEdges;
        }

        public boolean reads(PsiJavaModule source, PsiJavaModule destination) {
            Collection nodes = this.myGraph.getNodes();
            if (nodes.contains(destination) && nodes.contains(source)) {
                Iterator directReaders = this.myGraph.getOut((Object)destination);
                while (directReaders.hasNext()) {
                    PsiJavaModule next = (PsiJavaModule)directReaders.next();
                    if (!source.equals(next) && (!this.myTransitiveEdges.contains(RequiresGraph.key(destination, next)) || !this.reads(source, next))) continue;
                    return true;
                }
            }
            return false;
        }

        public Trinity<String, PsiJavaModule, PsiJavaModule> findConflict(PsiJavaModule source) {
            HashMap exports = ContainerUtil.newHashMap();
            return this.processExports(source, (pkg, m) -> {
                PsiJavaModule existing = exports.put(pkg, m);
                return existing != null ? new Trinity(pkg, (Object)existing, m) : null;
            });
        }

        public PsiJavaModule findOrigin(PsiJavaModule module2, String packageName) {
            return this.processExports(module2, (pkg, m) -> packageName.equals(pkg) ? m : null);
        }

        private <T> T processExports(PsiJavaModule start, BiFunction<String, PsiJavaModule, T> processor2) {
            return this.myGraph.getNodes().contains(start) ? (T)this.processExports(start.getName(), start, 0, ContainerUtil.newHashSet(), processor2) : null;
        }

        private <T> T processExports(String name, PsiJavaModule module2, int layer, Set<PsiJavaModule> visited, BiFunction<String, PsiJavaModule, T> processor2) {
            if (visited.add(module2)) {
                if (layer == 1) {
                    for (PsiPackageAccessibilityStatement statement2 : module2.getExports()) {
                        T result2;
                        List exportTargets = statement2.getModuleNames();
                        if (!exportTargets.isEmpty() && !exportTargets.contains(name) || (result2 = processor2.apply(statement2.getPackageName(), module2)) == null) continue;
                        return result2;
                    }
                }
                if (layer < 2) {
                    Iterator iterator = this.myGraph.getIn((Object)module2);
                    while (iterator.hasNext()) {
                        T result3;
                        PsiJavaModule dependency = (PsiJavaModule)iterator.next();
                        if (layer != 0 && !this.myTransitiveEdges.contains(RequiresGraph.key(dependency, module2)) || (result3 = this.processExports(name, dependency, 1, visited, processor2)) == null) continue;
                        return result3;
                    }
                }
            }
            return null;
        }

        public static String key(PsiJavaModule module2, PsiJavaModule exporter) {
            return module2.getName() + '/' + exporter.getName();
        }
    }
}

