/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateAnnotationMethodFromUsageFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationAttributeNameFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public AddAnnotationAttributeNameFix(PsiNameValuePair pair, String name) {
        super((PsiElement)pair);
        this.myName = name;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = "Add '" + this.myName + "='";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Add annotation attribute name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "getFamilyName"));
        }
        return "Add annotation attribute name";
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "invoke"));
        }
        AddAnnotationAttributeNameFix.doFix((PsiNameValuePair)startElement, this.myName);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "isAvailable"));
        }
        return super.isAvailable(project2, file2, startElement, endElement) && startElement instanceof PsiNameValuePair;
    }

    @NotNull
    public static List<IntentionAction> createFixes(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "createFixes"));
        }
        PsiAnnotationMemberValue value = pair.getValue();
        if (value == null || pair.getName() != null) {
            List<IntentionAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "createFixes"));
            }
            return list;
        }
        Collection<String> methodNames = AddAnnotationAttributeNameFix.getAvailableAnnotationMethodNames(pair);
        List list = ContainerUtil.map2List(methodNames, name -> {
            if (pair == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "lambda$createFixes$0"));
            }
            return new AddAnnotationAttributeNameFix(pair, (String)name);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "createFixes"));
        }
        return list;
    }

    public static void doFix(@NotNull PsiNameValuePair annotationParameter, @NotNull String name) {
        if (annotationParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParameter", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "doFix"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "doFix"));
        }
        String text = AddAnnotationAttributeNameFix.buildReplacementText(annotationParameter, name);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)annotationParameter.getProject());
        PsiAnnotation newAnnotation = factory.createAnnotationFromText("@A(" + text + " )", (PsiElement)annotationParameter);
        annotationParameter.replace((PsiElement)newAnnotation.getParameterList().getAttributes()[0]);
    }

    private static String buildReplacementText(@NotNull PsiNameValuePair annotationParameter, @NotNull String name) {
        if (annotationParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParameter", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "buildReplacementText"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "buildReplacementText"));
        }
        PsiAnnotationMemberValue value = annotationParameter.getValue();
        return value != null ? name + "=" + value.getText() : name + "=";
    }

    public static boolean isCompatibleReturnType(@NotNull PsiMethod psiMethod, @Nullable PsiType valueType) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "isCompatibleReturnType"));
        }
        PsiType expectedType = psiMethod.getReturnType();
        if (expectedType == null || valueType == null || expectedType.isAssignableFrom(valueType)) {
            return true;
        }
        if (expectedType instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)expectedType).getComponentType();
            return componentType.isAssignableFrom(valueType);
        }
        return false;
    }

    @NotNull
    private static Collection<String> getAvailableAnnotationMethodNames(@NotNull PsiNameValuePair pair) {
        PsiAnnotationParameterList parameterList;
        PsiClass annotationClass;
        PsiElement parent;
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "getAvailableAnnotationMethodNames"));
        }
        PsiAnnotationMemberValue value = pair.getValue();
        if (value != null && pair.getName() == null && (parent = pair.getParent()) instanceof PsiAnnotationParameterList && (annotationClass = AddAnnotationAttributeNameFix.getAnnotationClass(parameterList = (PsiAnnotationParameterList)parent)) != null) {
            Set<String> usedNames = AddAnnotationAttributeNameFix.getUsedAttributeNames(parameterList);
            Collection availableMethods = Arrays.stream(annotationClass.getMethods()).filter(PsiAnnotationMethod.class::isInstance).filter(psiMethod -> !usedNames.contains(psiMethod.getName())).collect(Collectors.toList());
            if (!availableMethods.isEmpty()) {
                PsiType valueType = CreateAnnotationMethodFromUsageFix.getAnnotationValueType(value);
                Collection collection = availableMethods.stream().filter(psiMethod -> AddAnnotationAttributeNameFix.isCompatibleReturnType(psiMethod, valueType)).map(PsiMethod::getName).collect(Collectors.toSet());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "getAvailableAnnotationMethodNames"));
                }
                return collection;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "getAvailableAnnotationMethodNames"));
        }
        return list;
    }

    @NotNull
    public static Set<String> getUsedAttributeNames(@NotNull PsiAnnotationParameterList parameterList) {
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "getUsedAttributeNames"));
        }
        Set<String> set2 = Arrays.stream(parameterList.getAttributes()).map(PsiNameValuePair::getName).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "getUsedAttributeNames"));
        }
        return set2;
    }

    @Nullable
    private static PsiClass getAnnotationClass(@NotNull PsiAnnotationParameterList parameterList) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement reference;
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix", "getAnnotationClass"));
        }
        PsiElement parent = parameterList.getParent();
        if (parent instanceof PsiAnnotation && (reference = ((PsiAnnotation)parent).getNameReferenceElement()) != null && (resolved = reference.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            return (PsiClass)resolved;
        }
        return null;
    }
}

