/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;

public class CreateInnerClassFromNewFix
extends CreateClassFromNewFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromNewFix");

    public CreateInnerClassFromNewFix(PsiNewExpression expr) {
        super(expr);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.inner.class.from.usage.text", CreateClassKind.CLASS.getDescription(), varName);
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return true;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiNewExpression newExpression = this.getNewExpression();
        PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
        assert (ref != null);
        String refName = ref.getReferenceName();
        LOG.assertTrue(refName != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getElementFactory();
        PsiClass created = elementFactory.createClass(refName);
        PsiModifierList modifierList = created.getModifierList();
        LOG.assertTrue(modifierList != null);
        if (PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)newExpression, (boolean)true)) {
            if (targetClass.isInterface() || PsiUtil.isLocalOrAnonymousClass((PsiClass)targetClass)) {
                modifierList.setModifierProperty("packageLocal", true);
            } else {
                modifierList.setModifierProperty("private", true);
            }
        }
        if (!(targetClass.isInterface() || PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)newExpression, (boolean)true) && PsiUtil.getEnclosingStaticElement((PsiElement)newExpression, (PsiClass)targetClass) == null && !CreateInnerClassFromNewFix.isInThisOrSuperCall(newExpression))) {
            modifierList.setModifierProperty("static", true);
        }
        created = (PsiClass)targetClass.add((PsiElement)created);
        CreateInnerClassFromNewFix.setupGenericParameters(created, ref);
        this.setupClassFromNewExpression(created, newExpression);
    }

    private static boolean isInThisOrSuperCall(PsiNewExpression newExpression) {
        PsiElement referenceNameElement;
        PsiReferenceExpression methodExpression;
        PsiElement resolve2;
        PsiExpression expression;
        boolean inFirstConstructorLine = false;
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)newExpression, PsiExpressionStatement.class);
        if (expressionStatement != null && (expression = expressionStatement.getExpression()) instanceof PsiMethodCallExpression && (resolve2 = (methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression()).resolve()) instanceof PsiMethod && ((PsiMethod)resolve2).isConstructor() && (referenceNameElement = methodExpression.getReferenceNameElement()) != null && (Comparing.strEqual((String)referenceNameElement.getText(), (String)"this") || Comparing.strEqual((String)referenceNameElement.getText(), (String)"super"))) {
            inFirstConstructorLine = true;
        }
        return inFirstConstructorLine;
    }
}

