/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodFromUsageFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix");
    private final SmartPsiElementPointer myMethodCall;

    public CreateMethodFromUsageFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix", "<init>"));
        }
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCall.getProject()).createSmartPsiElementPointer((PsiElement)methodCall);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null || !call.isValid()) {
            return false;
        }
        PsiReferenceExpression ref = call.getMethodExpression();
        String name = ref.getReferenceName();
        if (name == null || !PsiNameHelper.getInstance((Project)ref.getProject()).isIdentifier(name)) {
            return false;
        }
        if (CreateMethodFromUsageFix.hasErrorsInArgumentList(call)) {
            return false;
        }
        this.setText(this.getDisplayString(name));
        return true;
    }

    protected String getDisplayString(String name) {
        return QuickFixBundle.message("create.method.from.usage.text", name);
    }

    private static boolean isMethodSignatureExists(PsiMethodCallExpression call, PsiClass target) {
        PsiMethod[] methods;
        String name = call.getMethodExpression().getReferenceName();
        JavaResolveResult resolveResult = call.getMethodExpression().advancedResolve(false);
        PsiExpressionList list = call.getArgumentList();
        for (PsiMethod method2 : methods = target.findMethodsByName(name, false)) {
            if (!PsiUtil.isApplicable((PsiMethod)method2, (PsiSubstitutor)resolveResult.getSubstitutor(), (PsiExpressionList)list)) continue;
            return true;
        }
        return false;
    }

    static boolean hasErrorsInArgumentList(PsiMethodCallExpression call) {
        Project project2 = call.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(call.getContainingFile());
        if (document == null) {
            return true;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        TextRange argRange = argumentList.getTextRange();
        return !DaemonCodeAnalyzerEx.processHighlights(document, project2, HighlightSeverity.ERROR, argRange.getStartOffset() + 1, argRange.getEndOffset() - 1, (Processor<HighlightInfo>)((Processor)info -> info.getActualStartOffset() <= argRange.getStartOffset() || info.getActualEndOffset() >= argRange.getEndOffset()));
    }

    @Override
    protected PsiElement getElement() {
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null || !call.getManager().isInProject((PsiElement)call)) {
            return null;
        }
        return call;
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> targets = super.getTargetClasses(element);
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix", "getTargetClasses"));
            }
            return list;
        }
        for (PsiClass target : targets) {
            if (CreateMethodFromUsageFix.shouldCreateStaticMember(call.getMethodExpression(), target) && (target.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)target) || target.getContainingClass() != null && !target.hasModifierProperty("static")) || CreateMethodFromUsageFix.isMethodSignatureExists(call, target)) continue;
            result2.add(target);
        }
        ArrayList<PsiClass> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix", "getTargetClasses"));
        }
        return arrayList;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        if (targetClass == null) {
            return;
        }
        PsiMethodCallExpression expression = this.getMethodCall();
        if (expression == null) {
            return;
        }
        PsiReferenceExpression ref = expression.getMethodExpression();
        if (this.isValidElement((PsiElement)expression)) {
            return;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
        PsiMember enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class});
        String methodName = ref.getReferenceName();
        LOG.assertTrue(methodName != null);
        PsiMethod method2 = CreateMethodFromUsageFix.createMethod(targetClass, parentClass, enclosingContext, methodName);
        if (method2 == null) {
            return;
        }
        if (enclosingContext instanceof PsiMethod && methodName.equals(enclosingContext.getName()) && PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)parentClass, (boolean)true) && !ref.isQualified()) {
            RefactoringChangeUtil.qualifyReference(ref, (PsiMember)method2, null);
        }
        PsiCodeBlock body = method2.getBody();
        assert (body != null);
        boolean shouldBeAbstract = this.shouldBeAbstract(expression.getMethodExpression(), targetClass);
        if (shouldBeAbstract) {
            body.delete();
            if (!targetClass.isInterface()) {
                method2.getModifierList().setModifierProperty("abstract", true);
            }
        }
        this.setupVisibility(parentClass, targetClass, method2.getModifierList());
        expression = this.getMethodCall();
        LOG.assertTrue(expression.isValid());
        if ((!targetClass.isInterface() || PsiUtil.isLanguageLevel8OrHigher((PsiElement)targetClass)) && CreateMethodFromUsageFix.shouldCreateStaticMember(expression.getMethodExpression(), targetClass) && !shouldBeAbstract) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method2, (String)"static", (boolean)true);
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        Object[] arguments = expression.getArgumentList().getExpressions();
        CreateMethodFromUsageFix.doCreate(targetClass, method2, shouldBeAbstract, ContainerUtil.map2List((Object[])arguments, (Function)Pair.createFunction(null)), CreateMethodFromUsageFix.getTargetSubstitutor((PsiElement)expression), CreateFromUsageUtils.guessExpectedTypes((PsiExpression)expression, true), context);
    }

    public static PsiMethod createMethod(PsiClass targetClass, PsiClass parentClass, PsiMember enclosingContext, String methodName) {
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)targetClass.getProject());
        if (factory == null) {
            return null;
        }
        PsiMethod method2 = factory.createMethod(methodName, (PsiType)PsiType.VOID);
        if (targetClass.equals(parentClass)) {
            method2 = (PsiMethod)targetClass.addAfter((PsiElement)method2, (PsiElement)enclosingContext);
        } else {
            PsiMember anchor;
            for (anchor = enclosingContext; anchor != null && anchor.getParent() != null && !anchor.getParent().equals(targetClass); anchor = anchor.getParent()) {
            }
            if (anchor != null && anchor.getParent() == null) {
                anchor = null;
            }
            method2 = anchor != null ? (PsiMethod)targetClass.addAfter((PsiElement)method2, (PsiElement)anchor) : (PsiMethod)targetClass.add((PsiElement)method2);
        }
        return method2;
    }

    public static void doCreate(PsiClass targetClass, PsiMethod method2, List<Pair<PsiExpression, PsiType>> arguments, PsiSubstitutor substitutor, ExpectedTypeInfo[] expectedTypes, @Nullable PsiElement context) {
        CreateMethodFromUsageFix.doCreate(targetClass, method2, CreateMethodFromUsageFix.shouldBeAbstractImpl(null, targetClass), arguments, substitutor, expectedTypes, context);
    }

    public static void doCreate(PsiClass targetClass, PsiMethod method2, boolean shouldBeAbstract, List<Pair<PsiExpression, PsiType>> arguments, PsiSubstitutor substitutor, ExpectedTypeInfo[] expectedTypes, @Nullable PsiElement context) {
        if ((method2 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(method2)) == null) {
            return;
        }
        final Project project2 = targetClass.getProject();
        final PsiFile targetFile = targetClass.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(targetFile);
        if (document == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method2);
        CreateFromUsageUtils.setupMethodParameters(method2, (TemplateBuilder)builder, context, substitutor, arguments);
        PsiTypeElement returnTypeElement = method2.getReturnTypeElement();
        if (returnTypeElement != null) {
            new GuessTypeParameters((JVMElementFactory)JavaPsiFacade.getInstance((Project)project2).getElementFactory()).setupTypeElement(returnTypeElement, expectedTypes, substitutor, builder, context, targetClass);
        }
        PsiCodeBlock body = method2.getBody();
        builder.setEndVariableAfter((PsiElement)(shouldBeAbstract || body == null ? method2 : body.getLBrace()));
        method2 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(method2);
        if (method2 == null) {
            return;
        }
        RangeMarker rangeMarker = document.createRangeMarker(method2.getTextRange());
        final Editor newEditor = CreateMethodFromUsageFix.positionCursor(project2, targetFile, (PsiElement)method2);
        if (newEditor == null) {
            return;
        }
        Template template = builder.buildTemplate();
        newEditor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        newEditor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        rangeMarker.dispose();
        if (!shouldBeAbstract) {
            CreateMethodFromUsageFix.startTemplate(newEditor, template, project2, new TemplateEditingAdapter(){

                @Override
                public void templateFinished(Template template, boolean brokenOff) {
                    if (brokenOff) {
                        return;
                    }
                    WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
                        PsiDocumentManager.getInstance((Project)project2).commitDocument(newEditor.getDocument());
                        int offset = newEditor.getCaretModel().getOffset();
                        PsiMethod method1 = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)(offset - 1), PsiMethod.class, (boolean)false);
                        if (method1 != null) {
                            try {
                                CreateFromUsageUtils.setupMethodBody(method1);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                            CreateFromUsageUtils.setupEditor(method1, newEditor);
                        }
                    });
                }
            });
        } else {
            CreateMethodFromUsageFix.startTemplate(newEditor, template, project2);
        }
    }

    public static boolean checkTypeParam(final PsiMethod method2, PsiTypeParameter typeParameter) {
        final String typeParameterName = typeParameter.getName();
        PsiTypeVisitor<Boolean> visitor = new PsiTypeVisitor<Boolean>(){

            public Boolean visitClassType(PsiClassType classType) {
                PsiClass psiClass = classType.resolve();
                if (psiClass instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)((PsiTypeParameter)psiClass).getOwner(), (PsiElement)method2, (boolean)true)) {
                    return false;
                }
                if (Comparing.strEqual((String)typeParameterName, (String)classType.getCanonicalText())) {
                    return true;
                }
                for (PsiType p : classType.getParameters()) {
                    if (!((Boolean)p.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return false;
            }

            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return (Boolean)bound.accept((PsiTypeVisitor)this);
                }
                return false;
            }
        };
        PsiTypeElement rElement = method2.getReturnTypeElement();
        if (rElement != null && ((Boolean)rElement.getType().accept((PsiTypeVisitor)visitor)).booleanValue()) {
            return true;
        }
        for (PsiParameter parameter : method2.getParameterList().getParameters()) {
            PsiTypeElement element = parameter.getTypeElement();
            if (element == null || !((Boolean)element.getType().accept((PsiTypeVisitor)visitor)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldBeAbstract(PsiReferenceExpression expression, PsiClass targetClass) {
        return CreateMethodFromUsageFix.shouldBeAbstractImpl(expression, targetClass);
    }

    private static boolean shouldBeAbstractImpl(PsiReferenceExpression expression, PsiClass targetClass) {
        return targetClass.isInterface() && (expression == null || !CreateMethodFromUsageFix.shouldCreateStaticMember(expression, targetClass));
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression referenceExpression = callExpression.getMethodExpression();
        return CreateFromUsageUtils.isValidMethodReference((PsiReference)referenceExpression, callExpression);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    protected PsiMethodCallExpression getMethodCall() {
        return (PsiMethodCallExpression)this.myMethodCall.getElement();
    }
}

