/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class NegationBroadScopeFix
implements IntentionAction {
    private final PsiPrefixExpression myPrefixExpression;

    public NegationBroadScopeFix(@NotNull PsiPrefixExpression prefixExpression) {
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix", "<init>"));
        }
        this.myPrefixExpression = prefixExpression;
    }

    @NotNull
    public String getText() {
        String rop;
        PsiExpression operand = this.myPrefixExpression.getOperand();
        String text = operand == null ? "" : operand.getText() + " ";
        PsiElement parent = this.myPrefixExpression.getParent();
        if (parent instanceof PsiInstanceOfExpression) {
            text = text + "instanceof ";
            PsiTypeElement type = ((PsiInstanceOfExpression)parent).getCheckType();
            rop = type == null ? "" : type.getText();
        } else if (parent instanceof PsiBinaryExpression) {
            text = text + ((PsiBinaryExpression)parent).getOperationSign().getText() + " ";
            PsiExpression rOperand = ((PsiBinaryExpression)parent).getROperand();
            rop = rOperand == null ? "" : rOperand.getText();
        } else {
            rop = "<expr>";
        }
        text = text + rop;
        String string = QuickFixBundle.message("negation.broader.scope.text", text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("negation.broader.scope.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix", "isAvailable"));
        }
        if (!this.myPrefixExpression.isValid() || this.myPrefixExpression.getOperand() == null) {
            return false;
        }
        PsiElement parent = this.myPrefixExpression.getParent();
        if (parent instanceof PsiInstanceOfExpression && ((PsiInstanceOfExpression)parent).getOperand() == this.myPrefixExpression) {
            return true;
        }
        if (!(parent instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
        return binaryExpression.getLOperand() == this.myPrefixExpression && TypeConversionUtil.isBooleanType((PsiType)binaryExpression.getType());
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix", "getElementToMakeWritable"));
        }
        PsiPrefixExpression psiPrefixExpression = this.myPrefixExpression;
        if (psiPrefixExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix", "getElementToMakeWritable"));
        }
        return psiPrefixExpression;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix", "invoke"));
        }
        if (!this.isAvailable(project2, editor, file2)) {
            return;
        }
        PsiExpression operand = this.myPrefixExpression.getOperand();
        PsiElement unnegated = this.myPrefixExpression.replace((PsiElement)operand);
        PsiElement parent = unnegated.getParent();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file2.getProject()).getElementFactory();
        PsiPrefixExpression negated = (PsiPrefixExpression)factory.createExpressionFromText("!(xxx)", parent);
        PsiParenthesizedExpression parentheses = (PsiParenthesizedExpression)negated.getOperand();
        parentheses.getExpression().replace(parent.copy());
        parent.replace((PsiElement)negated);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

