/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.RunRefactoringAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandler;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullAsAbstractUpFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)("#" + PullAsAbstractUpFix.class.getName()));
    private final String myName;

    public PullAsAbstractUpFix(PsiMethod psiMethod, String name) {
        super((PsiElement)psiMethod);
        this.myName = name;
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Pull up" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "getFamilyName"));
        }
        return "Pull up";
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "isAvailable"));
        }
        return startElement instanceof PsiMethod && startElement.isValid() && ((PsiMethod)startElement).getContainingClass() != null;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "invoke"));
        }
        final PsiMethod method2 = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(method2.getContainingFile())) {
            return;
        }
        final PsiClass containingClass = method2.getContainingClass();
        LOG.assertTrue(containingClass != null);
        PsiManager manager = containingClass.getManager();
        if (containingClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)containingClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass != null && manager.isInProject((PsiElement)baseClass)) {
                PullAsAbstractUpFix.pullUp(method2, containingClass, baseClass);
            }
        } else {
            LinkedHashSet<PsiClass> classesToPullUp = new LinkedHashSet<PsiClass>();
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getExtendsListTypes());
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getImplementsListTypes());
            if (classesToPullUp.isEmpty()) {
                new ExtractInterfaceHandler().invoke(project2, new PsiElement[]{containingClass}, null);
            } else if (classesToPullUp.size() == 1) {
                PullAsAbstractUpFix.pullUp(method2, containingClass, (PsiClass)classesToPullUp.iterator().next());
            } else if (editor != null) {
                NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])classesToPullUp.toArray(new PsiClass[classesToPullUp.size()])), (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)"Choose super class", (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                    public boolean execute(@NotNull PsiClass aClass) {
                        if (aClass == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix$1", "execute"));
                        }
                        PullAsAbstractUpFix.pullUp(method2, containingClass, aClass);
                        return false;
                    }
                }, (PsiElement)((PsiElement)classesToPullUp.iterator().next())).showInBestPositionFor(editor);
            }
        }
    }

    private static void collectClassesToPullUp(PsiManager manager, LinkedHashSet<PsiClass> classesToPullUp, PsiClassType[] extendsListTypes) {
        for (PsiClassType extendsListType : extendsListTypes) {
            PsiClass resolve2 = extendsListType.resolve();
            if (resolve2 == null || !manager.isInProject((PsiElement)resolve2)) continue;
            classesToPullUp.add(resolve2);
        }
    }

    private static void pullUp(PsiMethod method2, PsiClass containingClass, PsiClass baseClass) {
        if (!FileModificationService.getInstance().prepareFileForWrite(baseClass.getContainingFile())) {
            return;
        }
        MemberInfo memberInfo = new MemberInfo((PsiMember)method2);
        memberInfo.setChecked(true);
        memberInfo.setToAbstract(true);
        new PullUpProcessor(containingClass, baseClass, new MemberInfo[]{memberInfo}, new DocCommentPolicy(0)).run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void registerQuickFix(@NotNull PsiMethod methodWithOverrides, @NotNull QuickFixActionRegistrar registrar) {
        if (methodWithOverrides == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodWithOverrides", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "registerQuickFix"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix", "registerQuickFix"));
        }
        PsiClass containingClass = methodWithOverrides.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiManager manager = containingClass.getManager();
        boolean canBePulledUp = true;
        String name = "Pull method '" + methodWithOverrides.getName() + "' up";
        if (containingClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)containingClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null) {
                return;
            }
            if (!manager.isInProject((PsiElement)baseClass)) {
                return;
            }
            if (!baseClass.hasModifierProperty("abstract")) {
                name = "Pull method '" + methodWithOverrides.getName() + "' up and make it abstract";
            }
        } else {
            LinkedHashSet<PsiClass> classesToPullUp = new LinkedHashSet<PsiClass>();
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getExtendsListTypes());
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getImplementsListTypes());
            if (classesToPullUp.isEmpty()) {
                name = "Extract method '" + methodWithOverrides.getName() + "' to new interface";
                canBePulledUp = false;
            } else if (classesToPullUp.size() == 1) {
                PsiClass baseClass = (PsiClass)classesToPullUp.iterator().next();
                name = "Pull method '" + methodWithOverrides.getName() + "' to '" + baseClass.getName() + "'";
                if (!baseClass.hasModifierProperty("abstract")) {
                    name = name + " and make it abstract";
                }
            }
            registrar.register((IntentionAction)new RunRefactoringAction(new ExtractInterfaceHandler(), "Extract interface"));
            registrar.register((IntentionAction)new RunRefactoringAction(new ExtractSuperclassHandler(), "Extract superclass"));
        }
        if (canBePulledUp) {
            registrar.register((IntentionAction)new RunRefactoringAction(new JavaPullUpHandler(), "Pull members up"));
        }
        registrar.register((IntentionAction)new PullAsAbstractUpFix(methodWithOverrides, name));
    }
}

