/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameElementFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(RenameElementFix.class);
    private final String myNewName;
    private final String myText;

    public RenameElementFix(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        super((PsiElement)element);
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        assert (vFile != null) : element;
        this.myNewName = vFile.getNameWithoutExtension();
        this.myText = CodeInsightBundle.message((String)"rename.public.class.text", (Object[])new Object[]{element.getName(), this.myNewName});
    }

    public RenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        super((PsiElement)element);
        this.myNewName = newName;
        this.myText = CodeInsightBundle.message((String)"rename.named.element.text", (Object[])new Object[]{element.getName(), this.myNewName});
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.element.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        if (this.isAvailable(project2, null, file2)) {
            LOG.assertTrue(file2 == startElement.getContainingFile());
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            RenameProcessor processor2 = new RenameProcessor(project2, startElement, this.myNewName, false, false);
            processor2.run();
        }
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        return startElement.isValid() && RenameUtil.isValidName(project2, startElement, this.myNewName);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

