/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.CallArgumentInfo;
import com.intellij.codeInsight.hints.CallInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.JavaHintUtilsKt;
import com.intellij.codeInsight.hints.JavaInlayParameterHintsProvider;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl;
import com.intellij.psi.impl.source.tree.java.PsiNewExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J+\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010%\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020)H\u0002\u00a8\u0006*"}, d2={"Lcom/intellij/codeInsight/hints/JavaInlayHintsProvider;", "", "()V", "createHintSet", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "info", "Lcom/intellij/codeInsight/hints/CallInfo;", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "createHints", "callExpression", "Lcom/intellij/psi/PsiCallExpression;", "createHintsForResolvedMethod", "resolveResult", "Lcom/intellij/psi/ResolveResult;", "createInlayInfo", "callArgument", "Lcom/intellij/psi/PsiExpression;", "methodParam", "Lcom/intellij/psi/PsiParameter;", "createMergedHints", "results", "", "(Lcom/intellij/psi/PsiCallExpression;[Lcom/intellij/psi/ResolveResult;)Ljava/util/Set;", "createSameTypeInlays", "", "args", "Lcom/intellij/codeInsight/hints/CallArgumentInfo;", "createUnclearInlays", "getCallInfo", "method", "Lcom/intellij/psi/PsiMethod;", "getVarArgInlay", "isBuilderLike", "", "expression", "isMethodToShow", "isParamNameContainedInMethodName", "parameter", "isUnclearExpression", "Lcom/intellij/psi/PsiElement;", "java-impl"})
public final class JavaInlayHintsProvider {
    public static final JavaInlayHintsProvider INSTANCE;

    @NotNull
    public final Set<InlayInfo> createHints(@NotNull PsiCallExpression callExpression) {
        Set<InlayInfo> set2;
        JavaResolveResult resolveResult;
        Intrinsics.checkParameterIsNotNull((Object)callExpression, (String)"callExpression");
        JavaResolveResult javaResolveResult = resolveResult = callExpression.resolveMethodGenerics();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResult, (String)"resolveResult");
        Set<InlayInfo> hints = this.createHintsForResolvedMethod(callExpression, (ResolveResult)javaResolveResult);
        Collection collection = hints;
        if (!collection.isEmpty()) {
            return hints;
        }
        collection = callExpression;
        if (collection instanceof PsiMethodCallExpressionImpl) {
            JavaResolveResult[] javaResolveResultArray = ((PsiMethodCallExpressionImpl)callExpression).getMethodExpression().multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResultArray, (String)"callExpression.methodExp\u2026ssion.multiResolve(false)");
            set2 = this.createMergedHints(callExpression, (ResolveResult[])javaResolveResultArray);
        } else if (collection instanceof PsiNewExpressionImpl) {
            ResolveResult[] resolveResultArray = ((PsiNewExpressionImpl)callExpression).getConstructorFakeReference().multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"callExpression.construct\u2026rence.multiResolve(false)");
            set2 = this.createMergedHints(callExpression, resolveResultArray);
        } else {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<InlayInfo> createMergedHints(PsiCallExpression callExpression, ResolveResult[] results) {
        Set it;
        List resultSet;
        Iterable $receiver$iv;
        block10: {
            block9: {
                boolean bl;
                block8: {
                    ResolveResult it2;
                    Iterable $receiver$iv$iv;
                    Object[] objectArray = results;
                    void var5_4 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList();
                    for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                        void element$iv$iv = $receiver$iv$iv[j];
                        it2 = (ResolveResult)element$iv$iv;
                        if (!(it2.getElement() != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    Iterator iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        it2 = (ResolveResult)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Set<InlayInfo> set2 = INSTANCE.createHintsForResolvedMethod(callExpression, it2);
                        collection.add(set2);
                    }
                    resultSet = (List)destination$iv$iv;
                    if (resultSet.isEmpty()) break block9;
                    $receiver$iv = resultSet;
                    for (Object element$iv : $receiver$iv) {
                        it = (Set)element$iv;
                        if (!it.isEmpty()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                if (!bl) break block10;
            }
            return SetsKt.emptySet();
        }
        $receiver$iv = resultSet;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void right;
            it = (Set)iterator$iv.next();
            Set left = (Set)accumulator$iv;
            accumulator$iv = CollectionsKt.intersect((Iterable)left, (Iterable)((Iterable)right));
        }
        return (Set)accumulator$iv;
    }

    private final Set<InlayInfo> createHintsForResolvedMethod(PsiCallExpression callExpression, ResolveResult resolveResult) {
        JavaResolveResult substitutor;
        JavaResolveResult javaResolveResult;
        PsiElement element = resolveResult.getElement();
        ResolveResult resolveResult2 = resolveResult;
        if (!(resolveResult2 instanceof JavaResolveResult)) {
            resolveResult2 = null;
        }
        if ((javaResolveResult = (JavaResolveResult)resolveResult2) == null || (javaResolveResult = javaResolveResult.getSubstitutor()) == null) {
            javaResolveResult = substitutor = PsiSubstitutor.EMPTY;
        }
        if (element instanceof PsiMethod && this.isMethodToShow((PsiMethod)element, callExpression)) {
            CallInfo info = this.getCallInfo(callExpression, (PsiMethod)element);
            JavaResolveResult javaResolveResult2 = substitutor;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResult2, (String)"substitutor");
            return this.createHintSet(info, (PsiSubstitutor)javaResolveResult2);
        }
        return SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<InlayInfo> createHintSet(CallInfo info, PsiSubstitutor substitutor) {
        Set resultSet;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)info.getRegularArgs();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallArgumentInfo it = (CallArgumentInfo)element$iv$iv;
            if (!JavaHintUtilsKt.access$isAssignable(it, substitutor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List args = (List)destination$iv$iv;
        Set $receiver = resultSet = SetsKt.mutableSetOf((Object[])new InlayInfo[0]);
        InlayInfo inlayInfo = INSTANCE.getVarArgInlay(info);
        if (inlayInfo != null) {
            Collection it = destination$iv$iv = inlayInfo;
            $receiver.add(it);
        }
        JavaInlayParameterHintsProvider hintsProvider = JavaInlayParameterHintsProvider.Companion.getInstance();
        if (hintsProvider.isShowForParamsWithSameType().get()) {
            $receiver.addAll((Collection)INSTANCE.createSameTypeInlays(args));
        }
        $receiver.addAll((Collection)INSTANCE.createUnclearInlays(args));
        return resultSet;
    }

    private final boolean isMethodToShow(PsiMethod method2, PsiCallExpression callExpression) {
        PsiParameter[] params = method2.getParameterList().getParameters();
        Object[] objectArray = params;
        if (objectArray.length == 0) {
            return false;
        }
        if (((Object[])params).length == 1) {
            JavaInlayParameterHintsProvider hintsProvider = JavaInlayParameterHintsProvider.Companion.getInstance();
            if (hintsProvider.isDoNotShowForBuilderLikeMethods().get() && this.isBuilderLike(callExpression, method2)) {
                return false;
            }
            if (hintsProvider.isDoNotShowIfMethodNameContainsParameterName().get()) {
                PsiParameter psiParameter = params[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"params[0]");
                if (this.isParamNameContainedInMethodName(psiParameter, method2)) {
                    return false;
                }
            }
        }
        return true;
    }

    private final List<InlayInfo> createUnclearInlays(List<CallArgumentInfo> args) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = args;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallArgumentInfo it = (CallArgumentInfo)element$iv$iv;
            if (!INSTANCE.isUnclearExpression((PsiElement)it.getArgument())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            InlayInfo inlayInfo;
            Object element$iv$iv = element$iv$iv$iv;
            CallArgumentInfo it = (CallArgumentInfo)element$iv$iv;
            if (INSTANCE.createInlayInfo(it.getArgument(), it.getParameter()) == null) continue;
            InlayInfo it$iv$iv = inlayInfo;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final InlayInfo getVarArgInlay(CallInfo info) {
        boolean hasUnclearExpressions;
        Object v0;
        block3: {
            Iterable iterable;
            if (info.getVarArg() == null || info.getVarArgExpressions().isEmpty()) {
                return null;
            }
            Iterable iterable2 = iterable = (Iterable)info.getVarArgExpressions();
            for (Object t : iterable2) {
                PsiExpression it = (PsiExpression)t;
                if (!INSTANCE.isUnclearExpression((PsiElement)it)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        boolean bl = hasUnclearExpressions = v0 != null;
        if (hasUnclearExpressions) {
            return this.createInlayInfo((PsiExpression)CollectionsKt.first(info.getVarArgExpressions()), info.getVarArg());
        }
        return null;
    }

    private final boolean isBuilderLike(PsiCallExpression expression, PsiMethod method2) {
        if (expression instanceof PsiNewExpression) {
            return false;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)method2.getReturnType());
        if (psiType == null) {
            return false;
        }
        PsiType returnType = psiType;
        Object object = method2.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return false;
        }
        Object calledMethodClassFqn = object;
        return returnType.equalsToText((String)calledMethodClassFqn);
    }

    private final boolean isParamNameContainedInMethodName(PsiParameter parameter, PsiMethod method2) {
        String string = parameter.getName();
        if (string == null) {
            return false;
        }
        String parameterName = string;
        if (parameterName.length() > 1) {
            CharSequence charSequence = method2.getName();
            String string2 = parameterName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"parameterName");
            return StringsKt.contains((CharSequence)charSequence, (CharSequence)string2, (boolean)true);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlayInfo> createSameTypeInlays(List<CallArgumentInfo> args) {
        Iterable $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)args;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            CallArgumentInfo callArgumentInfo = (CallArgumentInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = JavaHintUtilsKt.access$typeText(it.getParameter());
            collection.add(string);
        }
        List all = (List)destination$iv$iv;
        List duplicated = CollectionsKt.toMutableList((Collection)all);
        Iterable $receiver$iv2 = CollectionsKt.distinct((Iterable)all);
        for (Object element$iv : $receiver$iv2) {
            String it = (String)element$iv;
            duplicated.remove(it);
        }
        $receiver$iv2 = args;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallArgumentInfo it = (CallArgumentInfo)element$iv$iv;
            if (!duplicated.contains(JavaHintUtilsKt.access$typeText(it.getParameter()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            InlayInfo inlayInfo;
            Object element$iv$iv = element$iv$iv$iv;
            CallArgumentInfo it = (CallArgumentInfo)element$iv$iv;
            if (INSTANCE.createInlayInfo(it.getArgument(), it.getParameter()) == null) continue;
            InlayInfo it$iv$iv = inlayInfo;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final InlayInfo createInlayInfo(PsiExpression callArgument, PsiParameter methodParam) {
        String string = methodParam.getName();
        if (string == null) {
            return null;
        }
        String paramName = string;
        String paramToShow = (methodParam.getType() instanceof PsiEllipsisType ? "..." : "") + paramName;
        return new InlayInfo(paramToShow, callArgument.getTextRange().getStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    private final CallInfo getCallInfo(PsiCallExpression callExpression, PsiMethod method2) {
        void $receiver$iv$iv;
        void $receiver$iv;
        PsiParameter[] params = method2.getParameterList().getParameters();
        PsiParameter psiParameter = (PsiParameter)ArraysKt.lastOrNull((Object[])params);
        boolean hasVarArg = psiParameter != null ? psiParameter.isVarArgs() : false;
        int regularParamsCount = hasVarArg ? ((Object[])params).length - 1 : ((Object[])params).length;
        PsiExpression[] psiExpressionArray = callExpression.getArgumentList();
        if (psiExpressionArray == null || (psiExpressionArray = psiExpressionArray.getExpressions()) == null) {
            psiExpressionArray = new PsiExpression[]{};
        }
        PsiExpression[] arguments = psiExpressionArray;
        Iterable iterable = ArraysKt.take((Object[])params, (int)regularParamsCount);
        Intrinsics.checkExpressionValueIsNotNull((Object)arguments, (String)"arguments");
        Iterable iterable2 = CollectionsKt.zip((Iterable)iterable, (Object[])arguments);
        void var9_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object object = it.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.first");
            PsiParameter psiParameter2 = (PsiParameter)object;
            Object object2 = it.getSecond();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it.second");
            CallArgumentInfo callArgumentInfo = new CallArgumentInfo(psiParameter2, (PsiExpression)object2);
            collection.add(callArgumentInfo);
        }
        List regularArgInfos = (List)destination$iv$iv;
        PsiParameter varargParam = hasVarArg ? (PsiParameter)ArraysKt.last((Object[])params) : null;
        List varargExpressions = ArraysKt.drop((Object[])arguments, (int)regularParamsCount);
        return new CallInfo(regularArgInfos, varargParam, varargExpressions);
    }

    private final boolean isUnclearExpression(PsiElement callArgument) {
        boolean bl;
        PsiElement psiElement = callArgument;
        if (psiElement instanceof PsiLiteralExpression) {
            bl = true;
        } else if (psiElement instanceof PsiThisExpression) {
            bl = true;
        } else if (psiElement instanceof PsiBinaryExpression) {
            bl = true;
        } else if (psiElement instanceof PsiPolyadicExpression) {
            bl = true;
        } else if (psiElement instanceof PsiPrefixExpression) {
            IElementType tokenType = ((PsiPrefixExpression)callArgument).getOperationTokenType();
            boolean isLiteral = ((PsiPrefixExpression)callArgument).getOperand() instanceof PsiLiteralExpression;
            bl = isLiteral && (Intrinsics.areEqual((Object)JavaTokenType.MINUS, (Object)tokenType) || Intrinsics.areEqual((Object)JavaTokenType.PLUS, (Object)tokenType));
        } else {
            bl = false;
        }
        boolean isShowHint = bl;
        return isShowHint;
    }

    private JavaInlayHintsProvider() {
        INSTANCE = this;
    }

    static {
        new JavaInlayHintsProvider();
    }
}

