/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertCompareToToEqualsIntention
extends BaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "invoke"));
        }
        CompareToResult compareToResult = CompareToResult.findCompareTo(element);
        assert (compareToResult != null);
        PsiExpression qualifier = compareToResult.getQualifier();
        PsiExpression argument = compareToResult.getArgument();
        StringBuilder text = new StringBuilder();
        if (!compareToResult.isEqEq()) {
            text.append('!');
        }
        if (qualifier != null) {
            text.append(qualifier.getText()).append('.');
        }
        text.append("equals(").append(argument.getText()).append(')');
        PsiExpression newExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(text.toString(), null);
        PsiElement result2 = compareToResult.getBinaryExpression().replace((PsiElement)newExpression);
        editor.getCaretModel().moveToOffset(result2.getTextOffset() + result2.getTextLength());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "isAvailable"));
        }
        return CompareToResult.findCompareTo(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert 'compareTo()' expression to 'equals()' call" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "getFamilyName"));
        }
        return "Convert 'compareTo()' expression to 'equals()' call";
    }

    @NotNull
    public String getText() {
        if ("Convert 'compareTo()' expression to 'equals()' call (may change semantics)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertCompareToToEqualsIntention", "getText"));
        }
        return "Convert 'compareTo()' expression to 'equals()' call (may change semantics)";
    }

    private static class CompareToResult {
        private final PsiBinaryExpression myBinaryExpression;
        private final PsiMethodCallExpression myCompareToCall;

        private CompareToResult(PsiBinaryExpression binaryExpression, PsiMethodCallExpression compareToCall) {
            this.myBinaryExpression = binaryExpression;
            this.myCompareToCall = compareToCall;
        }

        public PsiBinaryExpression getBinaryExpression() {
            return this.myBinaryExpression;
        }

        public boolean isEqEq() {
            return JavaTokenType.EQEQ.equals(this.myBinaryExpression.getOperationTokenType());
        }

        public PsiExpression getArgument() {
            return this.myCompareToCall.getArgumentList().getExpressions()[0];
        }

        public PsiExpression getQualifier() {
            return this.myCompareToCall.getMethodExpression().getQualifierExpression();
        }

        @Nullable
        static CompareToResult findCompareTo(PsiElement element) {
            PsiMethodCallExpression compareToExpression;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiBinaryExpression.class);
            if (binaryExpression == null) {
                return null;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType) && !JavaTokenType.EQEQ.equals(tokenType)) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (lhs instanceof PsiMethodCallExpression) {
                compareToExpression = (PsiMethodCallExpression)lhs;
                if (!MethodCallUtils.isCompareToCall(compareToExpression) || !ExpressionUtils.isZero(rhs)) {
                    return null;
                }
            } else if (rhs instanceof PsiMethodCallExpression) {
                compareToExpression = (PsiMethodCallExpression)rhs;
                if (!ExpressionUtils.isZero(lhs) || !MethodCallUtils.isCompareToCall(compareToExpression)) {
                    return null;
                }
            } else {
                return null;
            }
            return new CompareToResult(binaryExpression, compareToExpression);
        }
    }
}

