/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionListStep
implements ListPopupStep<IntentionActionWithTextCaching>,
SpeedSearchFilter<IntentionActionWithTextCaching> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionListStep");
    private final Set<IntentionActionWithTextCaching> myCachedIntentions;
    private final Set<IntentionActionWithTextCaching> myCachedErrorFixes;
    private final Set<IntentionActionWithTextCaching> myCachedInspectionFixes;
    private final Set<IntentionActionWithTextCaching> myCachedGutters;
    private final Set<IntentionActionWithTextCaching> myCachedNotifications;
    private final IntentionManagerSettings mySettings;
    @Nullable
    private final IntentionHintComponent myIntentionHintComponent;
    @Nullable
    private final Editor myEditor;
    private final PsiFile myFile;
    private final Project myProject;
    private static final TObjectHashingStrategy<IntentionActionWithTextCaching> ACTION_TEXT_AND_CLASS_EQUALS = new TObjectHashingStrategy<IntentionActionWithTextCaching>(){

        public int computeHashCode(IntentionActionWithTextCaching object) {
            return object.getText().hashCode();
        }

        public boolean equals(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
            return o1.getAction().getClass() == o2.getAction().getClass() && o1.getText().equals(o2.getText());
        }
    };
    private Runnable myFinalRunnable;

    public IntentionListStep(@Nullable IntentionHintComponent intentionHintComponent, @NotNull ShowIntentionsPass.IntentionsInfo intentions, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull Project project2) {
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/intention/impl/IntentionListStep", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/IntentionListStep", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/IntentionListStep", "<init>"));
        }
        this(intentionHintComponent, editor, file2, project2);
        this.wrapAndUpdateActions(intentions, false);
    }

    IntentionListStep(@Nullable IntentionHintComponent intentionHintComponent, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/IntentionListStep", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/IntentionListStep", "<init>"));
        }
        this.myCachedIntentions = ContainerUtil.newConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myCachedErrorFixes = ContainerUtil.newConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myCachedInspectionFixes = ContainerUtil.newConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myCachedGutters = ContainerUtil.newConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myCachedNotifications = ContainerUtil.newConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myIntentionHintComponent = intentionHintComponent;
        this.myEditor = editor;
        this.myFile = file2;
        this.myProject = project2;
        this.mySettings = IntentionManagerSettings.getInstance();
    }

    boolean wrapAndUpdateActions(@NotNull ShowIntentionsPass.IntentionsInfo intentions, boolean callUpdate) {
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/intention/impl/IntentionListStep", "wrapAndUpdateActions"));
        }
        boolean changed = this.wrapActionsTo(intentions.errorFixesToShow, this.myCachedErrorFixes, callUpdate);
        changed |= this.wrapActionsTo(intentions.inspectionFixesToShow, this.myCachedInspectionFixes, callUpdate);
        changed |= this.wrapActionsTo(intentions.intentionsToShow, this.myCachedIntentions, callUpdate);
        changed |= this.wrapActionsTo(intentions.guttersToShow, this.myCachedGutters, callUpdate);
        return changed |= this.wrapActionsTo(intentions.notificationActionsToShow, this.myCachedNotifications, callUpdate);
    }

    private boolean wrapActionsTo(@NotNull List<HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<IntentionActionWithTextCaching> cachedActions, boolean callUpdate) {
        if (newDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDescriptors", "com/intellij/codeInsight/intention/impl/IntentionListStep", "wrapActionsTo"));
        }
        if (cachedActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedActions", "com/intellij/codeInsight/intention/impl/IntentionListStep", "wrapActionsTo"));
        }
        boolean changed = false;
        if (this.myEditor == null) {
            LOG.assertTrue(!callUpdate);
            for (HighlightInfo.IntentionActionDescriptor descriptor : newDescriptors) {
                changed |= cachedActions.add(this.wrapAction(descriptor, (PsiElement)this.myFile, this.myFile, null));
            }
        } else {
            Editor injectedEditor;
            PsiFile injectedFile;
            PsiFile hostElement;
            PsiFile element;
            int fileOffset;
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int n = fileOffset = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
            if (this.myFile instanceof PsiCompiledElement) {
                hostElement = element = this.myFile;
            } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
                FileViewProvider viewProvider = this.myFile.getViewProvider();
                hostElement = element = viewProvider.findElementAt(fileOffset, viewProvider.getBaseLanguage());
            } else {
                hostElement = this.myFile.getViewProvider().findElementAt(fileOffset, this.myFile.getLanguage());
                element = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, fileOffset);
            }
            if (element == null || element == hostElement) {
                injectedFile = this.myFile;
                injectedEditor = this.myEditor;
            } else {
                injectedFile = element.getContainingFile();
                injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
            }
            Iterator<IntentionActionWithTextCaching> iterator = cachedActions.iterator();
            while (iterator.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator.next();
                IntentionAction action = cachedAction.getAction();
                if (ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action) || hostElement != element && (element == null || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) continue;
                iterator.remove();
                changed = true;
            }
            THashSet wrappedNew = new THashSet(newDescriptors.size(), ACTION_TEXT_AND_CLASS_EQUALS);
            for (HighlightInfo.IntentionActionDescriptor descriptor : newDescriptors) {
                IntentionActionWithTextCaching cachedAction;
                IntentionAction action = descriptor.getAction();
                if (element != null && element != hostElement && (!callUpdate || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) {
                    cachedAction = this.wrapAction(descriptor, (PsiElement)element, injectedFile, injectedEditor);
                    wrappedNew.add(cachedAction);
                    changed |= cachedActions.add(cachedAction);
                    continue;
                }
                if (hostElement == null || callUpdate && !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action)) continue;
                cachedAction = this.wrapAction(descriptor, (PsiElement)hostElement, this.myFile, this.myEditor);
                wrappedNew.add(cachedAction);
                changed |= cachedActions.add(cachedAction);
            }
            Iterator<IntentionActionWithTextCaching> iterator2 = cachedActions.iterator();
            while (iterator2.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator2.next();
                if (wrappedNew.contains(cachedAction)) continue;
                iterator2.remove();
                changed = true;
            }
        }
        return changed;
    }

    @NotNull
    IntentionActionWithTextCaching wrapAction(@NotNull HighlightInfo.IntentionActionDescriptor descriptor, @Nullable PsiElement element, @Nullable PsiFile containingFile, @Nullable Editor containingEditor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/intention/impl/IntentionListStep", "wrapAction"));
        }
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor);
        if (element == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionListStep", "wrapAction"));
            }
            return intentionActionWithTextCaching;
        }
        List<IntentionAction> options = descriptor.getOptions(element, containingEditor);
        if (options == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionListStep", "wrapAction"));
            }
            return intentionActionWithTextCaching;
        }
        for (IntentionAction option : options) {
            boolean isInspectionFix;
            if (containingFile == null || containingEditor == null || this.myEditor == null ? !option.isAvailable(this.myProject, containingEditor, containingFile) && (containingEditor == this.myEditor || !option.isAvailable(this.myProject, this.myEditor, this.myFile)) : !ShowIntentionActionsHandler.availableFor(containingFile, containingEditor, option) && (containingEditor == this.myEditor || !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, option))) continue;
            IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(option);
            boolean isErrorFix = this.myCachedErrorFixes.contains(textCaching);
            if (isErrorFix) {
                cachedAction.addErrorFix(option);
            }
            if (isInspectionFix = this.myCachedInspectionFixes.contains(textCaching)) {
                cachedAction.addInspectionFix(option);
                continue;
            }
            cachedAction.addIntention(option);
        }
        IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
        if (intentionActionWithTextCaching == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionListStep", "wrapAction"));
        }
        return intentionActionWithTextCaching;
    }

    public String getTitle() {
        return null;
    }

    public boolean isSelectable(IntentionActionWithTextCaching action) {
        return true;
    }

    public PopupStep onChosen(IntentionActionWithTextCaching action, boolean finalChoice) {
        if (finalChoice && !(action.getAction() instanceof AbstractEmptyIntentionAction)) {
            this.applyAction(action);
            return FINAL_CHOICE;
        }
        if (this.hasSubstep(action)) {
            return this.getSubStep(action, action.getToolName());
        }
        return FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    private void applyAction(IntentionActionWithTextCaching cachedAction) {
        this.myFinalRunnable = () -> {
            PsiFile file2;
            HintManager.getInstance().hideAllHints();
            if (this.myProject.isDisposed() || this.myEditor != null && this.myEditor.isDisposed()) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject) && !DumbService.isDumbAware((Object)cachedAction)) {
                DumbService.getInstance((Project)this.myProject).showDumbModeNotification(cachedAction.getText() + " is not available during indexing");
                return;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            PsiFile psiFile = file2 = this.myEditor != null ? PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)this.myProject) : this.myFile;
            if (file2 == null) {
                return;
            }
            ShowIntentionActionsHandler.chooseActionAndInvoke(file2, this.myEditor, cachedAction.getAction(), cachedAction.getText(), this.myProject);
        };
    }

    @NotNull
    IntentionListStep getSubStep(@NotNull IntentionActionWithTextCaching action, final String title) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionListStep", "getSubStep"));
        }
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        for (IntentionAction optionIntention : action.getOptionIntentions()) {
            intentions.intentionsToShow.add(new HighlightInfo.IntentionActionDescriptor(optionIntention, IntentionListStep.getIcon(optionIntention)));
        }
        for (IntentionAction optionFix : action.getOptionErrorFixes()) {
            intentions.errorFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        for (IntentionAction optionFix : action.getOptionInspectionFixes()) {
            intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        IntentionListStep intentionListStep = new IntentionListStep(this.myIntentionHintComponent, intentions, this.myEditor, this.myFile, this.myProject){

            @Override
            public String getTitle() {
                return title;
            }
        };
        if (intentionListStep == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionListStep", "getSubStep"));
        }
        return intentionListStep;
    }

    private static Icon getIcon(IntentionAction optionIntention) {
        return optionIntention instanceof Iconable ? ((Iconable)optionIntention).getIcon(0) : null;
    }

    public Map<IntentionAction, List<IntentionAction>> getActionsWithSubActions() {
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (IntentionActionWithTextCaching cached : this.getValues()) {
            IntentionAction action = cached.getAction();
            if (ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, action) == null) continue;
            List<IntentionActionWithTextCaching> subActions = this.getSubStep(cached, cached.getToolName()).getValues();
            List options = subActions.stream().map(IntentionActionWithTextCaching::getAction).filter(option -> ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, option) != null).collect(Collectors.toList());
            result2.put(action, options);
        }
        return result2;
    }

    public boolean hasSubstep(IntentionActionWithTextCaching action) {
        return action.getOptionIntentions().size() + action.getOptionErrorFixes().size() > 0;
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getValues() {
        List<IntentionActionWithTextCaching> result2 = new ArrayList<IntentionActionWithTextCaching>(this.myCachedErrorFixes);
        result2.addAll(this.myCachedInspectionFixes);
        result2.addAll(this.myCachedIntentions);
        result2.addAll(this.myCachedGutters);
        result2.addAll(this.myCachedNotifications);
        result2 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(result2);
        Collections.sort(result2, (o1, o2) -> {
            int weight2;
            int weight1 = this.getWeight((IntentionActionWithTextCaching)o1);
            if (weight1 != (weight2 = this.getWeight((IntentionActionWithTextCaching)o2))) {
                return weight2 - weight1;
            }
            return o1.compareTo((IntentionActionWithTextCaching)o2);
        });
        List<IntentionActionWithTextCaching> list = result2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionListStep", "getValues"));
        }
        return list;
    }

    private int getWeight(IntentionActionWithTextCaching action) {
        IntentionAction a = action.getAction();
        int group = this.getGroup(action);
        if (a instanceof IntentionActionWrapper) {
            a = ((IntentionActionWrapper)a).getDelegate();
        }
        if (a instanceof IntentionWrapper) {
            a = ((IntentionWrapper)a).getAction();
        }
        if (a instanceof HighPriorityAction) {
            return group + 3;
        }
        if (a instanceof LowPriorityAction) {
            return group - 3;
        }
        if (a instanceof SuppressIntentionActionFromFix && ((SuppressIntentionActionFromFix)a).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
            return group - 1;
        }
        if (a instanceof QuickFixWrapper) {
            LocalQuickFix quickFix = ((QuickFixWrapper)a).getFix();
            if (quickFix instanceof HighPriorityAction) {
                return group + 3;
            }
            if (quickFix instanceof LowPriorityAction) {
                return group - 3;
            }
        }
        return group;
    }

    private int getGroup(IntentionActionWithTextCaching action) {
        if (this.myCachedErrorFixes.contains(action)) {
            return 20;
        }
        if (this.myCachedInspectionFixes.contains(action)) {
            return 10;
        }
        if (this.myCachedNotifications.contains(action)) {
            return 7;
        }
        if (this.myCachedGutters.contains(action)) {
            return 5;
        }
        if (action.getAction() instanceof EmptyIntentionAction) {
            return -10;
        }
        return 0;
    }

    @NotNull
    public String getTextFor(IntentionActionWithTextCaching action) {
        String text = action.getAction().getText();
        if (LOG.isDebugEnabled() && text.startsWith("<html>")) {
            LOG.info("IntentionAction.getText() returned HTML: action=" + action + " text=" + text);
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionListStep", "getTextFor"));
        }
        return string;
    }

    public Icon getIconFor(IntentionActionWithTextCaching value) {
        Icon icon;
        IntentionAction action;
        if (value.getIcon() != null) {
            return value.getIcon();
        }
        IntentionAction iconable = action = value.getAction();
        if (action instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action).getFix();
        } else if (action instanceof IntentionActionWrapper) {
            iconable = ((IntentionActionWrapper)action).getDelegate();
        }
        if (iconable instanceof Iconable && (icon = ((Iconable)iconable).getIcon(0)) != null) {
            return icon;
        }
        if (this.mySettings.isShowLightBulb(action)) {
            return this.myCachedErrorFixes.contains(value) ? AllIcons.Actions.QuickfixBulb : (this.myCachedInspectionFixes.contains(value) ? AllIcons.Actions.IntentionBulb : AllIcons.Actions.RealIntentionBulb);
        }
        return this.myCachedErrorFixes.contains(value) ? AllIcons.Actions.QuickfixOffBulb : AllIcons.Actions.RealIntentionOffBulb;
    }

    public void canceled() {
        if (this.myIntentionHintComponent != null) {
            this.myIntentionHintComponent.canceled(this);
        }
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public ListSeparator getSeparatorAbove(IntentionActionWithTextCaching value) {
        List<IntentionActionWithTextCaching> values = this.getValues();
        int index = values.indexOf(value);
        if (index <= 0) {
            return null;
        }
        IntentionActionWithTextCaching prev = values.get(index - 1);
        if (this.getGroup(value) != this.getGroup(prev)) {
            return new ListSeparator();
        }
        return null;
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<IntentionActionWithTextCaching> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public SpeedSearchFilter<IntentionActionWithTextCaching> getSpeedSearchFilter() {
        return this;
    }

    public boolean canBeHidden(IntentionActionWithTextCaching value) {
        return true;
    }

    public String getIndexedString(IntentionActionWithTextCaching value) {
        return this.getTextFor(value);
    }
}

