/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousCanBeLambdaInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + AnonymousCanBeLambdaInspection.class.getName()));
    public boolean reportNotAnnotatedInterfaces = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Anonymous type can be replaced with lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getDisplayName"));
        }
        return "Anonymous type can be replaced with lambda";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2Lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getShortName"));
        }
        return "Convert2Lambda";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report when interface is not annotated with @FunctionalInterface", (InspectionProfileEntry)this, "reportNotAnnotatedInterfaces");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                PsiElement lambdaContext;
                super.visitAnonymousClass(aClass);
                PsiElement parent = aClass.getParent();
                PsiElement psiElement = lambdaContext = parent != null ? parent.getParent() : null;
                if (lambdaContext != null && (LambdaUtil.isValidLambdaContext((PsiElement)lambdaContext) || !(lambdaContext instanceof PsiExpressionStatement)) && AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, false, isOnTheFly || AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet())) {
                    PsiElement lBrace = aClass.getLBrace();
                    LOG.assertTrue(lBrace != null);
                    TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                    ProblemHighlightType type = ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                    if (isOnTheFly && !AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces) {
                        PsiClass baseClass = aClass.getBaseClassType().resolve();
                        LOG.assertTrue(baseClass != null);
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, (String)"java.lang.FunctionalInterface", (boolean)false, (boolean)false)) {
                            type = ProblemHighlightType.INFORMATION;
                        }
                    }
                    ProblemDescriptorBase descriptor = new ProblemDescriptorBase(parent, parent, "Anonymous #ref #loc can be replaced with lambda", new LocalQuickFix[]{new ReplaceWithLambdaFix()}, type, false, rangeInElement, type != ProblemHighlightType.INFORMATION, true);
                    holder.registerProblem((ProblemDescriptor)descriptor);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    static boolean hasRuntimeAnnotations(PsiMethod method2, @NotNull Set<String> runtimeAnnotationsToIgnore) {
        PsiAnnotation[] annotations;
        if (runtimeAnnotationsToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtimeAnnotationsToIgnore", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "hasRuntimeAnnotations"));
        }
        for (PsiAnnotation annotation : annotations = method2.getModifierList().getAnnotations()) {
            PsiClass containingClass;
            PsiElement resolved;
            PsiAnnotationMemberValue value;
            PsiAnnotation retentionAnno;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = target = ref != null ? ref.resolve() : null;
            if (!(target instanceof PsiClass) || runtimeAnnotationsToIgnore.contains(((PsiClass)target).getQualifiedName()) || (retentionAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)target), (String[])new String[]{Retention.class.getName()})) == null || !((value = retentionAnno.findAttributeValue("value")) instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) || !RetentionPolicy.RUNTIME.name().equals(((PsiField)resolved).getName()) || (containingClass = ((PsiField)resolved).getContainingClass()) == null || !RetentionPolicy.class.getName().equals(containingClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasForbiddenRefsInsideBody(PsiMethod method2, PsiAnonymousClass aClass) {
        ForbiddenRefsChecker checker = new ForbiddenRefsChecker(method2, aClass);
        PsiCodeBlock body = method2.getBody();
        LOG.assertTrue(body != null);
        body.accept((PsiElementVisitor)checker);
        return checker.hasForbiddenRefs();
    }

    private static PsiType getInferredType(PsiAnonymousClass aClass, PsiMethod method2) {
        PsiExpression expression = (PsiExpression)aClass.getParent();
        PsiType psiType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression);
        if (psiType != null) {
            return psiType;
        }
        PsiExpression topExpr = expression;
        while (topExpr.getParent() instanceof PsiParenthesizedExpression) {
            topExpr = (PsiExpression)topExpr.getParent();
        }
        PsiCall call = LambdaUtil.treeWalkUp((PsiElement)topExpr);
        if (call != null && call.resolveMethod() != null) {
            int offsetInTopCall = aClass.getTextRange().getStartOffset() - call.getTextRange().getStartOffset();
            PsiCall copyCall = LambdaUtil.copyTopLevelCall((PsiCall)call);
            if (copyCall == null) {
                return null;
            }
            PsiAnonymousClass classArg = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)copyCall.findElementAt(offsetInTopCall), PsiAnonymousClass.class);
            if (classArg != null) {
                PsiExpression lambda2 = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createExpressionFromText(ReplaceWithLambdaFix.composeLambdaText(method2), (PsiElement)expression);
                lambda2 = (PsiExpression)classArg.getParent().replace((PsiElement)lambda2);
                ((PsiLambdaExpression)lambda2).getBody().replace((PsiElement)method2.getBody());
                if (copyCall.resolveMethod() == null) {
                    return PsiType.NULL;
                }
                PsiType interfaceType = ((PsiLambdaExpression)lambda2).getFunctionalInterfaceType();
                return interfaceType;
            }
        }
        return PsiType.NULL;
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRuntimeAnnotations", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "canBeConvertedToLambda"));
        }
        return AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, acceptParameterizedFunctionTypes, true, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, Set<String> ignoredRuntimeAnnotations) {
        PsiMethod[] methods = aClass.getMethods();
        if (methods.length != 1) {
            return false;
        }
        PsiMethod method2 = methods[0];
        return aClass.getFields().length == 0 && aClass.getInnerClasses().length == 0 && aClass.getInitializers().length == 0 && method2.getBody() != null && method2.getDocComment() == null && !AnonymousCanBeLambdaInspection.hasRuntimeAnnotations(method2, ignoredRuntimeAnnotations) && !method2.hasModifierProperty("synchronized") && !AnonymousCanBeLambdaInspection.hasForbiddenRefsInsideBody(method2, aClass);
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, boolean reportNotAnnotatedInterfaces, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRuntimeAnnotations", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "canBeConvertedToLambda"));
        }
        if (PsiUtil.getLanguageLevel((PsiElement)aClass).isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiClassType baseClassType = aClass.getBaseClassType();
            PsiClassType.ClassResolveResult resolveResult = baseClassType.resolveGenerics();
            PsiClass baseClass = resolveResult.getElement();
            if (baseClass == null || !reportNotAnnotatedInterfaces && !AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, (String)"java.lang.FunctionalInterface", (boolean)false, (boolean)false)) {
                return false;
            }
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
            if (interfaceMethod != null && (acceptParameterizedFunctionTypes || !interfaceMethod.hasTypeParameters()) && AnonymousCanBeLambdaInspection.isLambdaForm(aClass, ignoredRuntimeAnnotations)) {
                PsiMethod method2 = aClass.getMethods()[0];
                return AnonymousCanBeLambdaInspection.getInferredType(aClass, method2) != null;
            }
        }
        return false;
    }

    public static PsiExpression replaceAnonymousWithLambda(@NotNull PsiElement anonymousClass, PsiType expectedType) {
        if (anonymousClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "replaceAnonymousWithLambda"));
        }
        PsiNewExpression newArrayExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)anonymousClass.getProject()).createExpressionFromText("new " + expectedType.getCanonicalText() + "[]{" + anonymousClass.getText() + "}", anonymousClass);
        PsiArrayInitializerExpression initializer = newArrayExpression.getArrayInitializer();
        LOG.assertTrue(initializer != null);
        return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)initializer.getInitializers()[0], true, false);
    }

    public static PsiExpression replacePsiElementWithLambda(@NotNull PsiElement element, boolean ignoreEqualsMethod, boolean forceIgnoreTypeCast) {
        PsiMethod method2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "replacePsiElementWithLambda"));
        }
        if (!(element instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)element;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass == null) {
            return null;
        }
        if (ignoreEqualsMethod) {
            List methods = ContainerUtil.filter((Object[])anonymousClass.getMethods(), method1 -> !"equals".equals(method1.getName()));
            method2 = (PsiMethod)methods.get(0);
        } else {
            method2 = anonymousClass.getMethods()[0];
        }
        if (method2 == null || method2.getBody() == null) {
            return null;
        }
        return AnonymousCanBeLambdaInspection.generateLambdaByMethod(anonymousClass, method2, lambda2 -> (PsiLambdaExpression)newExpression.replace((PsiElement)lambda2), forceIgnoreTypeCast);
    }

    @NotNull
    static PsiExpression generateLambdaByMethod(PsiAnonymousClass anonymousClass, PsiMethod method2, UnaryOperator<PsiLambdaExpression> replacer, boolean forceIgnoreTypeCast) {
        ChangeContextUtil.encodeContextInfo((PsiElement)anonymousClass, true);
        String canonicalText = anonymousClass.getBaseClassType().getCanonicalText();
        PsiCodeBlock body = method2.getBody();
        LOG.assertTrue(body != null);
        Collection<PsiComment> comments = AnonymousCanBeLambdaInspection.collectCommentsOutsideMethodBody(anonymousClass, body);
        Project project2 = anonymousClass.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        String withoutTypesDeclared = ReplaceWithLambdaFix.composeLambdaText(method2);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)elementFactory.createExpressionFromText(withoutTypesDeclared, (PsiElement)anonymousClass);
        PsiElement lambdaBody = lambdaExpression.getBody();
        LOG.assertTrue(lambdaBody != null);
        lambdaBody.replace((PsiElement)body);
        lambdaExpression = (PsiLambdaExpression)replacer.apply(lambdaExpression);
        HashSet<PsiVariable> variables = new HashSet<PsiVariable>();
        HashSet<String> usedLocalNames = new HashSet<String>();
        AnonymousCanBeLambdaInspection.collectLocalVariablesDefinedInsideLambda(lambdaExpression, variables, usedLocalNames);
        ReplaceWithLambdaFix.giveUniqueNames(project2, elementFactory, (PsiElement)lambdaExpression, usedLocalNames, variables.toArray(new PsiVariable[variables.size()]));
        PsiExpression singleExpr = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(lambdaExpression.getBody());
        if (singleExpr != null) {
            lambdaExpression.getBody().replace((PsiElement)singleExpr);
        }
        ChangeContextUtil.decodeContextInfo((PsiElement)lambdaExpression, null, null);
        AnonymousCanBeLambdaInspection.restoreComments(comments, (PsiElement)lambdaExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        if (forceIgnoreTypeCast) {
            PsiExpression psiExpression = (PsiExpression)javaCodeStyleManager.shortenClassReferences((PsiElement)lambdaExpression);
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "generateLambdaByMethod"));
            }
            return psiExpression;
        }
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + canonicalText + ")" + withoutTypesDeclared, (PsiElement)lambdaExpression);
        PsiExpression typeCastOperand = typeCast.getOperand();
        LOG.assertTrue(typeCastOperand instanceof PsiLambdaExpression);
        PsiElement fromText = ((PsiLambdaExpression)typeCastOperand).getBody();
        LOG.assertTrue(fromText != null);
        lambdaBody = lambdaExpression.getBody();
        LOG.assertTrue(lambdaBody != null);
        fromText.replace(lambdaBody);
        ((PsiLambdaExpression)typeCastOperand).getParameterList().replace((PsiElement)lambdaExpression.getParameterList());
        typeCast = (PsiTypeCastExpression)lambdaExpression.replace((PsiElement)typeCast);
        if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)typeCast)) {
            PsiExpression operand = typeCast.getOperand();
            LOG.assertTrue(operand != null);
            PsiExpression psiExpression = (PsiExpression)typeCast.replace((PsiElement)operand);
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "generateLambdaByMethod"));
            }
            return psiExpression;
        }
        PsiExpression psiExpression = (PsiExpression)javaCodeStyleManager.shortenClassReferences((PsiElement)typeCast);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "generateLambdaByMethod"));
        }
        return psiExpression;
    }

    @NotNull
    static Collection<PsiComment> collectCommentsOutsideMethodBody(PsiAnonymousClass anonymousClass, PsiCodeBlock body) {
        Collection psiComments = PsiTreeUtil.findChildrenOfType((PsiElement)anonymousClass, PsiComment.class);
        psiComments.removeIf(comment -> PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)comment, (boolean)false));
        List list = ContainerUtil.map((Collection)psiComments, comment -> (PsiComment)comment.copy());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "collectCommentsOutsideMethodBody"));
        }
        return list;
    }

    private static void collectLocalVariablesDefinedInsideLambda(PsiLambdaExpression lambdaExpression, final Set<PsiVariable> variables, Set<String> namesOfVariablesInTheBlock) {
        PsiElement block = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)lambdaExpression, null);
        if (block == null) {
            block = lambdaExpression;
        }
        block.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitVariable(PsiVariable variable) {
                super.visitVariable(variable);
                if (!(variable instanceof PsiField)) {
                    variables.add(variable);
                }
            }
        });
        PsiResolveHelper helper = PsiResolveHelper.SERVICE.getInstance((Project)lambdaExpression.getProject());
        Iterator<PsiVariable> iterator = variables.iterator();
        while (iterator.hasNext()) {
            PsiVariable local = iterator.next();
            String localName = local.getName();
            if (localName != null && !AnonymousCanBeLambdaInspection.shadowingResolve(localName, lambdaExpression, helper) && PsiTreeUtil.isAncestor((PsiElement)lambdaExpression, (PsiElement)local, (boolean)false)) continue;
            iterator.remove();
            namesOfVariablesInTheBlock.add(localName);
        }
    }

    private static boolean shadowingResolve(String localName, PsiLambdaExpression lambdaExpression, PsiResolveHelper helper) {
        PsiVariable variable = helper.resolveReferencedVariable(localName, (PsiElement)lambdaExpression);
        return variable == null || variable instanceof PsiField;
    }

    public static boolean functionalInterfaceMethodReferenced(PsiMethod psiMethod, PsiAnonymousClass anonymClass, PsiCallExpression callExpression) {
        if (psiMethod != null && !psiMethod.hasModifierProperty("static")) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
                return false;
            }
            if (callExpression instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)callExpression).getMethodExpression().isQualified()) {
                return false;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)anonymClass, (PsiClass)containingClass, (boolean)true) && !InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)containingClass, (PsiElement)anonymClass.getParent(), (boolean)true, (boolean)true)) {
                return true;
            }
        }
        return false;
    }

    public static void restoreComments(Collection<PsiComment> comments, PsiElement lambda2) {
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)lambda2, (Class[])new Class[]{PsiStatement.class, PsiField.class});
        if (anchor == null) {
            anchor = lambda2;
        }
        for (PsiComment comment : comments) {
            anchor.getParent().addBefore((PsiElement)comment, anchor);
        }
    }

    private static class ForbiddenRefsChecker
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myBodyContainsForbiddenRefs;
        private final PsiMethod myMethod;
        private final PsiAnonymousClass myAnonymClass;

        public ForbiddenRefsChecker(PsiMethod method2, PsiAnonymousClass aClass) {
            this.myMethod = method2;
            this.myAnonymClass = aClass;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitMethodCallExpression(methodCallExpression);
            PsiMethod psiMethod = methodCallExpression.resolveMethod();
            if (psiMethod == this.myMethod || AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(psiMethod, this.myAnonymClass, (PsiCallExpression)methodCallExpression) || psiMethod != null && !methodCallExpression.getMethodExpression().isQualified() && "getClass".equals(psiMethod.getName()) && psiMethod.getParameterList().getParametersCount() == 0) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitThisExpression(PsiThisExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitSuperExpression(PsiSuperExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitVariable(PsiVariable variable) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitVariable(variable);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitReferenceExpression(expression);
            if (!(expression.getParent() instanceof PsiMethodCallExpression)) {
                PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMember.class);
                if (member instanceof PsiField || member instanceof PsiClassInitializer) {
                    PsiExpression initializer;
                    PsiElement resolved = expression.resolve();
                    PsiClass memberContainingClass = member.getContainingClass();
                    if (resolved instanceof PsiField && memberContainingClass != null && PsiTreeUtil.isAncestor((PsiElement)((PsiField)resolved).getContainingClass(), (PsiElement)memberContainingClass, (boolean)false) && expression.getQualifierExpression() == null && ((initializer = ((PsiField)resolved).getInitializer()) == null || resolved == member || initializer.getTextOffset() > this.myAnonymClass.getTextOffset() && ((PsiField)resolved).hasModifierProperty("static") == member.hasModifierProperty("static"))) {
                        this.myBodyContainsForbiddenRefs = true;
                    }
                } else {
                    PsiElement resolved;
                    PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMethod.class);
                    if (method2 != null && method2.isConstructor() && (resolved = expression.resolve()) instanceof PsiField && ((PsiField)resolved).hasModifierProperty("final") && ((PsiField)resolved).getInitializer() == null && ((PsiField)resolved).getContainingClass() == method2.getContainingClass()) {
                        try {
                            int startOffset;
                            ControlFlow flow;
                            Collection<PsiVariable> writtenVariables;
                            PsiCodeBlock constructorBody = method2.getBody();
                            if (constructorBody != null && !(writtenVariables = ControlFlowUtil.getWrittenVariables(flow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)constructorBody), 0, startOffset = flow.getStartOffset((PsiElement)this.myAnonymClass), false)).contains(resolved)) {
                                this.myBodyContainsForbiddenRefs = true;
                            }
                        }
                        catch (AnalysisCanceledException e) {
                            this.myBodyContainsForbiddenRefs = true;
                        }
                    }
                }
            }
        }

        public boolean hasForbiddenRefs() {
            return this.myBodyContainsForbiddenRefs;
        }
    }

    private static class ReplaceWithLambdaFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithLambdaFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with lambda" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "getFamilyName"));
            }
            return "Replace with lambda";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element != null) {
                AnonymousCanBeLambdaInspection.replacePsiElementWithLambda(element, false, false);
            }
        }

        private static void giveUniqueNames(Project project2, final PsiElementFactory elementFactory, PsiElement body, Set<String> usedLocalNames, PsiVariable[] parameters) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            final HashMap<PsiVariable, String> names = new HashMap<PsiVariable, String>();
            for (PsiVariable parameter : parameters) {
                String uniqueVariableName;
                String parameterName = parameter.getName();
                if (Comparing.equal((String)parameterName, (String)(uniqueVariableName = UniqueNameGenerator.generateUniqueName((String)codeStyleManager.suggestUniqueVariableName(parameterName, parameter.getParent(), false), usedLocalNames)))) continue;
                names.put(parameter, uniqueVariableName);
            }
            if (names.isEmpty()) {
                return;
            }
            final LinkedHashMap replacements = new LinkedHashMap();
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitVariable(PsiVariable variable) {
                    super.visitVariable(variable);
                    String newName = (String)names.get(variable);
                    if (newName != null) {
                        replacements.put((Object)variable.getNameIdentifier(), (Object)elementFactory.createIdentifier(newName));
                    }
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    String newName;
                    super.visitReferenceExpression(expression);
                    PsiElement resolve2 = expression.resolve();
                    if (resolve2 instanceof PsiVariable && (newName = (String)names.get(resolve2)) != null) {
                        replacements.put((Object)expression, (Object)elementFactory.createExpressionFromText(newName, (PsiElement)expression));
                    }
                }
            });
            for (PsiElement psiElement : replacements.keySet()) {
                psiElement.replace((PsiElement)replacements.get((Object)psiElement));
            }
        }

        private static String composeLambdaText(PsiMethod method2) {
            StringBuilder buf = new StringBuilder();
            Object[] parameters = method2.getParameterList().getParameters();
            if (parameters.length != 1) {
                buf.append("(");
            }
            buf.append(StringUtil.join((Object[])parameters, ReplaceWithLambdaFix::composeParameter, (String)","));
            if (parameters.length != 1) {
                buf.append(")");
            }
            buf.append("-> {}");
            return buf.toString();
        }

        private static String composeParameter(PsiParameter parameter) {
            String parameterName = parameter.getName();
            if (parameterName == null) {
                parameterName = "";
            }
            return parameterName;
        }
    }
}

