/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LambdaCanBeMethodCallInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/LambdaCanBeMethodCallInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodCallInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                super.visitLambdaExpression(lambda2);
                PsiElement body = lambda2.getBody();
                if (body == null) {
                    return;
                }
                PsiType type = lambda2.getFunctionalInterfaceType();
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)lambda2.getParent());
                if (parent instanceof PsiTypeCastExpression && InheritanceUtil.isInheritor((PsiType)((PsiTypeCastExpression)parent).getType(), (String)"java.io.Serializable")) {
                    return;
                }
                PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)body));
                if (expression == null) {
                    return;
                }
                PsiParameter[] parameters = lambda2.getParameterList().getParameters();
                if (parameters.length == 1) {
                    PsiType[] typeParameters;
                    PsiClass aClass;
                    PsiParameter parameter = parameters[0];
                    if (ExpressionUtils.isReferenceTo(expression, (PsiVariable)parameter) && (aClass = ((PsiClassType)type).resolve()) != null && "java.util.function.Function".equals(aClass.getQualifiedName()) && (typeParameters = ((PsiClassType)type).getParameters()).length == 2 && typeParameters[1].isAssignableFrom(typeParameters[0])) {
                        this.registerProblem(lambda2, "Function.identity()", "java.util.function.Function.identity()");
                    }
                    if (expression instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
                        PsiClass aClass2 = ((PsiClassType)type).resolve();
                        if (aClass2 != null && "java.util.function.Predicate".equals(aClass2.getQualifiedName())) {
                            this.handlePredicateIsEqual(lambda2, parameter, call);
                            this.handlePatternAsPredicate(lambda2, parameter, call);
                        }
                    }
                }
            }

            private void handlePatternAsPredicate(PsiLambdaExpression lambda2, PsiParameter parameter, PsiMethodCallExpression call) {
                PsiExpression pattern;
                PsiExpression[] matcherArgs;
                PsiMethodCallExpression matcherCall;
                PsiExpression matcher;
                if (MethodCallUtils.isCallToMethod(call, "java.util.regex.Matcher", (PsiType)PsiType.BOOLEAN, "find", new PsiType[0]) && (matcher = call.getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression && MethodCallUtils.isCallToMethod(matcherCall = (PsiMethodCallExpression)matcher, "java.util.regex.Pattern", null, "matcher", new PsiType[]{null}) && (matcherArgs = matcherCall.getArgumentList().getExpressions()).length == 1 && ExpressionUtils.isReferenceTo(matcherArgs[0], (PsiVariable)parameter) && (pattern = matcherCall.getMethodExpression().getQualifierExpression()) != null && LambdaCanBeMethodReferenceInspection.checkQualifier((PsiElement)pattern)) {
                    this.registerProblem(lambda2, "Pattern.asPredicate()", ParenthesesUtils.getText(pattern, 2) + ".asPredicate()");
                }
            }

            private void handlePredicateIsEqual(PsiLambdaExpression lambda2, PsiParameter parameter, PsiMethodCallExpression call) {
                PsiExpression[] args;
                if (MethodCallUtils.isCallToStaticMethod(call, "java.util.Objects", "equals", 2) && (args = call.getArgumentList().getExpressions()).length == 2) {
                    PsiExpression comparedWith;
                    if (ExpressionUtils.isReferenceTo(args[0], (PsiVariable)parameter)) {
                        comparedWith = args[1];
                    } else if (ExpressionUtils.isReferenceTo(args[1], (PsiVariable)parameter)) {
                        comparedWith = args[0];
                    } else {
                        return;
                    }
                    if (LambdaCanBeMethodReferenceInspection.checkQualifier((PsiElement)comparedWith)) {
                        this.registerProblem(lambda2, "Predicate.isEqual()", "java.util.function.Predicate.isEqual(" + comparedWith.getText() + ")");
                    }
                }
            }

            private void registerProblem(PsiLambdaExpression lambda2, String displayReplacement, String replacement) {
                holder.registerProblem((PsiElement)lambda2, InspectionsBundle.message((String)"inspection.lambda.to.method.call.message", (Object[])new Object[]{displayReplacement}), new LocalQuickFix[]{new ReplaceWithFunctionCallFix(replacement, displayReplacement)});
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodCallInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    static final class ReplaceWithFunctionCallFix
    implements LocalQuickFix {
        private final String myDisplayReplacement;
        private final String myReplacement;

        public ReplaceWithFunctionCallFix(String replacement, String displayReplacement) {
            this.myReplacement = replacement;
            this.myDisplayReplacement = displayReplacement;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.lambda.to.method.call.fix.name", (Object[])new Object[]{this.myDisplayReplacement});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodCallInspection$ReplaceWithFunctionCallFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.lambda.to.method.call.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodCallInspection$ReplaceWithFunctionCallFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LambdaCanBeMethodCallInspection$ReplaceWithFunctionCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LambdaCanBeMethodCallInspection$ReplaceWithFunctionCallFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLambdaExpression)) {
                return;
            }
            PsiElement result2 = new CommentTracker().replaceAndRestoreComments(element, this.myReplacement);
            CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result2));
        }
    }
}

