/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantStreamOptionalCallInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(RedundantStreamOptionalCallInspection.class);
    private static final Set<String> INTERESTING_NAMES = ContainerUtil.set((Object[])new String[]{"map", "filter", "distinct", "sorted", "sequential", "parallel", "unordered", "flatMap"});
    private static final Set<String> CALLS_MAKING_SORT_USELESS = ContainerUtil.set((Object[])new String[]{"sorted", "anyMatch", "allMatch", "noneMatch", "count"});
    private static final Set<String> CALLS_KEEPING_SORT_ORDER = ContainerUtil.set((Object[])new String[]{"filter", "distinct", "boxed", "asLongStream", "asDoubleStream"});
    private static final Set<String> CALLS_KEEPING_ELEMENTS_DISTINCT = ContainerUtil.set((Object[])new String[]{"filter", "boxed", "asLongStream", "limit", "skip", "sorted", "takeWhile", "dropWhile"});
    private static final Set<String> CALLS_AFFECTING_PARALLELIZATION = ContainerUtil.set((Object[])new String[]{"sequential", "parallel"});
    private static final Set<String> BOX_UNBOX_NAMES = ContainerUtil.set((Object[])new String[]{"valueOf", "booleanValue", "byteValue", "charValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue"});
    public boolean USELESS_BOXING_IN_STREAM_MAP = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.option.streamboxing", (Object[])new Object[0]), (InspectionProfileEntry)this, "USELESS_BOXING_IN_STREAM_MAP");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/RedundantStreamOptionalCallInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantStreamOptionalCallInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                String name = methodExpression.getReferenceName();
                if (name == null || !INTERESTING_NAMES.contains(name)) {
                    return;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiMethod method2 = call.resolveMethod();
                if (method2 == null) {
                    return;
                }
                PsiClass aClass = method2.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String className = aClass.getQualifiedName();
                if (className == null) {
                    return;
                }
                boolean optional = OptionalUtil.isOptionalClassName(className);
                boolean stream = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream");
                if (!optional && !stream) {
                    return;
                }
                if (!EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(qualifier.getType(), call.getType())) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                switch (name) {
                    case "filter": {
                        if (args.length != 1 || !RedundantStreamOptionalCallInspection.isTruePredicate(args[0])) break;
                        this.register(call, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.filter", (Object[])new Object[0]));
                        break;
                    }
                    case "map": {
                        boolean allowBoxUnbox;
                        boolean bl = allowBoxUnbox = RedundantStreamOptionalCallInspection.this.USELESS_BOXING_IN_STREAM_MAP || optional || StreamApiUtil.getStreamElementType(call.getType()) instanceof PsiPrimitiveType;
                        if (args.length != 1 || !RedundantStreamOptionalCallInspection.isIdentityMapping(args[0], allowBoxUnbox)) break;
                        this.register(call, null);
                        break;
                    }
                    case "flatMap": {
                        if (args.length != 1 || !optional || !FunctionalExpressionUtils.isFunctionalReferenceTo(args[0], "java.util.Optional", null, "of", new PsiType[1]) && !FunctionalExpressionUtils.isFunctionalReferenceTo(args[0], "java.util.Optional", null, "ofNullable", new PsiType[1])) break;
                        this.register(call, null);
                        break;
                    }
                    case "sorted": {
                        if (args.length > 1) break;
                        PsiMethodCallExpression furtherCall = RedundantStreamOptionalCallInspection.findSubsequentCall(call, CALLS_MAKING_SORT_USELESS::contains, CALLS_KEEPING_SORT_ORDER::contains);
                        if (furtherCall == null) break;
                        this.register(call, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.sorted", (Object[])new Object[]{furtherCall.getMethodExpression().getReferenceName()}));
                        break;
                    }
                    case "distinct": {
                        if (args.length != 0) break;
                        PsiMethodCallExpression furtherCall = RedundantStreamOptionalCallInspection.findSubsequentCall(call, Predicate.isEqual("distinct"), CALLS_KEEPING_ELEMENTS_DISTINCT::contains);
                        if (furtherCall == null || furtherCall.getArgumentList().getExpressions().length != 0) break;
                        this.register(furtherCall, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.distinct", (Object[])new Object[0]));
                        break;
                    }
                    case "unordered": {
                        PsiMethodCallExpression furtherCall;
                        if (args.length != 0 || (furtherCall = RedundantStreamOptionalCallInspection.findSubsequentCall(call, Predicate.isEqual("unordered"), n -> !n.equals("sorted"))) == null || furtherCall.getArgumentList().getExpressions().length != 0) break;
                        this.register(furtherCall, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.unordered", (Object[])new Object[0]));
                        break;
                    }
                    case "sequential": 
                    case "parallel": {
                        if (args.length != 0) break;
                        PsiMethodCallExpression furtherCall = RedundantStreamOptionalCallInspection.findSubsequentCall(call, CALLS_AFFECTING_PARALLELIZATION::contains, n -> true);
                        if (furtherCall == null || furtherCall.getArgumentList().getExpressions().length != 0) break;
                        this.register(call, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.parallel", (Object[])new Object[]{furtherCall.getMethodExpression().getReferenceName()}));
                    }
                }
            }

            private void register(PsiMethodCallExpression call, String explanation) {
                String methodName = call.getMethodExpression().getReferenceName();
                String message = InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.message", (Object[])new Object[]{methodName});
                if (explanation != null) {
                    message = message + ": " + explanation;
                }
                holder.registerProblem((PsiElement)call, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, RedundantStreamOptionalCallInspection.getRange(call), new LocalQuickFix[]{new RemoveCallFix(methodName)});
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantStreamOptionalCallInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    private static PsiMethodCallExpression findSubsequentCall(PsiMethodCallExpression call, Predicate<String> isWantedCall, Predicate<String> isAllowedIntermediateCall) {
        PsiMethodCallExpression chainCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
        while (chainCall != null) {
            String name = chainCall.getMethodExpression().getReferenceName();
            if (name == null) {
                return null;
            }
            if (isWantedCall.test(name)) {
                return chainCall;
            }
            if (!isAllowedIntermediateCall.test(name) || !InheritanceUtil.isInheritor((PsiType)chainCall.getType(), (String)"java.util.stream.BaseStream")) {
                return null;
            }
            chainCall = ExpressionUtils.getCallForQualifier((PsiExpression)chainCall);
        }
        return null;
    }

    @NotNull
    static TextRange getRange(PsiMethodCallExpression call) {
        PsiReferenceExpression expression = call.getMethodExpression();
        PsiElement nameElement = expression.getReferenceNameElement();
        LOG.assertTrue(nameElement != null);
        TextRange textRange = new TextRange(nameElement.getStartOffsetInParent(), call.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantStreamOptionalCallInspection", "getRange"));
        }
        return textRange;
    }

    static boolean isIdentityMapping(PsiExpression expression, boolean allowBoxUnbox) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodCallExpression && MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)expression, "java.util.function.Function", "identity", 0)) {
            return true;
        }
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression;
            if (LambdaUtil.isIdentityLambda((PsiLambdaExpression)lambda2)) {
                return true;
            }
            if (!allowBoxUnbox) {
                return false;
            }
            PsiExpression body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            PsiParameter[] parameters = lambda2.getParameterList().getParameters();
            if (parameters.length != 1) {
                return false;
            }
            PsiParameter parameter = parameters[0];
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)body), PsiMethodCallExpression.class);
            if (call == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            if (!BOX_UNBOX_NAMES.contains(methodExpression.getReferenceName())) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (ExpressionUtils.isReferenceTo(qualifier, (PsiVariable)parameter) && args.length > 0) {
                return false;
            }
            if (args.length != 1 || !ExpressionUtils.isReferenceTo(args[0], (PsiVariable)parameter)) {
                return false;
            }
            return RedundantStreamOptionalCallInspection.isBoxUnboxMethod(call.resolveMethod());
        }
        if (!allowBoxUnbox || !(expression instanceof PsiMethodReferenceExpression)) {
            return false;
        }
        PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression;
        if (!BOX_UNBOX_NAMES.contains(methodRef.getReferenceName())) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
        return RedundantStreamOptionalCallInspection.isBoxUnboxMethod(method2);
    }

    @Contract(value="null -> false")
    private static boolean isBoxUnboxMethod(PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiType primitiveCandidate = null;
        PsiParameterList list = method2.getParameterList();
        if (list.getParametersCount() == 0) {
            primitiveCandidate = method2.getReturnType();
        } else if (list.getParametersCount() == 1) {
            primitiveCandidate = list.getParameters()[0].getType();
        }
        if (!(primitiveCandidate instanceof PsiPrimitiveType)) {
            return false;
        }
        return ((PsiPrimitiveType)primitiveCandidate).getBoxedTypeName().equals(aClass.getQualifiedName());
    }

    static boolean isTruePredicate(PsiExpression expression) {
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiLambdaExpression.class);
        if (lambda2 != null) {
            PsiExpression body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)body), Boolean.TRUE);
        }
        return false;
    }

    private static class RemoveCallFix
    implements LocalQuickFix {
        private final String myMethodName;

        public RemoveCallFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.fix.name", (Object[])new Object[]{this.myMethodName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$RemoveCallFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$RemoveCallFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$RemoveCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$RemoveCallFix", "applyFix"));
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)ct.markUnchanged(qualifier));
        }
    }
}

