/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.FileFilterPanel;
import com.intellij.codeInspection.actions.GotoInspectionModel;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionAction
extends GotoActionBase {
    private static final Logger LOGGER = Logger.getInstance(RunInspectionAction.class);

    public RunInspectionAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"goto.inspection.action.text", (Object[])new Object[0]));
    }

    @Override
    protected void gotoActionPerformed(AnActionEvent e) {
        final Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        final PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        final PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        final VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.inspection");
        GotoInspectionModel model = new GotoInspectionModel(project2);
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            protected ChooseByNameFilter<Object> createFilter(@NotNull ChooseByNamePopup popup) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInspection/actions/RunInspectionAction$1", "createFilter"));
                }
                popup.setSearchInAnyPlace(true);
                return super.createFilter(popup);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup, Object element) {
                ApplicationManager.getApplication().invokeLater(() -> RunInspectionAction.runInspection(project2, ((InspectionToolWrapper)element).getShortName(), virtualFile, psiElement, psiFile));
            }
        }, false);
    }

    public static void runInspection(final @NotNull Project project2, @NotNull String shortName, @Nullable VirtualFile virtualFile, PsiElement psiElement, PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionAction", "runInspection"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/actions/RunInspectionAction", "runInspection"));
        }
        PsiElement element = psiFile == null ? psiElement : psiFile;
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project2).getCurrentProfile();
        final InspectionToolWrapper toolWrapper = element != null ? currentProfile.getInspectionTool(shortName, element) : currentProfile.getInspectionTool(shortName, project2);
        LOGGER.assertTrue(toolWrapper != null, (Object)("Missed inspection: " + shortName));
        final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project2);
        final Module module2 = virtualFile != null ? ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project2) : null;
        AnalysisScope analysisScope = null;
        if (psiFile != null) {
            analysisScope = new AnalysisScope(psiFile);
        } else {
            PsiDirectory psiDirectory;
            if (virtualFile != null && virtualFile.isDirectory() && (psiDirectory = PsiManager.getInstance((Project)project2).findDirectory(virtualFile)) != null) {
                analysisScope = new AnalysisScope(psiDirectory);
            }
            if (analysisScope == null && virtualFile != null) {
                analysisScope = new AnalysisScope(project2, Arrays.asList(virtualFile));
            }
            if (analysisScope == null) {
                analysisScope = new AnalysisScope(project2);
            }
        }
        final AnalysisUIOptions options = AnalysisUIOptions.getInstance(project2);
        final FileFilterPanel fileFilterPanel = new FileFilterPanel();
        fileFilterPanel.init(options);
        final AnalysisScope initialAnalysisScope = analysisScope;
        BaseAnalysisActionDialog dialog2 = new BaseAnalysisActionDialog("Run '" + toolWrapper.getDisplayName() + "'", AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project2, analysisScope, module2 != null ? module2.getName() : null, true, options, psiElement){
            private InspectionToolWrapper myUpdatedSettingsToolWrapper;

            @Override
            @Nullable
            protected JComponent getAdditionalActionSettings(Project project22) {
                JPanel fileFilter = fileFilterPanel.getPanel();
                if (toolWrapper.getTool().createOptionsPanel() != null) {
                    JPanel additionPanel = new JPanel();
                    additionPanel.setLayout(new BoxLayout(additionPanel, 1));
                    additionPanel.add(fileFilter);
                    this.myUpdatedSettingsToolWrapper = RunInspectionAction.copyToolWithSettings(toolWrapper);
                    additionPanel.add((Component)new TitledSeparator(IdeBundle.message((String)"goto.inspection.action.choose.inherit.settings.from", (Object[])new Object[0])));
                    JComponent optionsPanel = this.myUpdatedSettingsToolWrapper.getTool().createOptionsPanel();
                    LOGGER.assertTrue(optionsPanel != null);
                    if (UIUtil.hasScrollPane((Component)optionsPanel)) {
                        additionPanel.add(optionsPanel);
                    } else {
                        additionPanel.add(ScrollPaneFactory.createScrollPane((Component)optionsPanel, (int)0));
                    }
                    return additionPanel;
                }
                return fileFilter;
            }

            @Override
            @NotNull
            public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project22, Module module22) {
                if (uiOptions == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiOptions", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                if (defaultScope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultScope", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                if (project22 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                AnalysisScope scope = super.getScope(uiOptions, defaultScope, project22, module22);
                GlobalSearchScope filterScope = fileFilterPanel.getSearchScope();
                if (filterScope == null) {
                    AnalysisScope analysisScope = scope;
                    if (analysisScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                    }
                    return analysisScope;
                }
                scope.setFilter(filterScope);
                AnalysisScope analysisScope = scope;
                if (analysisScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                return analysisScope;
            }

            private AnalysisScope getScope() {
                return this.getScope(options, initialAnalysisScope, project2, module2);
            }

            private InspectionToolWrapper getToolWrapper() {
                return this.myUpdatedSettingsToolWrapper == null ? toolWrapper : this.myUpdatedSettingsToolWrapper;
            }

            @NotNull
            protected Action[] createActions() {
                ArrayList<Action> actions = new ArrayList<Action>();
                boolean hasFixAll = toolWrapper.getTool() instanceof CleanupLocalInspectionTool;
                actions.add(new AbstractAction(hasFixAll ? AnalysisScopeBundle.message((String)"action.analyze.verb", (Object[])new Object[0]) : CommonBundle.getOkButtonText()){
                    {
                        super(x0);
                        this.putValue("DefaultAction", Boolean.TRUE);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RunInspectionIntention.rerunInspection(this.getToolWrapper(), managerEx, this.getScope(), null);
                        this.close(0);
                    }
                });
                if (hasFixAll) {
                    actions.add(new AbstractAction("Fix All"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InspectionToolWrapper wrapper = this.getToolWrapper();
                            InspectionProfileImpl cleanupToolProfile = RunInspectionIntention.createProfile(wrapper, managerEx, null);
                            managerEx.createNewGlobalContext(false).codeCleanup(this.getScope(), cleanupToolProfile, "Cleanup by " + wrapper.getDisplayName(), null, false);
                            this.close(0);
                        }
                    });
                }
                actions.add(this.getCancelAction());
                if (SystemInfo.isMac) {
                    Collections.reverse(actions);
                }
                Action[] actionArray = actions.toArray(new Action[actions.size()]);
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$2", "createActions"));
                }
                return actionArray;
            }
        };
        dialog2.showAndGet();
    }

    private static InspectionToolWrapper copyToolWithSettings(@NotNull InspectionToolWrapper tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/actions/RunInspectionAction", "copyToolWithSettings"));
        }
        Element options = new Element("copy");
        tool.getTool().writeSettings(options);
        InspectionToolWrapper copiedTool = tool.createCopy();
        try {
            copiedTool.getTool().readSettings(options);
        }
        catch (InvalidDataException e) {
            throw new RuntimeException(e);
        }
        return copiedTool;
    }
}

