/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ConcurrencyAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JCiPUtil {
    static boolean isJCiPAnnotation(String ref) {
        return "Immutable".equals(ref) || "GuardedBy".equals(ref) || "ThreadSafe".equals(ref) || "NotThreadSafe".equals(ref);
    }

    private JCiPUtil() {
    }

    public static boolean isImmutable(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil", "isImmutable"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (Collection)ConcurrencyAnnotationsManager.getInstance((Project)aClass.getProject()).getImmutableAnnotations());
        if (annotation != null) {
            return true;
        }
        PsiDocComment comment = aClass.getDocComment();
        return comment != null && comment.findTagByName("@Immutable") != null;
    }

    @Nullable
    public static String findGuardForMember(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil", "findGuardForMember"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (Collection)ConcurrencyAnnotationsManager.getInstance((Project)member.getProject()).getGuardedByAnnotations());
        if (annotation != null) {
            return JCiPUtil.getGuardValue(annotation);
        }
        if (member instanceof PsiCompiledElement && ((member = (PsiMember)member.getNavigationElement()) == null || member instanceof PsiCompiledElement)) {
            return null;
        }
        GuardedTagVisitor visitor = new GuardedTagVisitor();
        member.accept((PsiElementVisitor)visitor);
        return visitor.getGuardString();
    }

    static boolean isGuardedBy(@NotNull PsiMember member, @NotNull String guard) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil", "isGuardedBy"));
        }
        if (guard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guard", "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil", "isGuardedBy"));
        }
        List annotations = ConcurrencyAnnotationsManager.getInstance((Project)member.getProject()).getGuardedByAnnotations();
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (Collection)annotations);
        return annotation != null && guard.equals(JCiPUtil.getGuardValue(annotation));
    }

    public static boolean isGuardedBy(PsiMember member, PsiField field) {
        return JCiPUtil.isGuardedBy(member, field.getName());
    }

    static boolean isGuardedByAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil", "isGuardedByAnnotation"));
        }
        return ConcurrencyAnnotationsManager.getInstance((Project)annotation.getProject()).getGuardedByAnnotations().contains(annotation.getQualifiedName());
    }

    static boolean isGuardedByTag(PsiDocTag tag) {
        String text = tag.getText();
        return text.startsWith("@GuardedBy") && text.contains("(") && text.contains(")");
    }

    @Nullable
    static String getGuardValue(PsiAnnotation annotation) {
        PsiAnnotationMemberValue psiAnnotationMemberValue = annotation.findAttributeValue("value");
        if (psiAnnotationMemberValue != null) {
            PsiMember member;
            String value = psiAnnotationMemberValue.getText();
            String trim = value.substring(1, value.length() - 1).trim();
            if (trim.equals("itself") && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class)) != null) {
                return member.getName();
            }
            return trim;
        }
        return null;
    }

    @NotNull
    static String getGuardValue(PsiDocTag tag) {
        String text = tag.getText();
        String string = text.substring(text.indexOf(40) + 1, text.indexOf(41)).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil", "getGuardValue"));
        }
        return string;
    }

    private static class GuardedTagVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private String guardString;

        private GuardedTagVisitor() {
        }

        public void visitDocTag(PsiDocTag tag) {
            super.visitDocTag(tag);
            String text = tag.getText();
            if (text.startsWith("@GuardedBy") && text.contains("(") && text.contains(")")) {
                this.guardString = text.substring(text.indexOf(40) + 1, text.indexOf(41));
            }
        }

        @Nullable
        private String getGuardString() {
            return this.guardString;
        }
    }
}

