/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ContractInference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter");
    public static final int MAX_CONTRACT_COUNT = 10;

    @NotNull
    public static List<MethodContract> inferContracts(@NotNull PsiMethodImpl method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method2)) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)method2, () -> {
            MethodData data;
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$inferContracts$1"));
            }
            List<Object> preContracts = (data = ContractInferenceIndexKt.getIndexedData(method2)) == null ? Collections.emptyList() : data.getContracts();
            List result2 = (List)RecursionManager.doPreventingRecursion((Object)((Object)method2), (boolean)true, () -> {
                if (method2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$null$0"));
                }
                return ContractInference.postProcessContracts(method2, data, preContracts);
            });
            if (result2 == null) {
                result2 = Collections.emptyList();
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{method2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
        }
        return list;
    }

    @NotNull
    private static List<MethodContract> postProcessContracts(@NotNull PsiMethodImpl method2, MethodData data, List<PreContract> rawContracts) {
        List compatible;
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
        }
        List<MethodContract> contracts2 = ContainerUtil.concat(rawContracts, c -> {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$postProcessContracts$2"));
            }
            return c.toContracts(method2, data.methodBody(method2));
        });
        if (contracts2.isEmpty()) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
            }
            return list;
        }
        PsiType returnType = method2.getReturnType();
        if (returnType != null && !(returnType instanceof PsiPrimitiveType)) {
            contracts2 = ContractInference.boxReturnValues(contracts2);
        }
        if ((compatible = ContainerUtil.filter((Collection)contracts2, contract -> {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$postProcessContracts$3"));
            }
            return ContractInference.isContractCompatibleWithMethod(method2, returnType, contract);
        })).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName((PsiMember)method2) + ", shrinking the list");
            List<MethodContract> list = compatible.subList(0, 10);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
            }
            return list;
        }
        List list = compatible;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
        }
        return list;
    }

    private static boolean isContractCompatibleWithMethod(@NotNull PsiMethod method2, PsiType returnType, MethodContract contract) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "isContractCompatibleWithMethod"));
        }
        if (ContractInference.hasContradictoryExplicitParameterNullity(method2, contract)) {
            return false;
        }
        if (ContractInference.isReturnNullitySpecifiedExplicitly(method2, contract)) {
            return false;
        }
        if (ContractInference.isContradictingExplicitNullableReturn(method2, contract)) {
            return false;
        }
        return InferenceFromSourceUtil.isReturnTypeCompatible(returnType, contract.returnValue);
    }

    private static boolean hasContradictoryExplicitParameterNullity(@NotNull PsiMethod method2, MethodContract contract) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "hasContradictoryExplicitParameterNullity"));
        }
        for (int i2 = 0; i2 < contract.arguments.length; ++i2) {
            if (contract.arguments[i2] != MethodContract.ValueConstraint.NULL_VALUE || !NullableNotNullManager.isNotNull((PsiModifierListOwner)method2.getParameterList().getParameters()[i2])) continue;
            return true;
        }
        return false;
    }

    private static boolean isContradictingExplicitNullableReturn(@NotNull PsiMethod method2, MethodContract contract) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "isContradictingExplicitNullableReturn"));
        }
        return contract.returnValue == MethodContract.ValueConstraint.NOT_NULL_VALUE && Arrays.stream(contract.arguments).allMatch(c -> c == MethodContract.ValueConstraint.ANY_VALUE) && NullableNotNullManager.getInstance((Project)method2.getProject()).isNullable((PsiModifierListOwner)method2, false);
    }

    private static boolean isReturnNullitySpecifiedExplicitly(@NotNull PsiMethod method2, MethodContract contract) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "isReturnNullitySpecifiedExplicitly"));
        }
        if (contract.returnValue != MethodContract.ValueConstraint.NOT_NULL_VALUE && contract.returnValue != MethodContract.ValueConstraint.NULL_VALUE) {
            return false;
        }
        return NullableNotNullManager.getInstance((Project)method2.getProject()).isNotNull((PsiModifierListOwner)method2, false);
    }

    @NotNull
    private static List<MethodContract> boxReturnValues(List<MethodContract> contracts2) {
        List list = ContainerUtil.mapNotNull(contracts2, contract -> {
            if (contract.returnValue == MethodContract.ValueConstraint.FALSE_VALUE || contract.returnValue == MethodContract.ValueConstraint.TRUE_VALUE) {
                return new MethodContract(contract.arguments, MethodContract.ValueConstraint.NOT_NULL_VALUE);
            }
            return contract;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "boxReturnValues"));
        }
        return list;
    }
}

