/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.codeInspection.AddAssertStatementFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.RemoveAssignmentFix;
import com.intellij.codeInspection.SurroundWithIfFix;
import com.intellij.codeInspection.dataFlow.DataFlowInspectionBase;
import com.intellij.codeInspection.nullable.NullableStuffInspection;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ui.JBUI;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataFlowInspection
extends DataFlowInspectionBase {
    @Override
    protected void addSurroundWithIfFix(PsiExpression qualifier, List<LocalQuickFix> fixes, boolean onTheFly) {
        if (onTheFly && SurroundWithIfFix.isAvailable(qualifier)) {
            fixes.add(new SurroundWithIfFix(qualifier));
        }
    }

    @Override
    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression assignment, boolean onTheFly) {
        boolean toRemove;
        IElementType op = assignment.getOperationTokenType();
        boolean bl = toRemove = op == JavaTokenType.ANDEQ && !evaluatesToTrue || op == JavaTokenType.OREQ && evaluatesToTrue;
        if (toRemove && !onTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{toRemove ? new RemoveAssignmentFix() : DataFlowInspection.createSimplifyToAssignmentFix()};
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Override
    protected AddAssertStatementFix createAssertFix(PsiBinaryExpression binary, PsiExpression expression) {
        return RefactoringUtil.getParentStatement((PsiElement)expression, false) == null ? null : new AddAssertStatementFix((PsiExpression)binary);
    }

    @Override
    protected LocalQuickFix createIntroduceVariableFix(PsiExpression expression) {
        return new IntroduceVariableFix(true);
    }

    @Override
    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return new NullableStuffInspection.NavigateToNullLiteralArguments(parameter);
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myIgnoreAssertions;
        private final JCheckBox myReportConstantReferences;
        private final JCheckBox mySuggestNullables;
        private final JCheckBox myDontReportTrueAsserts;
        private final JCheckBox myTreatUnknownMembersAsNullable;
        private final JCheckBox myReportNullArguments;
        private final JCheckBox myReportNullableMethodsReturningNotNull;
        private final JCheckBox myReportUncheckedOptionals;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.mySuggestNullables = new JCheckBox(InspectionsBundle.message((String)"inspection.data.flow.nullable.quickfix.option", (Object[])new Object[0]));
            this.mySuggestNullables.setSelected(DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS);
            this.mySuggestNullables.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS = OptionsPanel.this.mySuggestNullables.isSelected();
                }
            });
            this.myDontReportTrueAsserts = new JCheckBox(InspectionsBundle.message((String)"inspection.data.flow.true.asserts.option", (Object[])new Object[0]));
            this.myDontReportTrueAsserts.setSelected(DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS);
            this.myDontReportTrueAsserts.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS = OptionsPanel.this.myDontReportTrueAsserts.isSelected();
                }
            });
            this.myIgnoreAssertions = new JCheckBox("Ignore assert statements");
            this.myIgnoreAssertions.setSelected(DataFlowInspection.this.IGNORE_ASSERT_STATEMENTS);
            this.myIgnoreAssertions.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.IGNORE_ASSERT_STATEMENTS = OptionsPanel.this.myIgnoreAssertions.isSelected();
                }
            });
            this.myReportConstantReferences = new JCheckBox("Warn when reading a value guaranteed to be constant");
            this.myReportConstantReferences.setSelected(DataFlowInspection.this.REPORT_CONSTANT_REFERENCE_VALUES);
            this.myReportConstantReferences.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.REPORT_CONSTANT_REFERENCE_VALUES = OptionsPanel.this.myReportConstantReferences.isSelected();
                }
            });
            this.myTreatUnknownMembersAsNullable = new JCheckBox("Treat non-annotated members and parameters as @Nullable");
            this.myTreatUnknownMembersAsNullable.setSelected(DataFlowInspection.this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE);
            this.myTreatUnknownMembersAsNullable.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE = OptionsPanel.this.myTreatUnknownMembersAsNullable.isSelected();
                }
            });
            this.myReportNullArguments = new JCheckBox("Report not-null required parameter with null-literal argument usages");
            this.myReportNullArguments.setSelected(DataFlowInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER);
            this.myReportNullArguments.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = OptionsPanel.this.myReportNullArguments.isSelected();
                }
            });
            this.myReportNullableMethodsReturningNotNull = new JCheckBox("Report nullable methods that always return a non-null value");
            this.myReportNullableMethodsReturningNotNull.setSelected(DataFlowInspection.this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL);
            this.myReportNullableMethodsReturningNotNull.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = OptionsPanel.this.myReportNullableMethodsReturningNotNull.isSelected();
                }
            });
            this.myReportUncheckedOptionals = new JCheckBox("Report Optional.get() calls without previous isPresent check");
            this.myReportUncheckedOptionals.setSelected(DataFlowInspection.this.REPORT_UNCHECKED_OPTIONALS);
            this.myReportUncheckedOptionals.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.REPORT_UNCHECKED_OPTIONALS = OptionsPanel.this.myReportUncheckedOptionals.isSelected();
                }
            });
            gc.insets = JBUI.emptyInsets();
            gc.gridy = 0;
            this.add((Component)this.mySuggestNullables, gc);
            JButton configureAnnotations = NullableNotNullDialog.createConfigureAnnotationsButton((Component)this);
            ++gc.gridy;
            gc.fill = 0;
            gc.insets.left = 20;
            gc.insets.bottom = 15;
            this.add((Component)configureAnnotations, gc);
            gc.fill = 2;
            gc.weighty = 1.0;
            gc.insets.left = 0;
            ++gc.gridy;
            this.add((Component)this.myDontReportTrueAsserts, gc);
            ++gc.gridy;
            this.add((Component)this.myIgnoreAssertions, gc);
            ++gc.gridy;
            this.add((Component)this.myReportConstantReferences, gc);
            ++gc.gridy;
            this.add((Component)this.myTreatUnknownMembersAsNullable, gc);
            ++gc.gridy;
            this.add((Component)this.myReportNullArguments, gc);
            ++gc.gridy;
            this.add((Component)this.myReportNullableMethodsReturningNotNull, gc);
            ++gc.gridy;
            this.add((Component)this.myReportUncheckedOptionals, gc);
        }
    }
}

