/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaVariableValue
extends DfaValue {
    private static final ElementPattern<? extends PsiModifierListOwner> MEMBER_OR_METHOD_PARAMETER = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMember(), PsiJavaPatterns.psiParameter().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMember())});
    private final PsiModifierListOwner myVariable;
    private final PsiType myVarType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfaVariableValue myNegatedValue;
    private final boolean myIsNegated;
    private Nullness myInherentNullability;
    private final DfaTypeValue myTypeValue;
    private final List<DfaVariableValue> myDependents;

    private DfaVariableValue(@NotNull PsiModifierListOwner variable, @Nullable PsiType varType, boolean isNegated, DfaValueFactory factory, @Nullable DfaVariableValue qualifier) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "<init>"));
        }
        super(factory);
        this.myDependents = new SmartList();
        this.myVariable = variable;
        this.myIsNegated = isNegated;
        this.myQualifier = qualifier;
        this.myVarType = varType;
        DfaValue typeValue = this.myFactory.createTypeValue(varType, Nullness.UNKNOWN);
        DfaTypeValue dfaTypeValue = this.myTypeValue = typeValue instanceof DfaTypeValue ? (DfaTypeValue)typeValue : null;
        if (varType != null && !varType.isValid()) {
            PsiUtil.ensureValidType((PsiType)varType, (String)("Variable: " + variable + " of class " + variable.getClass()));
        }
    }

    @Nullable
    public DfaTypeValue getTypeValue() {
        return this.myTypeValue;
    }

    @NotNull
    public PsiModifierListOwner getPsiVariable() {
        PsiModifierListOwner psiModifierListOwner = this.myVariable;
        if (psiModifierListOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "getPsiVariable"));
        }
        return psiModifierListOwner;
    }

    @Nullable
    public PsiType getVariableType() {
        return this.myVarType;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Nullable
    public DfaVariableValue getNegatedValue() {
        return this.myNegatedValue;
    }

    @Override
    public DfaVariableValue createNegated() {
        if (this.myNegatedValue != null) {
            return this.myNegatedValue;
        }
        this.myNegatedValue = this.myFactory.getVarFactory().createVariableValue(this.myVariable, this.myVarType, !this.myIsNegated, this.myQualifier);
        return this.myNegatedValue;
    }

    public String toString() {
        return (this.myIsNegated ? "!" : "") + ((PsiNamedElement)this.myVariable).getName() + (this.myQualifier == null ? "" : "|" + this.myQualifier.toString());
    }

    private boolean hardEquals(PsiModifierListOwner psiVar, PsiType varType, boolean negated, DfaVariableValue qualifier) {
        return psiVar == this.myVariable && Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)varType), (Object)TypeConversionUtil.erasure((PsiType)this.myVarType)) && negated == this.myIsNegated && (this.myQualifier == null ? qualifier == null : this.myQualifier.hardEquals(qualifier.getPsiVariable(), qualifier.getVariableType(), qualifier.isNegated(), qualifier.getQualifier()));
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    @NotNull
    public Nullness getInherentNullability() {
        if (this.myInherentNullability != null) {
            Nullness nullness = this.myInherentNullability;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "getInherentNullability"));
            }
            return nullness;
        }
        this.myInherentNullability = this.calcInherentNullability();
        if (this.myInherentNullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "getInherentNullability"));
        }
        return this.myInherentNullability;
    }

    @NotNull
    private Nullness calcInherentNullability() {
        PsiType itemType;
        PsiExpression iteratedValue;
        Nullness defaultNullability;
        PsiModifierListOwner var = this.getPsiVariable();
        Nullness nullability = DfaPsiUtil.getElementNullability(this.getVariableType(), var);
        if (nullability != Nullness.UNKNOWN) {
            Nullness nullness = nullability;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "calcInherentNullability"));
            }
            return nullness;
        }
        Nullness nullness = defaultNullability = this.myFactory.isUnknownMembersAreNullable() && MEMBER_OR_METHOD_PARAMETER.accepts((Object)var) ? Nullness.NULLABLE : Nullness.UNKNOWN;
        if (var instanceof PsiParameter && var.getParent() instanceof PsiForeachStatement && (iteratedValue = ((PsiForeachStatement)var.getParent()).getIteratedValue()) != null && (itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue)) != null) {
            Nullness nullness2 = DfaPsiUtil.getElementNullability(itemType, var);
            if (nullness2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "calcInherentNullability"));
            }
            return nullness2;
        }
        if (var instanceof PsiField && this.myFactory.isHonorFieldInitializers()) {
            Nullness nullness3 = DfaVariableValue.getNullabilityFromFieldInitializers((PsiField)var, defaultNullability);
            if (nullness3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "calcInherentNullability"));
            }
            return nullness3;
        }
        Nullness nullness4 = defaultNullability;
        if (nullness4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "calcInherentNullability"));
        }
        return nullness4;
    }

    private static Nullness getNullabilityFromFieldInitializers(PsiField field, Nullness defaultNullability) {
        if (DfaPsiUtil.isFinalField((PsiVariable)field)) {
            PsiExpression initializer = field.getInitializer();
            if (initializer != null) {
                return DfaVariableValue.getFieldInitializerNullness(initializer);
            }
            List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            if (initializers.isEmpty()) {
                return defaultNullability;
            }
            for (PsiExpression expression : initializers) {
                if (DfaVariableValue.getFieldInitializerNullness(expression) != Nullness.NULLABLE) continue;
                return Nullness.NULLABLE;
            }
            if (DfaPsiUtil.isInitializedNotNull(field)) {
                return Nullness.NOT_NULL;
            }
        } else if (DfaVariableValue.isOnlyImplicitlyInitialized(field)) {
            return Nullness.NOT_NULL;
        }
        return defaultNullability;
    }

    private static boolean isOnlyImplicitlyInitialized(PsiField field) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)(DfaVariableValue.isImplicitlyInitializedNotNull(field) && DfaVariableValue.weAreSureThereAreNoExplicitWrites(field) ? 1 : 0), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean isImplicitlyInitializedNotNull(PsiField field) {
        return ContainerUtil.exists((Object[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME), p -> p.isImplicitlyNotNullInitialized((PsiElement)field));
    }

    private static boolean weAreSureThereAreNoExplicitWrites(PsiField field) {
        String name = field.getName();
        if (name == null || field.getInitializer() != null) {
            return false;
        }
        if (!DfaVariableValue.isCheapEnoughToSearch(field, name)) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)field).forEach(reference -> reference instanceof PsiReferenceExpression && !PsiUtil.isAccessedForWriting((PsiExpression)((PsiReferenceExpression)reference)));
    }

    private static boolean isCheapEnoughToSearch(PsiField field, String name) {
        SearchScope scope = field.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)field.getProject());
        PsiSearchHelper.SearchCostResult result2 = helper.isCheapEnoughToSearch(name, (GlobalSearchScope)scope, field.getContainingFile(), null);
        return result2 != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    private static Nullness getFieldInitializerNullness(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "getFieldInitializerNullness"));
        }
        if (expression.textMatches((CharSequence)"null")) {
            return Nullness.NULLABLE;
        }
        if (expression instanceof PsiNewExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiPolyadicExpression) {
            return Nullness.NOT_NULL;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression).resolve();
            return DfaPsiUtil.getElementNullability(expression.getType(), (PsiModifierListOwner)target);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethod method2 = ((PsiMethodCallExpression)expression).resolveMethod();
            return method2 != null ? DfaPsiUtil.getElementNullability(expression.getType(), (PsiModifierListOwner)method2) : Nullness.UNKNOWN;
        }
        return Nullness.UNKNOWN;
    }

    public boolean isFlushableByCalls() {
        if (this.myVariable instanceof PsiLocalVariable || this.myVariable instanceof PsiParameter) {
            return false;
        }
        if (this.myVariable instanceof PsiVariable && this.myVariable.hasModifierProperty("final")) {
            return this.myQualifier != null && this.myQualifier.isFlushableByCalls();
        }
        return true;
    }

    public boolean containsCalls() {
        return this.myVariable instanceof PsiMethod || this.myQualifier != null && this.myQualifier.containsCalls();
    }

    public static class Factory {
        private final MultiMap<Trinity<Boolean, String, DfaVariableValue>, DfaVariableValue> myExistingVars = new MultiMap();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaVariableValue createVariableValue(PsiVariable myVariable, boolean isNegated) {
            PsiType varType = myVariable.getType();
            if (varType instanceof PsiEllipsisType) {
                varType = new PsiArrayType(((PsiEllipsisType)varType).getComponentType());
            }
            return this.createVariableValue((PsiModifierListOwner)myVariable, varType, isNegated, null);
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull PsiModifierListOwner myVariable, @Nullable PsiType varType, boolean isNegated, @Nullable DfaVariableValue qualifier) {
            if (myVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myVariable", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
            }
            Trinity key2 = Trinity.create((Object)isNegated, (Object)((PsiNamedElement)myVariable).getName(), (Object)qualifier);
            for (DfaVariableValue aVar : this.myExistingVars.get((Object)key2)) {
                if (!aVar.hardEquals(myVariable, varType, isNegated, qualifier)) continue;
                DfaVariableValue dfaVariableValue = aVar;
                if (dfaVariableValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
                }
                return dfaVariableValue;
            }
            DfaVariableValue result2 = new DfaVariableValue(myVariable, varType, isNegated, this.myFactory, qualifier);
            this.myExistingVars.putValue((Object)key2, (Object)result2);
            while (qualifier != null) {
                qualifier.myDependents.add(result2);
                qualifier = qualifier.getQualifier();
            }
            DfaVariableValue dfaVariableValue = result2;
            if (dfaVariableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
            }
            return dfaVariableValue;
        }

        @NotNull
        public List<DfaVariableValue> getAllQualifiedBy(@NotNull DfaVariableValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "getAllQualifiedBy"));
            }
            List list = value.myDependents;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "getAllQualifiedBy"));
            }
            return list;
        }
    }
}

