/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisableInspectionToolAction
extends IntentionAndQuickFixAction
implements Iconable {
    private final String myToolId;
    public static final String NAME = InspectionsBundle.message((String)"disable.inspection.action.name", (Object[])new Object[0]);

    public DisableInspectionToolAction(LocalInspectionTool tool) {
        this.myToolId = tool.getShortName();
    }

    public DisableInspectionToolAction(HighlightDisplayKey key2) {
        this.myToolId = key2.toString();
    }

    @NotNull
    public String getName() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/DisableInspectionToolAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/DisableInspectionToolAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/DisableInspectionToolAction", "isAvailable"));
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        InspectionToolWrapper toolWrapper = inspectionProfile.getInspectionTool(this.myToolId, project2);
        return toolWrapper == null || toolWrapper.getDefaultLevel() != HighlightDisplayLevel.NON_SWITCHABLE_ERROR;
    }

    public void applyFix(@NotNull Project project2, PsiFile file2, @Nullable Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/DisableInspectionToolAction", "applyFix"));
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(project2, (Consumer<ModifiableModel>)((Consumer)it -> it.disableTool(this.myToolId, (PsiElement)file2)));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }
}

