/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionElementsMergerBase;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.NewInspectionProfile;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileImpl
extends NewInspectionProfile {
    @NonNls
    static final String INSPECTION_TOOL_TAG = "inspection_tool";
    @NonNls
    static final String CLASS_TAG = "class";
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionProfileImpl");
    @NonNls
    private static final String VALID_VERSION = "1.0";
    @NonNls
    private static final String VERSION_TAG = "version";
    @NonNls
    private static final String USED_LEVELS = "used_levels";
    public static boolean INIT_INSPECTIONS = false;
    protected final InspectionToolRegistrar myRegistrar;
    protected final Map<String, Element> myUninitializedSettings;
    protected Map<String, ToolsImpl> myTools;
    protected volatile Set<String> myChangedToolNames;
    @Attribute(value="is_locked")
    protected boolean myLockedProfile;
    protected final InspectionProfileImpl myBaseProfile;
    private volatile String myToolShortName;
    private String[] myScopesOrder;
    private String myDescription;
    private SchemeDataHolder<? super InspectionProfileImpl> myDataHolder;

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @NotNull BaseInspectionProfileManager profileManager) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, registrar, profileManager, InspectionProfileKt.getBASE_PROFILE(), null);
    }

    public InspectionProfileImpl(@NotNull String profileName) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, InspectionToolRegistrar.getInstance(), (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), null, null);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @Nullable InspectionProfileImpl baseProfile) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, registrar, (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), baseProfile, null);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @NotNull BaseInspectionProfileManager profileManager, @Nullable InspectionProfileImpl baseProfile, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        super(profileName, profileManager);
        this.myUninitializedSettings = new TreeMap<String, Element>();
        this.myTools = new THashMap();
        this.myRegistrar = registrar;
        this.myBaseProfile = baseProfile;
        this.myDataHolder = dataHolder;
        if (dataHolder != null) {
            this.schemeState = SchemeState.UNCHANGED;
        }
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @NotNull BaseInspectionProfileManager profileManager, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, registrar, profileManager, InspectionProfileKt.getBASE_PROFILE(), dataHolder);
    }

    private static boolean toolSettingsAreEqual(@NotNull String toolName, @NotNull InspectionProfileImpl profile1, @NotNull InspectionProfileImpl profile2) {
        if (toolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        if (profile1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile1", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile2", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        Tools toolList1 = profile1.myTools.get(toolName);
        Tools toolList2 = profile2.myTools.get(toolName);
        return Comparing.equal((Object)toolList1, (Object)toolList2);
    }

    @NotNull
    protected static InspectionToolWrapper copyToolSettings(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyToolSettings"));
        }
        InspectionToolWrapper inspectionTool = toolWrapper.createCopy();
        if (toolWrapper.isInitialized()) {
            Element config = new Element("config");
            toolWrapper.getTool().writeSettings(config);
            inspectionTool.getTool().readSettings(config);
        }
        InspectionToolWrapper inspectionToolWrapper = inspectionTool;
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyToolSettings"));
        }
        return inspectionToolWrapper;
    }

    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        HighlightDisplayLevel level;
        if (inspectionToolKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        Project project2 = element == null ? null : element.getProject();
        ToolsImpl tools = this.getToolsOrNull(inspectionToolKey.toString(), project2);
        HighlightDisplayLevel highlightDisplayLevel = level = tools != null ? tools.getLevel(element) : HighlightDisplayLevel.WARNING;
        if (!this.getProfileManager().getOwnSeverityRegistrar().isSeverityValid(level.getSeverity().getName())) {
            level = HighlightDisplayLevel.WARNING;
            this.setErrorLevel(inspectionToolKey, level, project2);
        }
        return level;
    }

    @Override
    public void readExternal(@NotNull Element element) {
        String version;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "readExternal"));
        }
        this.mySerializer.readExternal((Object)this, element);
        Element highlightElement = element.getChild(USED_LEVELS);
        if (highlightElement != null) {
            this.getProfileManager().getOwnSeverityRegistrar().readExternal(highlightElement);
        }
        if ((version = element.getAttributeValue(VERSION_TAG)) == null || !version.equals(VALID_VERSION)) {
            InspectionToolWrapper[] tools = this.getInspectionTools(null);
            for (Element toolElement : element.getChildren(INSPECTION_TOOL_TAG)) {
                String toolClassName = toolElement.getAttributeValue(CLASS_TAG);
                String shortName = InspectionProfileImpl.convertToShortName(toolClassName, tools);
                if (shortName == null) continue;
                toolElement.setAttribute(CLASS_TAG, shortName);
                this.myUninitializedSettings.put(shortName, toolElement.clone());
            }
        } else {
            for (Element toolElement : element.getChildren(INSPECTION_TOOL_TAG)) {
                this.myUninitializedSettings.put(toolElement.getAttributeValue(CLASS_TAG), toolElement.clone());
            }
        }
    }

    @Nullable
    private static String convertToShortName(@Nullable String displayName, InspectionToolWrapper[] tools) {
        if (displayName == null) {
            return null;
        }
        for (InspectionToolWrapper tool : tools) {
            if (!displayName.equals(tool.getDisplayName())) continue;
            return tool.getShortName();
        }
        return null;
    }

    @NotNull
    public Set<HighlightSeverity> getUsedSeverities() {
        LOG.assertTrue(this.wasInitialized());
        THashSet result2 = new THashSet();
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                result2.add(state.getLevel().getSeverity());
            }
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUsedSeverities"));
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element element = this.writeScheme(true);
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeScheme"));
        }
        return element;
    }

    @NotNull
    public Element writeScheme(boolean setSchemeStateToUnchanged) {
        if (this.myDataHolder != null) {
            Element element = this.myDataHolder.read();
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeScheme"));
            }
            return element;
        }
        Element element = new Element("profile");
        this.writeExternal(element);
        if (this.isProjectLevel()) {
            element.setAttribute(VERSION_TAG, VALID_VERSION);
        }
        if (this.isProjectLevel() && ProjectKt.isDirectoryBased(((ProjectInspectionProfileManager)this.getProfileManager()).getProject())) {
            Element element2 = new Element("component").setAttribute("name", "InspectionProjectProfileManager").addContent(element);
            if (element2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeScheme"));
            }
            return element2;
        }
        if (setSchemeStateToUnchanged) {
            this.schemeState = SchemeState.UNCHANGED;
        }
        Element element3 = element;
        if (element3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeScheme"));
        }
        return element3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeExternal"));
        }
        element.setAttribute(VERSION_TAG, VALID_VERSION);
        this.mySerializer.writeExternal((Object)this, element);
        Object object = this.myLock;
        synchronized (object) {
            if (!this.wasInitialized()) {
                for (Element el : this.myUninitializedSettings.values()) {
                    element.addContent(el.clone());
                }
                return;
            }
        }
        Set<String> changedToolNames = this.getChangedToolNames();
        if (changedToolNames == null) {
            return;
        }
        ArrayList<String> allToolNames = new ArrayList<String>(this.myTools.keySet());
        allToolNames.addAll(this.myUninitializedSettings.keySet());
        allToolNames.sort(null);
        for (String toolName : allToolNames) {
            Element toolElement = this.myUninitializedSettings.get(toolName);
            if (toolElement != null) {
                element.addContent(toolElement.clone());
                continue;
            }
            if (!this.myLockedProfile && !changedToolNames.contains(toolName)) {
                this.markSettingsMerged(toolName, element);
                continue;
            }
            ToolsImpl toolList = this.myTools.get(toolName);
            LOG.assertTrue(toolList != null);
            Element inspectionElement = new Element(INSPECTION_TOOL_TAG);
            inspectionElement.setAttribute(CLASS_TAG, toolName);
            try {
                toolList.writeExternal(inspectionElement);
                this.getPathMacroManager().collapsePaths(inspectionElement);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (this.areSettingsMerged(toolName, inspectionElement)) continue;
            element.addContent(inspectionElement);
        }
    }

    private void markSettingsMerged(@NotNull String toolName, @NotNull Element element) {
        InspectionElementsMergerBase merger;
        if (toolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "markSettingsMerged"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "markSettingsMerged"));
        }
        String mergedName = InspectionElementsMergerBase.getMergedMarkerName(toolName);
        if (!this.myUninitializedSettings.containsKey(mergedName) && (merger = InspectionProfileImpl.getMerger(toolName)) != null && merger.markSettingsMerged(this.myUninitializedSettings)) {
            element.addContent(new Element(INSPECTION_TOOL_TAG).setAttribute(CLASS_TAG, mergedName));
        }
    }

    private boolean areSettingsMerged(String toolName, Element inspectionElement) {
        InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(toolName);
        return merger != null && merger.areSettingsMerged(this.myUninitializedSettings, inspectionElement);
    }

    public void collectDependentInspections(@NotNull InspectionToolWrapper toolWrapper, @NotNull Set<InspectionToolWrapper<?, ?>> dependentEntries, Project project2) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "collectDependentInspections"));
        }
        if (dependentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentEntries", "com/intellij/codeInspection/ex/InspectionProfileImpl", "collectDependentInspections"));
        }
        String mainToolId = toolWrapper.getMainToolId();
        if (mainToolId != null) {
            InspectionToolWrapper dependentEntryWrapper = this.getInspectionTool(mainToolId, project2);
            if (dependentEntryWrapper == null) {
                LOG.error("Can't find main tool: '" + mainToolId + "' which was specified in " + toolWrapper);
                return;
            }
            if (!dependentEntries.add(dependentEntryWrapper)) {
                this.collectDependentInspections(dependentEntryWrapper, dependentEntries, project2);
            }
        }
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, @Nullable PsiElement element) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTool"));
        }
        ToolsImpl toolList = this.getToolsOrNull(shortName, element == null ? null : element.getProject());
        return toolList == null ? null : toolList.getInspectionTool(element);
    }

    @Nullable
    public InspectionProfileEntry getUnwrappedTool(@NotNull String shortName, @NotNull PsiElement element) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        InspectionToolWrapper tool = this.getInspectionTool(shortName, element);
        return tool == null ? null : tool.getTool();
    }

    public <T extends InspectionProfileEntry> T getUnwrappedTool(@NotNull Key<T> shortNameKey, @NotNull PsiElement element) {
        if (shortNameKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        return (T)this.getUnwrappedTool(shortNameKey.toString(), element);
    }

    public void modifyProfile(@NotNull Consumer<InspectionProfileModifiableModel> modelConsumer) {
        if (modelConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyProfile"));
        }
        InspectionProfileModifiableModelKt.edit(this, (Function1<? super InspectionProfileModifiableModel, Unit>)((Function1)it -> {
            if (modelConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "lambda$modifyProfile$0"));
            }
            modelConsumer.consume(it);
            return null;
        }));
    }

    public <T extends InspectionProfileEntry> void modifyToolSettings(@NotNull Key<T> shortNameKey, @NotNull PsiElement psiElement, @NotNull Consumer<T> toolConsumer) {
        if (shortNameKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        if (toolConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        this.modifyProfile((Consumer<InspectionProfileModifiableModel>)((Consumer)model -> {
            if (shortNameKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "lambda$modifyToolSettings$1"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ex/InspectionProfileImpl", "lambda$modifyToolSettings$1"));
            }
            if (toolConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "lambda$modifyToolSettings$1"));
            }
            InspectionProfileEntry tool = model.getUnwrappedTool(shortNameKey.toString(), psiElement);
            toolConsumer.consume((Object)tool);
        }));
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, Project project2) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTool"));
        }
        ToolsImpl tools = this.getToolsOrNull(shortName, project2);
        return tools != null ? tools.getTool() : null;
    }

    public InspectionToolWrapper getToolById(@NotNull String id, @NotNull PsiElement element) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolById"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolById"));
        }
        this.initInspectionTools(element.getProject());
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element);
            if (!id.equals(tool.getID())) continue;
            return tool;
        }
        return null;
    }

    @Nullable
    public List<InspectionToolWrapper> findToolsById(@NotNull String id, @NotNull PsiElement element) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/ex/InspectionProfileImpl", "findToolsById"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "findToolsById"));
        }
        ArrayList<InspectionToolWrapper> result2 = null;
        this.initInspectionTools(element.getProject());
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element);
            if (!id.equals(tool.getID())) continue;
            if (result2 == null) {
                result2 = new ArrayList<InspectionToolWrapper>();
            }
            result2.add(tool);
        }
        return result2;
    }

    @Nullable
    public String getSingleTool() {
        return this.myToolShortName;
    }

    public void setSingleTool(@NotNull String toolShortName) {
        if (toolShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setSingleTool"));
        }
        this.myToolShortName = toolShortName;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getDisplayName"));
        }
        return string;
    }

    public void scopesChanged() {
        if (!this.wasInitialized()) {
            return;
        }
        for (ToolsImpl tools : this.myTools.values()) {
            tools.scopesChanged();
        }
        this.getProfileManager().fireProfileChanged(this);
    }

    @Transient
    public boolean isProfileLocked() {
        return this.myLockedProfile;
    }

    public void lockProfile(boolean isLocked) {
        this.myLockedProfile = isLocked;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    public InspectionToolWrapper[] getInspectionTools(@Nullable PsiElement element) {
        this.initInspectionTools(element == null ? null : element.getProject());
        ArrayList<InspectionToolWrapper> result2 = new ArrayList<InspectionToolWrapper>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getInspectionTool(element));
        }
        InspectionToolWrapper[] inspectionToolWrapperArray = result2.toArray(new InspectionToolWrapper[result2.size()]);
        if (inspectionToolWrapperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTools"));
        }
        return inspectionToolWrapperArray;
    }

    @NotNull
    public List<Tools> getAllEnabledInspectionTools(Project project2) {
        this.initInspectionTools(project2);
        ArrayList<Tools> result2 = new ArrayList<Tools>();
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            result2.add(toolList);
        }
        ArrayList<Tools> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getAllEnabledInspectionTools"));
        }
        return arrayList;
    }

    public void disableTool(@NotNull String toolShortName, @NotNull PsiElement element) {
        if (toolShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        this.getTools(toolShortName, element.getProject()).disableTool(element);
    }

    public void disableToolByDefault(@NotNull Collection<String> toolShortNames, @Nullable Project project2) {
        if (toolShortNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortNames", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableToolByDefault"));
        }
        for (String toolId : toolShortNames) {
            this.getTools(toolId, project2).setDefaultEnabled(false);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    public ScopeToolState getToolDefaultState(@NotNull String toolShortName, @Nullable Project project2) {
        if (toolShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolDefaultState"));
        }
        ScopeToolState scopeToolState = this.getTools(toolShortName, project2).getDefaultState();
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolDefaultState"));
        }
        return scopeToolState;
    }

    public void enableToolsByDefault(@NotNull List<String> toolShortNames, Project project2) {
        if (toolShortNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortNames", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableToolsByDefault"));
        }
        for (String shortName : toolShortNames) {
            this.getTools(shortName, project2).setDefaultEnabled(true);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    protected List<InspectionToolWrapper> createTools(@Nullable Project project2) {
        List<InspectionToolWrapper> list = this.myRegistrar.createTools();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createTools"));
        }
        return list;
    }

    @Override
    protected void initialize(@Nullable Project project2) {
        List<InspectionToolWrapper> tools;
        SchemeDataHolder<? super InspectionProfileImpl> dataHolder = this.myDataHolder;
        if (dataHolder != null) {
            this.myDataHolder = null;
            Element element = dataHolder.read();
            if (element.getName().equals("component")) {
                element = element.getChild("profile");
            }
            assert (element != null);
            this.readExternal(element);
        }
        if (this.myBaseProfile != null) {
            this.myBaseProfile.initInspectionTools(project2);
        }
        try {
            tools = this.createTools(project2);
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        THashMap dependencies = new THashMap();
        for (InspectionToolWrapper toolWrapper : tools) {
            this.addTool(project2, toolWrapper, (Map<String, List<String>>)dependencies);
        }
        DFSTBuilder builder = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)new InboundSemiGraph<String>((Map)dependencies){
            final /* synthetic */ Map val$dependencies;
            {
                this.val$dependencies = map;
            }

            public Collection<String> getNodes() {
                return this.val$dependencies.keySet();
            }

            public Iterator<String> getIn(String n) {
                return ((List)this.val$dependencies.get(n)).iterator();
            }
        }));
        if (builder.isAcyclic()) {
            this.myScopesOrder = ArrayUtil.toStringArray((Collection)builder.getSortedNodes());
        }
        this.copyToolsConfigurations(project2);
        this.initialized = true;
        if (dataHolder != null) {
            dataHolder.updateDigest(this);
        }
    }

    protected void copyToolsConfigurations(@Nullable Project project2) {
    }

    public void addTool(@Nullable Project project2, @NotNull InspectionToolWrapper toolWrapper, @NotNull Map<String, List<String>> dependencies) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addTool"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addTool"));
        }
        String shortName = toolWrapper.getShortName();
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)shortName);
        if (key2 == null) {
            InspectionEP extension = toolWrapper.getExtension();
            Computable.PredefinedValueComputable computable = extension == null ? new Computable.PredefinedValueComputable((Object)toolWrapper.getDisplayName()) : () -> ((InspectionEP)extension).getDisplayName();
            key2 = toolWrapper instanceof LocalInspectionToolWrapper ? HighlightDisplayKey.register((String)shortName, (Computable)computable, (String)toolWrapper.getID(), (String)((LocalInspectionToolWrapper)toolWrapper).getAlternativeID()) : HighlightDisplayKey.register((String)shortName, (Computable)computable);
        }
        if (key2 == null) {
            LOG.error(shortName + " ; number of initialized tools: " + this.myTools.size());
            return;
        }
        HighlightDisplayLevel baseLevel = this.myBaseProfile != null && this.myBaseProfile.getToolsOrNull(shortName, project2) != null ? this.myBaseProfile.getErrorLevel(key2, project2) : HighlightDisplayLevel.DO_NOT_SHOW;
        HighlightDisplayLevel defaultLevel = toolWrapper.getDefaultLevel();
        HighlightDisplayLevel level = baseLevel.getSeverity().compareTo(defaultLevel.getSeverity()) > 0 ? baseLevel : defaultLevel;
        boolean enabled = this.myBaseProfile != null ? this.myBaseProfile.isToolEnabled(key2) : toolWrapper.isEnabledByDefault();
        ToolsImpl toolsList = new ToolsImpl(toolWrapper, level, !this.myLockedProfile && enabled, enabled);
        Element element = this.myUninitializedSettings.remove(shortName);
        try {
            if (element != null) {
                this.getPathMacroManager().expandPaths(element);
                toolsList.readExternal(element, this.getProfileManager(), dependencies);
            } else if (!this.myUninitializedSettings.containsKey(InspectionElementsMergerBase.getMergedMarkerName(shortName))) {
                Element merged;
                InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(shortName);
                Element element2 = merged = merger == null ? null : merger.merge(this.myUninitializedSettings);
                if (merged != null) {
                    this.getPathMacroManager().expandPaths(merged);
                    toolsList.readExternal(merged, this.getProfileManager(), dependencies);
                } else if (this.isProfileLocked()) {
                    toolsList.setEnabled(false);
                    if (toolsList.getNonDefaultTools() == null) {
                        toolsList.getDefaultState().setEnabled(false);
                    }
                }
            }
        }
        catch (InvalidDataException e) {
            LOG.error("Can't read settings for " + toolWrapper, (Throwable)e);
        }
        this.myTools.put(shortName, toolsList);
    }

    @Nullable
    private static InspectionElementsMergerBase getMerger(String shortName) {
        final InspectionElementsMerger merger = InspectionElementsMerger.getMerger((String)shortName);
        if (merger instanceof InspectionElementsMergerBase) {
            return (InspectionElementsMergerBase)merger;
        }
        return merger != null ? new InspectionElementsMergerBase(){

            public String getMergedToolName() {
                return merger.getMergedToolName();
            }

            public String[] getSourceToolNames() {
                return merger.getSourceToolNames();
            }
        } : null;
    }

    @Transient
    @Nullable
    public String[] getScopesOrder() {
        return this.myScopesOrder;
    }

    public void setScopesOrder(String[] scopesOrder) {
        this.myScopesOrder = scopesOrder;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    private HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key2, @Nullable Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        return this.getTools(key2.toString(), project2).getLevel();
    }

    @NotNull
    public InspectionProfileModifiableModel getModifiableModel() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = new InspectionProfileModifiableModel(this);
        if (inspectionProfileModifiableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getModifiableModel"));
        }
        return inspectionProfileModifiableModel;
    }

    public void cleanup(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "cleanup"));
        }
        if (!this.wasInitialized()) {
            return;
        }
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            toolList.cleanupTools(project2);
        }
    }

    public void enableTool(@NotNull String toolShortName, @Nullable Project project2) {
        if (toolShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTool"));
        }
        this.setToolEnabled(toolShortName, true, project2);
    }

    public void enableTool(@NotNull String inspectionTool, @NotNull NamedScope namedScope, Project project2) {
        if (inspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTool", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTool"));
        }
        if (namedScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedScope", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTool"));
        }
        this.getTools(inspectionTool, project2).enableTool(namedScope, project2);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void enableTools(@NotNull List<String> inspectionTools, @NotNull NamedScope namedScope, Project project2) {
        if (inspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTools", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTools"));
        }
        if (namedScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedScope", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTools"));
        }
        for (String inspectionTool : inspectionTools) {
            this.enableTool(inspectionTool, namedScope, project2);
        }
    }

    public void disableTools(@NotNull List<String> inspectionTools, NamedScope namedScope, @NotNull Project project2) {
        if (inspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTools", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTools"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTools"));
        }
        for (String inspectionTool : inspectionTools) {
            this.getTools(inspectionTool, project2).disableTool(namedScope, project2);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @Deprecated
    public void disableTool(@NotNull String inspectionTool, @Nullable Project project2) {
        if (inspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTool", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        this.setToolEnabled(inspectionTool, false, project2);
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key2, @NotNull HighlightDisplayLevel level, Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        this.getTools(key2.toString(), project2).setLevel(level);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public boolean isToolEnabled(@Nullable HighlightDisplayKey key2, @Nullable PsiElement element) {
        if (key2 == null) {
            return false;
        }
        ToolsImpl toolState = this.getToolsOrNull(key2.toString(), element == null ? null : element.getProject());
        return toolState != null && toolState.isEnabled(element);
    }

    public boolean isExecutable(@Nullable Project project2) {
        this.initInspectionTools(project2);
        for (Tools tools : this.myTools.values()) {
            if (!tools.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Tag
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = StringUtil.nullize((String)description);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void convert(@NotNull Element element, @NotNull Project project2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "convert"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "convert"));
        }
        Element scopes = element.getChild("scopes");
        if (scopes == null) {
            return;
        }
        this.initInspectionTools(project2);
        for (Element scopeElement : scopes.getChildren("scope")) {
            NamedScope scope;
            String profile2 = scopeElement.getAttributeValue("profile");
            InspectionProfileImpl inspectionProfile = profile2 == null ? null : this.getProfileManager().getProfile(profile2);
            NamedScope namedScope = scope = inspectionProfile == null ? null : this.getProfileManager().getScopesManager().getScope(scopeElement.getAttributeValue("name"));
            if (scope == null) continue;
            for (InspectionToolWrapper toolWrapper : inspectionProfile.getInspectionTools(null)) {
                HighlightDisplayKey key2 = HighlightDisplayKey.find((String)toolWrapper.getShortName());
                try {
                    InspectionToolWrapper toolWrapperCopy = InspectionProfileImpl.copyToolSettings(toolWrapper);
                    HighlightDisplayLevel errorLevel = inspectionProfile.getErrorLevel(key2, null, project2);
                    this.getTools(toolWrapper.getShortName(), project2).addTool(scope, toolWrapperCopy, inspectionProfile.isToolEnabled(key2), errorLevel);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        this.reduceConvertedScopes();
    }

    private void reduceConvertedScopes() {
        for (ToolsImpl tools : this.myTools.values()) {
            ScopeToolState toolState = tools.getDefaultState();
            List<ScopeToolState> nonDefaultTools = tools.getNonDefaultTools();
            if (nonDefaultTools == null) continue;
            boolean equal = true;
            boolean isEnabled = toolState.isEnabled();
            for (ScopeToolState state : nonDefaultTools) {
                isEnabled |= state.isEnabled();
                if (state.equalTo(toolState)) continue;
                equal = false;
            }
            tools.setEnabled(isEnabled);
            if (!equal) continue;
            tools.removeAllScopes();
        }
    }

    @NotNull
    public List<ScopeToolState> getAllTools() {
        this.initInspectionTools();
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        for (Tools tools : this.myTools.values()) {
            tools.collectTools(result2);
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getAllTools"));
        }
        return arrayList;
    }

    @NotNull
    public List<ScopeToolState> getDefaultStates(@Nullable Project project2) {
        this.initInspectionTools(project2);
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getDefaultState());
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getDefaultStates"));
        }
        return arrayList;
    }

    @NotNull
    public List<ScopeToolState> getNonDefaultTools(@NotNull String shortName, Project project2) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getNonDefaultTools"));
        }
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        List<ScopeToolState> nonDefaultTools = this.getTools(shortName, project2).getNonDefaultTools();
        if (nonDefaultTools != null) {
            result2.addAll(nonDefaultTools);
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getNonDefaultTools"));
        }
        return arrayList;
    }

    public boolean isToolEnabled(@NotNull HighlightDisplayKey key2, NamedScope namedScope, Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "isToolEnabled"));
        }
        return this.getTools(key2.toString(), project2).isEnabled(namedScope, project2);
    }

    public void removeScope(@NotNull String toolShortName, @NotNull String scopeName, Project project2) {
        if (toolShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScope"));
        }
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScope"));
        }
        this.getTools(toolShortName, project2).removeScope(scopeName);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void removeScopes(@NotNull List<String> shortNames, @NotNull String scopeName, Project project2) {
        if (shortNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNames", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScopes"));
        }
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScopes"));
        }
        for (String shortName : shortNames) {
            this.removeScope(shortName, scopeName, project2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Set<String> getChangedToolNames() {
        if (this.myBaseProfile == null) {
            return null;
        }
        if (this.myChangedToolNames == null) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myChangedToolNames == null) {
                    this.initInspectionTools(null);
                    Set<String> names = this.myTools.keySet();
                    THashSet map = new THashSet(names.size());
                    for (String toolId : names) {
                        if (InspectionProfileImpl.toolSettingsAreEqual(toolId, this.myBaseProfile, this)) continue;
                        map.add(toolId);
                    }
                    this.myChangedToolNames = map;
                    return map;
                }
            }
        }
        return this.myChangedToolNames;
    }

    public void profileChanged() {
        this.myChangedToolNames = null;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @Transient
    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key2, NamedScope scope, Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        ToolsImpl tools = this.getToolsOrNull(key2.toString(), project2);
        HighlightDisplayLevel highlightDisplayLevel = tools != null ? tools.getLevel(scope, project2) : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        return highlightDisplayLevel;
    }

    public ScopeToolState addScope(@NotNull InspectionToolWrapper toolWrapper, NamedScope scope, @NotNull HighlightDisplayLevel level, boolean enabled, Project project2) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addScope"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addScope"));
        }
        return this.getTools(toolWrapper.getShortName(), project2).prependTool(scope, toolWrapper, enabled, level);
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key2, @NotNull HighlightDisplayLevel level, String scopeName, Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        this.getTools(key2.toString(), project2).setLevel(level, scopeName, project2);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void setErrorLevel(@NotNull List<HighlightDisplayKey> keys, @NotNull HighlightDisplayLevel level, String scopeName, Project project2) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        for (HighlightDisplayKey key2 : keys) {
            this.setErrorLevel(key2, level, scopeName, project2);
        }
    }

    @Override
    @Nullable
    public ToolsImpl getToolsOrNull(@NotNull String name, @Nullable Project project2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolsOrNull"));
        }
        this.initInspectionTools(project2);
        return this.myTools.get(name);
    }

    public void enableAllTools(Project project2) {
        for (InspectionToolWrapper entry : this.getInspectionTools(null)) {
            this.enableTool(entry.getShortName(), project2);
        }
    }
}

