/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import org.jetbrains.annotations.NotNull;

public abstract class PerformFixesModalTask
implements SequentialTask {
    @NotNull
    protected final Project myProject;
    private final CommonProblemDescriptor[] myDescriptors;
    private final SequentialModalProgressTask myTask;
    private final PsiDocumentManager myDocumentManager;
    private int myCount;

    public PerformFixesModalTask(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull SequentialModalProgressTask task) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/PerformFixesModalTask", "<init>"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/PerformFixesModalTask", "<init>"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/codeInspection/ex/PerformFixesModalTask", "<init>"));
        }
        this.myCount = 0;
        this.myProject = project2;
        this.myDescriptors = descriptors;
        this.myTask = task;
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
    }

    public void prepare() {
    }

    public boolean isDone() {
        return this.myCount > this.myDescriptors.length - 1;
    }

    public boolean iteration() {
        CommonProblemDescriptor descriptor = this.myDescriptors[this.myCount++];
        ProgressIndicator indicator = this.myTask.getIndicator();
        if (indicator != null) {
            PsiElement psiElement;
            indicator.setFraction((double)this.myCount / (double)this.myDescriptors.length);
            String presentableText = "usages";
            if (descriptor instanceof ProblemDescriptor && (psiElement = ((ProblemDescriptor)descriptor).getPsiElement()) != null) {
                presentableText = SymbolPresentationUtil.getSymbolPresentableText(psiElement);
            }
            indicator.setText("Processing " + presentableText);
        }
        boolean[] runInReadAction = new boolean[]{false};
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null) {
            for (QuickFix fix : fixes) {
                if (fix.startInWriteAction()) {
                    runInReadAction[0] = false;
                    break;
                }
                runInReadAction[0] = true;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myDocumentManager.commitAllDocuments();
            if (!runInReadAction[0]) {
                this.applyFix(this.myProject, descriptor);
            }
        });
        if (runInReadAction[0]) {
            this.applyFix(this.myProject, descriptor);
        }
        return this.isDone();
    }

    public void stop() {
    }

    protected abstract void applyFix(Project var1, CommonProblemDescriptor var2);
}

