/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IteratorDeclaration;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8CollectionRemoveIfInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            void handleIteratorLoop(PsiLoopStatement statement2, PsiJavaToken endToken, IteratorDeclaration declaration) {
                if (endToken == null || declaration == null || !declaration.isCollection()) {
                    return;
                }
                PsiStatement body = statement2.getBody();
                if (!(body instanceof PsiBlockStatement)) {
                    return;
                }
                PsiStatement[] statements = ((PsiBlockStatement)body).getCodeBlock().getStatements();
                if (statements.length == 2 && statements[1] instanceof PsiIfStatement) {
                    PsiVariable element = declaration.getNextElementVariable(statements[0]);
                    if (element == null) {
                        return;
                    }
                    PsiIfStatement ifStatement = (PsiIfStatement)statements[1];
                    if (this.checkAndExtractCondition(declaration, ifStatement) == null) {
                        return;
                    }
                    this.registerProblem(statement2, endToken);
                } else if (statements.length == 1 && statements[0] instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)statements[0];
                    PsiExpression condition = this.checkAndExtractCondition(declaration, ifStatement);
                    if (condition == null) {
                        return;
                    }
                    PsiElement ref = declaration.findOnlyIteratorRef(condition);
                    if (ref != null && declaration.isIteratorMethodCall(ref.getParent().getParent(), "next") && this.isAlwaysExecuted(condition, ref)) {
                        this.registerProblem(statement2, endToken);
                    }
                }
            }

            private boolean isAlwaysExecuted(PsiExpression condition, PsiElement ref) {
                while (ref != condition) {
                    PsiPolyadicExpression polyadicExpression;
                    IElementType type;
                    PsiElement parent = ref.getParent();
                    if (parent instanceof PsiPolyadicExpression && ((type = (polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || type.equals(JavaTokenType.OROR)) && polyadicExpression.getOperands()[0] != ref) {
                        return false;
                    }
                    if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != ref) {
                        return false;
                    }
                    ref = parent;
                }
                return true;
            }

            private void registerProblem(PsiLoopStatement statement2, PsiJavaToken endToken) {
                holder.registerProblem((PsiElement)statement2, new TextRange(0, endToken.getTextOffset() - statement2.getTextOffset() + 1), QuickFixBundle.message("java.8.collection.removeif.inspection.description", new Object[0]), new LocalQuickFix[]{new ReplaceWithRemoveIfQuickFix()});
            }

            @Nullable
            private PsiExpression checkAndExtractCondition(IteratorDeclaration declaration, PsiIfStatement ifStatement) {
                PsiExpression condition = ifStatement.getCondition();
                if (condition == null || ifStatement.getElseBranch() != null) {
                    return null;
                }
                PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
                if (!(thenStatement instanceof PsiExpressionStatement)) {
                    return null;
                }
                if (!declaration.isIteratorMethodCall((PsiElement)((PsiExpressionStatement)thenStatement).getExpression(), "remove")) {
                    return null;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)condition)) {
                    return null;
                }
                return condition;
            }

            public void visitForStatement(PsiForStatement statement2) {
                super.visitForStatement(statement2);
                IteratorDeclaration declaration = IteratorDeclaration.fromLoop((PsiLoopStatement)statement2);
                this.handleIteratorLoop((PsiLoopStatement)statement2, statement2.getRParenth(), declaration);
            }

            public void visitWhileStatement(PsiWhileStatement statement2) {
                super.visitWhileStatement(statement2);
                IteratorDeclaration declaration = IteratorDeclaration.fromLoop((PsiLoopStatement)statement2);
                this.handleIteratorLoop((PsiLoopStatement)statement2, statement2.getRParenth(), declaration);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class ReplaceWithRemoveIfQuickFix
    implements LocalQuickFix {
        private ReplaceWithRemoveIfQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("java.8.collection.removeif.inspection.fix.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLoopStatement)) {
                return;
            }
            PsiLoopStatement loop = (PsiLoopStatement)element;
            IteratorDeclaration declaration = IteratorDeclaration.fromLoop(loop);
            if (declaration == null) {
                return;
            }
            PsiStatement body = loop.getBody();
            if (!(body instanceof PsiBlockStatement)) {
                return;
            }
            PsiStatement[] statements = ((PsiBlockStatement)body).getCodeBlock().getStatements();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            String replacement = null;
            CommentTracker ct = new CommentTracker();
            if (statements.length == 2 && statements[1] instanceof PsiIfStatement) {
                PsiVariable variable = declaration.getNextElementVariable(statements[0]);
                if (variable == null) {
                    return;
                }
                PsiExpression condition = ((PsiIfStatement)statements[1]).getCondition();
                if (condition == null) {
                    return;
                }
                replacement = ReplaceWithRemoveIfQuickFix.generateRemoveIf(declaration, ct, condition, variable.getName());
            } else if (statements.length == 1 && statements[0] instanceof PsiIfStatement) {
                PsiExpression condition = ((PsiIfStatement)statements[0]).getCondition();
                if (condition == null) {
                    return;
                }
                PsiElement ref = declaration.findOnlyIteratorRef(condition);
                if (ref != null) {
                    PsiElement call = ref.getParent().getParent();
                    if (!declaration.isIteratorMethodCall(call, "next")) {
                        return;
                    }
                    PsiType type = ((PsiExpression)call).getType();
                    JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
                    SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type);
                    if (info.names.length == 0) {
                        info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, "value", null, type);
                    }
                    String paramName = javaCodeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)info, (PsiElement)condition, (boolean)true).names[0];
                    ct.replace(call, (PsiElement)factory.createIdentifier(paramName));
                    replacement = ReplaceWithRemoveIfQuickFix.generateRemoveIf(declaration, ct, condition, paramName);
                }
            }
            if (replacement == null) {
                return;
            }
            ct.delete((PsiElement)declaration.getIterator());
            PsiElement result2 = ct.replaceAndRestoreComments((PsiElement)loop, replacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result2);
            CodeStyleManager.getInstance((Project)project2).reformat(result2);
        }

        @NotNull
        private static String generateRemoveIf(IteratorDeclaration declaration, CommentTracker ct, PsiExpression condition, String paramName) {
            String string = (declaration.getIterable() == null ? "" : ct.text((PsiElement)declaration.getIterable()) + ".") + "removeIf(" + paramName + "->" + ct.text((PsiElement)condition) + ");";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix", "generateRemoveIf"));
            }
            return string;
        }
    }
}

