/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefFieldImpl
extends RefJavaElementImpl
implements RefField {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final int ASSIGNED_ONLY_IN_INITIALIZER_MASK = 262144;

    RefFieldImpl(@NotNull RefClass ownerClass, PsiField field, RefManager manager) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/codeInspection/reference/RefFieldImpl", "<init>"));
        }
        super((PsiModifierListOwner)field, manager);
        ((RefClassImpl)ownerClass).add(this);
        if (ownerClass.isInterface()) {
            this.setIsStatic(true);
            this.setIsFinal(true);
        }
        if (field instanceof PsiEnumConstant) {
            this.putUserData(ENUM_CONSTANT, (Object)true);
        }
    }

    public PsiField getElement() {
        return (PsiField)super.getElement();
    }

    @Override
    protected void markReferenced(RefElementImpl refFrom, PsiElement psiFrom, PsiElement psiWhat, boolean forWriting, boolean forReading, PsiReferenceExpression expressionFrom) {
        PsiExpression qualifierExpression;
        PsiClassInitializer initializer;
        this.addInReference(refFrom);
        boolean referencedFromClassInitializer = false;
        if (forWriting && expressionFrom != null && (initializer = (PsiClassInitializer)PsiTreeUtil.getParentOfType((PsiElement)expressionFrom, PsiClassInitializer.class)) != null && initializer.getParent() instanceof PsiClass && psiFrom == initializer.getParent() && ((qualifierExpression = expressionFrom.getQualifierExpression()) == null || qualifierExpression instanceof PsiThisExpression && ((PsiThisExpression)qualifierExpression).getQualifier() == null)) {
            referencedFromClassInitializer = true;
        }
        if (forWriting) {
            this.setUsedForWriting(true);
        }
        if (forReading) {
            this.setUsedForReading(true);
        }
        this.setUsedQualifiedOutsidePackageFlag(refFrom, expressionFrom);
        this.getRefManager().fireNodeMarkedReferenced(this, refFrom, referencedFromClassInitializer, forReading, forWriting);
    }

    public boolean isUsedForReading() {
        return this.checkFlag(65536L);
    }

    private void setUsedForReading(boolean usedForReading) {
        this.setFlag(usedForReading, 65536L);
    }

    public boolean isUsedForWriting() {
        return this.checkFlag(131072L);
    }

    private void setUsedForWriting(boolean usedForWriting) {
        this.setFlag(false, 262144L);
        this.setFlag(usedForWriting, 131072L);
    }

    public boolean isOnlyAssignedInInitializer() {
        return this.checkFlag(262144L);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefFieldImpl", "accept"));
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefFieldImpl", "lambda$accept$0"));
                }
                ((RefJavaVisitor)visitor).visitField((RefField)this);
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public void buildReferences() {
        PsiField psiField = this.getElement();
        if (psiField != null) {
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            refUtil.addReferences((PsiModifierListOwner)psiField, (RefJavaElement)this, (PsiElement)psiField.getInitializer());
            refUtil.addReferences((PsiModifierListOwner)psiField, (RefJavaElement)this, (PsiElement)psiField.getModifierList());
            if (psiField instanceof PsiEnumConstant) {
                refUtil.addReferences((PsiModifierListOwner)psiField, (RefJavaElement)this, (PsiElement)psiField);
            }
            if ((psiField.getInitializer() != null || psiField instanceof PsiEnumConstant || RefUtil.isImplicitWrite((PsiElement)psiField)) && !this.checkFlag(131072L)) {
                this.setFlag(true, 262144L);
                this.setFlag(true, 131072L);
            }
            refUtil.addTypeReference((PsiElement)psiField, psiField.getType(), (RefManager)this.getRefManager(), (RefJavaElement)this);
            this.getRefManager().fireBuildReferences(this);
        }
    }

    public RefClass getOwnerClass() {
        return (RefClass)this.getOwner();
    }

    @Override
    public String getExternalName() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                PsiField psiField = RefFieldImpl.this.getElement();
                return psiField != null ? PsiFormatUtil.getExternalName((PsiModifierListOwner)psiField) : null;
            }
        });
    }

    @Nullable
    public static RefField fieldFromExternalName(RefManager manager, String externalName) {
        return (RefField)manager.getReference((PsiElement)RefFieldImpl.findPsiField(PsiManager.getInstance((Project)manager.getProject()), externalName));
    }

    @Nullable
    public static PsiField findPsiField(PsiManager manager, String externalName) {
        int classNameDelimiter = externalName.lastIndexOf(32);
        if (classNameDelimiter > 0 && classNameDelimiter < externalName.length() - 1) {
            String className = externalName.substring(0, classNameDelimiter);
            String fieldName = externalName.substring(classNameDelimiter + 1);
            PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)className);
            if (psiClass != null) {
                return psiClass.findFieldByName(fieldName, false);
            }
        }
        return null;
    }

    @Override
    public boolean isSuspicious() {
        if (this.isEntry()) {
            return false;
        }
        if (super.isSuspicious()) {
            return true;
        }
        return this.isUsedForReading() != this.isUsedForWriting();
    }

    @Override
    protected void initialize() {
    }
}

