/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameParameterValue;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.sameParameterValue.SameParameterValueInspectionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SameParameterValueInspection
extends SameParameterValueInspectionBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + SameParameterValueInspectionBase.class.getName()));

    @Override
    protected LocalQuickFix createFix(String paramName, String value) {
        return new InlineParameterValueFix(paramName, value);
    }

    public static class InlineParameterValueFix
    implements LocalQuickFix {
        private final String myValue;
        private final String myParameterName;

        private InlineParameterValueFix(String parameterName, String value) {
            this.myValue = value;
            this.myParameterName = parameterName;
        }

        public String toString() {
            return this.getParamName() + " " + this.getValue();
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.same.parameter.fix.name", (Object[])new Object[]{this.myParameterName, StringUtil.unquoteString((String)this.myValue)});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.same.parameter.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression defToInline;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method2 == null) {
                return;
            }
            PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
            if (parameter == null) {
                PsiParameter[] parameters;
                for (PsiParameter psiParameter : parameters = method2.getParameterList().getParameters()) {
                    if (!Comparing.strEqual((String)psiParameter.getName(), (String)this.myParameterName)) continue;
                    parameter = psiParameter;
                    break;
                }
            }
            if (parameter == null) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)parameter)) {
                return;
            }
            try {
                defToInline = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(this.myValue, (PsiElement)parameter);
            }
            catch (IncorrectOperationException e) {
                return;
            }
            PsiParameter parameterToInline = parameter;
            InlineParameterValueFix.inlineSameParameterValue(method2, parameterToInline, defToInline);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public static void inlineSameParameterValue(PsiMethod method2, PsiParameter parameter, PsiExpression defToInline) {
            MultiMap conflicts = new MultiMap();
            JavaSafeDeleteProcessor.collectMethodConflicts((MultiMap<PsiElement, String>)conflicts, method2, parameter);
            if (!conflicts.isEmpty()) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                        throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
                    }
                } else if (!new ConflictsDialog(parameter.getProject(), (MultiMap<PsiElement, String>)conflicts).showAndGet()) {
                    return;
                }
            }
            Collection refsToInline = ReferencesSearch.search((PsiElement)parameter).findAll();
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    PsiExpression[] exprs = new PsiExpression[refsToInline.size()];
                    int idx = 0;
                    for (PsiReference reference : refsToInline) {
                        if (!(reference instanceof PsiJavaCodeReferenceElement)) continue;
                        exprs[idx++] = InlineUtil.inlineVariable((PsiVariable)parameter, defToInline, (PsiJavaCodeReferenceElement)reference);
                    }
                    for (PsiExpression expr : exprs) {
                        if (expr == null) continue;
                        InlineUtil.tryToInlineArrayCreationForVarargs(expr);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            InlineParameterValueFix.removeParameter(method2, parameter);
        }

        public static void removeParameter(PsiMethod method2, PsiParameter parameter) {
            PsiParameter[] parameters = method2.getParameterList().getParameters();
            ArrayList<ParameterInfoImpl> psiParameters = new ArrayList<ParameterInfoImpl>();
            int paramIdx = 0;
            String paramName = parameter.getName();
            for (PsiParameter param : parameters) {
                if (!Comparing.strEqual((String)paramName, (String)param.getName())) {
                    psiParameters.add(new ParameterInfoImpl(paramIdx, param.getName(), param.getType()));
                }
                ++paramIdx;
            }
            new ChangeSignatureProcessor(method2.getProject(), method2, false, null, method2.getName(), method2.getReturnType(), psiParameters.toArray(new ParameterInfoImpl[psiParameters.size()])).run();
        }

        public String getValue() {
            return this.myValue;
        }

        public String getParamName() {
            return this.myParameterName;
        }
    }
}

