/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class CountMigration
extends BaseStreamApiMigration {
    CountMigration() {
        super("count()");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiStatement body, @NotNull TerminalBlock tb) {
        PsiExpression operand;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/CountMigration", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/CountMigration", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/CountMigration", "migrate"));
        }
        PsiExpression expression = tb.getSingleExpression(PsiExpression.class);
        if (expression == null) {
            expression = tb.getCountExpression();
        }
        if (!((operand = StreamApiMigrationInspection.extractIncrementedLValue(expression)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand).resolve();
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        return CountMigration.replaceWithNumericAddition(tb.getMainLoop(), (PsiVariable)var, tb.generate() + ".count()", (PsiType)PsiType.LONG);
    }
}

