/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

class SumMigration
extends BaseStreamApiMigration {
    SumMigration() {
        super("sum()");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiStatement body, @NotNull TerminalBlock tb) {
        PsiType addendType;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/SumMigration", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/SumMigration", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/SumMigration", "migrate"));
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiVariable var = StreamApiMigrationInspection.extractAccumulator(assignment);
        if (var == null) {
            return null;
        }
        PsiExpression addend = StreamApiMigrationInspection.extractAddend(assignment);
        if (addend == null) {
            return null;
        }
        PsiType type = var.getType();
        if (!(type instanceof PsiPrimitiveType) || type.equals(PsiType.FLOAT)) {
            return null;
        }
        if (!type.equals(PsiType.DOUBLE) && !type.equals(PsiType.LONG)) {
            type = PsiType.INT;
        }
        if ((addendType = addend.getType()) != null && !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)addendType)) {
            addend = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("(" + type.getCanonicalText() + ")" + ParenthesesUtils.getText(addend, 5), (PsiElement)addend);
        }
        String stream = tb.add(new StreamApiMigrationInspection.MapOp(addend, tb.getVariable(), type)).generate() + ".sum()";
        return SumMigration.replaceWithNumericAddition(tb.getMainLoop(), var, stream, type);
    }
}

