/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.codeInspection.streamToLoop.StreamVariable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FunctionHelper {
    private static final Logger LOG = Logger.getInstance(FunctionHelper.class);
    private String myResultType;

    FunctionHelper(PsiType resultType) {
        this.myResultType = resultType.getCanonicalText();
    }

    String getResultType() {
        return this.myResultType;
    }

    final String getText() {
        return this.getExpression().getText();
    }

    String getStatementText() {
        return this.getText() + ";\n";
    }

    abstract PsiExpression getExpression();

    String tryLightTransform(PsiType type) {
        return null;
    }

    abstract void transform(StreamToLoopInspection.StreamToLoopReplacementContext var1, String ... var2);

    void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
    }

    void registerReusedElements(Consumer<PsiElement> consumer) {
    }

    @Nullable
    String getParameterName(int index) {
        return null;
    }

    void preprocessVariable(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var, int index) {
        String name = this.getParameterName(index);
        if (name != null) {
            var.addBestNameCandidate(name);
        }
    }

    void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
    }

    List<String> suggestFinalOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, String desiredName, String worstCaseName) {
        List<String> candidates = Arrays.asList(JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, (String)desiredName, (PsiExpression)context.createExpression((String)this.getText()), (PsiType)context.createType((String)this.getResultType())).names);
        if (candidates.isEmpty() && worstCaseName != null) {
            candidates = Collections.singletonList(worstCaseName);
        }
        return candidates;
    }

    private static void suggestFromExpression(StreamVariable var, Project project2, PsiExpression expression) {
        SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)project2).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, expression, null, true);
        for (String name : info.names) {
            var.addOtherNameCandidate(name);
        }
    }

    @Contract(value="null, _ -> null")
    @Nullable
    static FunctionHelper create(PsiExpression expression, int paramCount) {
        return FunctionHelper.create(expression, paramCount, false);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    static FunctionHelper create(PsiExpression expression, int paramCount, boolean allowReturns) {
        PsiType type;
        if (expression == null) {
            return null;
        }
        PsiType psiType = type = expression instanceof PsiFunctionalExpression ? ((PsiFunctionalExpression)expression).getFunctionalInterfaceType() : expression.getType();
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
        if (interfaceMethod == null || interfaceMethod.getParameterList().getParametersCount() != paramCount) {
            return null;
        }
        PsiType returnType = interfaceMethod.getReturnType();
        if (returnType == null) {
            return null;
        }
        returnType = ((PsiClassType)type).resolveGenerics().getSubstitutor().substitute(returnType);
        type = FunctionHelper.fixType(type, expression.getProject());
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression;
            PsiParameterList list = lambda2.getParameterList();
            if (list.getParametersCount() != paramCount) {
                return null;
            }
            String[] parameters = (String[])StreamEx.of((Object[])list.getParameters()).map(PomNamedTarget::getName).toArray(String[]::new);
            PsiElement body = lambda2.getBody();
            PsiExpression lambdaExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body);
            if (lambdaExpression == null) {
                if (PsiType.VOID.equals((Object)returnType) && body instanceof PsiCodeBlock) {
                    List<PsiReturnStatement> returns = FunctionHelper.getReturns(body);
                    if (!allowReturns && !returns.isEmpty()) {
                        return null;
                    }
                    for (PsiReturnStatement ret : returns) {
                        if (PsiTreeUtil.getParentOfType((PsiElement)ret, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class}) == null) continue;
                        return null;
                    }
                    return new VoidBlockLambdaFunctionHelper((PsiCodeBlock)body, parameters);
                }
                return null;
            }
            return new LambdaFunctionHelper(returnType, (PsiElement)lambdaExpression, parameters);
        }
        if (expression instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression;
            if (methodRef.resolve() == null) {
                return null;
            }
            String template = FunctionHelper.tryInlineMethodReference(paramCount, methodRef);
            if (template != null) {
                return new InlinedFunctionHelper(returnType, paramCount, template);
            }
            return new MethodReferenceFunctionHelper(returnType, type, methodRef);
        }
        if (expression instanceof PsiReferenceExpression && ExpressionUtils.isSimpleExpression(expression)) {
            return new SimpleReferenceFunctionHelper(returnType, expression, interfaceMethod.getName());
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.function.Function", "identity", 0)) {
                return paramCount == 1 ? new InlinedFunctionHelper(returnType, 1, "{0}") : null;
            }
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.Comparator", "naturalOrder", 0)) {
                return paramCount == 2 ? new InlinedFunctionHelper(returnType, 2, "{0}.compareTo({1})") : null;
            }
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.Comparator", "reverseOrder", 0) || MethodCallUtils.isCallToStaticMethod(call, "java.util.Collections", "reverseOrder", 0)) {
                return paramCount == 2 ? new InlinedFunctionHelper(returnType, 2, "{1}.compareTo({0})") : null;
            }
        }
        return new ComplexExpressionFunctionHelper(returnType, type, interfaceMethod.getName(), expression);
    }

    private static PsiType fixType(PsiType type, Project project2) {
        PsiCapturedWildcardType capturedWildcardType;
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass != null && classType.getParameterCount() != 0) {
                PsiType[] parameters = classType.getParameters();
                Arrays.asList(parameters).replaceAll(t -> FunctionHelper.fixType(t, project2));
                return JavaPsiFacade.getElementFactory((Project)project2).createType(aClass, parameters);
            }
        } else if (type instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)type).getComponentType();
            PsiType fixedType = FunctionHelper.fixType(componentType, project2);
            if (fixedType != componentType) {
                return fixedType.createArrayType();
            }
        } else if (type instanceof PsiCapturedWildcardType && (capturedWildcardType = (PsiCapturedWildcardType)type).getLowerBound().equals(PsiType.NULL)) {
            return capturedWildcardType.getUpperBound();
        }
        return type;
    }

    @Nullable
    private static String tryInlineMethodReference(int paramCount, PsiMethodReferenceExpression methodRef) {
        PsiElement element = methodRef.resolve();
        if (element instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)element;
            String name = method2.getName();
            PsiClass aClass = method2.getContainingClass();
            if (aClass != null) {
                PsiExpression qualifier;
                String className = aClass.getQualifiedName();
                if ("java.util.Objects".equals(className) && paramCount == 1) {
                    if (name.equals("nonNull")) {
                        return "{0}!=null";
                    }
                    if (name.equals("isNull")) {
                        return "{0}==null";
                    }
                }
                if (paramCount == 2 && name.equals("sum") && ("java.lang.Integer".equals(className) || "java.lang.Long".equals(className) || "java.lang.Double".equals(className))) {
                    return "{0}+{1}";
                }
                if ("java.lang.Class".equals(className) && paramCount == 1 && (qualifier = methodRef.getQualifierExpression()) instanceof PsiClassObjectAccessExpression) {
                    PsiTypeElement type = ((PsiClassObjectAccessExpression)qualifier).getOperand();
                    if (name.equals("isInstance")) {
                        return "{0} instanceof " + type.getText();
                    }
                    if (name.equals("cast")) {
                        return "(" + type.getText() + "){0}";
                    }
                }
            }
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    static FunctionHelper newObjectSupplier(PsiType type, final String instanceClassName) {
        FunctionHelper functionHelper = new FunctionHelper(type){
            PsiExpression myExpression;

            @Override
            PsiExpression getExpression() {
                return this.myExpression;
            }

            @Override
            void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
                LOG.assertTrue(argumentValues.length == 0);
                this.myExpression = context.createExpression("new " + instanceClassName + "<>()");
            }
        };
        if (functionHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/FunctionHelper", "newObjectSupplier"));
        }
        return functionHelper;
    }

    static boolean hasVarReference(PsiElement expressionOrCodeBlock, String name, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(name + "->" + expressionOrCodeBlock.getText());
        PsiParameter var = lambda2.getParameterList().getParameters()[0];
        PsiElement body = lambda2.getBody();
        LOG.assertTrue(body != null);
        return ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope(body)).findFirst() != null;
    }

    @NotNull
    static <T extends PsiElement> T replaceVarReference(@NotNull T expressionOrCodeBlock, String name, String replacement, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        if (expressionOrCodeBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionOrCodeBlock", "com/intellij/codeInspection/streamToLoop/FunctionHelper", "replaceVarReference"));
        }
        if (name.equals(replacement)) {
            T t = expressionOrCodeBlock;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/FunctionHelper", "replaceVarReference"));
            }
            return t;
        }
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(name + "->" + expressionOrCodeBlock.getText());
        PsiParameter var = lambda2.getParameterList().getParameters()[0];
        PsiElement body = lambda2.getBody();
        LOG.assertTrue(body != null);
        PsiExpression replacementExpression = context.createExpression(replacement);
        for (PsiReference ref : ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope(body)).findAll()) {
            ref.getElement().replace((PsiElement)replacementExpression);
        }
        PsiElement psiElement = lambda2.getBody();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/FunctionHelper", "replaceVarReference"));
        }
        return (T)psiElement;
    }

    @NotNull
    private static List<PsiReturnStatement> getReturns(PsiElement body) {
        final ArrayList<PsiReturnStatement> returns = new ArrayList<PsiReturnStatement>();
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/streamToLoop/FunctionHelper$2", "visitClass"));
                }
            }

            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
                if (returnStatement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/intellij/codeInspection/streamToLoop/FunctionHelper$2", "visitReturnStatement"));
                }
                super.visitReturnStatement(returnStatement);
                returns.add(returnStatement);
            }
        });
        ArrayList<PsiReturnStatement> arrayList = returns;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/FunctionHelper", "getReturns"));
        }
        return arrayList;
    }

    private static class VoidBlockLambdaFunctionHelper
    extends LambdaFunctionHelper {
        VoidBlockLambdaFunctionHelper(PsiCodeBlock body, String[] parameters) {
            super((PsiType)PsiType.VOID, (PsiElement)body, parameters);
        }

        @Override
        String getStatementText() {
            Object[] children2 = this.myBody.getChildren();
            return StreamEx.of((Object[])children2, (int)1, (int)(children2.length - 1)).map(PsiElement::getText).joining().trim();
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            super.transform(context, argumentValues);
            if (!this.myBody.isValid()) {
                this.myBody = ((PsiLambdaExpression)context.createExpression("()->" + this.myBody.getText())).getBody();
            }
            List returns = FunctionHelper.getReturns(this.myBody);
            String continueStatement = "continue;";
            returns.forEach(ret -> ret.replace((PsiElement)context.createStatement(continueStatement)));
        }
    }

    private static class LambdaFunctionHelper
    extends FunctionHelper {
        String[] myParameters;
        PsiElement myBody;

        LambdaFunctionHelper(PsiType returnType, PsiElement body, String[] parameters) {
            super(returnType);
            this.myParameters = parameters;
            this.myBody = body;
        }

        @Override
        String tryLightTransform(PsiType type) {
            LOG.assertTrue(this.myParameters.length == 1);
            return this.myParameters[0];
        }

        @Override
        PsiExpression getExpression() {
            return (PsiExpression)this.myBody;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            LOG.assertTrue(argumentValues.length == this.myParameters.length);
            EntryStream.zip((Object[])this.myParameters, (Object[])argumentValues).forKeyValue((oldName, newName) -> {
                this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, oldName, newName, context);
            });
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            int idx = ArrayUtil.indexOf((Object[])this.myParameters, (Object)newName);
            if (idx >= 0) {
                int i2 = 1;
                while (true) {
                    String paramName;
                    if (!((paramName = newName + '$' + i2).equals(oldName) || StreamEx.of((Object[])this.myParameters).has((Object)paramName) || LambdaFunctionHelper.hasVarReference(this.myBody, paramName, context))) {
                        this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, newName, paramName, context);
                        this.myParameters[idx] = paramName;
                        break;
                    }
                    ++i2;
                }
            }
            this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept(this.myBody);
        }

        @Override
        String getParameterName(int index) {
            return this.myParameters[index];
        }

        @Override
        void preprocessVariable(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var, int index) {
            super.preprocessVariable(context, var, index);
            boolean hasClassOrLambda = StreamEx.ofTree((Object)this.myBody, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(e -> e instanceof PsiLambdaExpression || e instanceof PsiClass);
            if (hasClassOrLambda) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(this.getParameterName(index) + "->" + this.myBody.getText());
                PsiParameter parameter = lambda2.getParameterList().getParameters()[0];
                PsiElement body = lambda2.getBody();
                LOG.assertTrue(body != null);
                boolean mayBeNotFinal = ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(body)).forEach(e -> PsiTreeUtil.getParentOfType((PsiElement)e.getElement(), (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) == lambda2);
                if (!mayBeNotFinal) {
                    var.markFinal();
                }
            }
        }

        @Override
        void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
            PsiExpression expr = context.createExpression("(" + var.getType() + ")" + this.getText());
            FunctionHelper.suggestFromExpression(var, context.getProject(), expr);
        }
    }

    static class InlinedFunctionHelper
    extends FunctionHelper {
        private final int myArgCount;
        private final String myTemplate;
        private PsiExpression myExpression;

        public InlinedFunctionHelper(PsiType type, int argCount, String template) {
            super(type);
            this.myArgCount = argCount;
            this.myTemplate = template;
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            LOG.assertTrue(argumentValues.length == this.myArgCount);
            this.myExpression = context.createExpression(MessageFormat.format(this.myTemplate, argumentValues));
        }
    }

    private static class SimpleReferenceFunctionHelper
    extends FunctionHelper {
        private PsiExpression myReference;
        private final String myName;
        private PsiExpression myExpression;

        public SimpleReferenceFunctionHelper(PsiType returnType, PsiExpression reference, String methodName) {
            super(returnType);
            this.myReference = reference;
            this.myName = methodName;
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            this.myExpression = context.createExpression(this.myReference.getText() + "." + this.myName + "(" + String.join((CharSequence)",", argumentValues) + ")");
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myReference = SimpleReferenceFunctionHelper.replaceVarReference(this.myReference, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myReference);
        }
    }

    private static class ComplexExpressionFunctionHelper
    extends FunctionHelper {
        private final String myMethodName;
        private final String myNameCandidate;
        private final String myFnType;
        private PsiExpression myExpression;
        private PsiExpression myFinalExpression;

        private ComplexExpressionFunctionHelper(PsiType type, PsiType functionalInterface, String name, PsiExpression expression) {
            super(type);
            this.myMethodName = name;
            this.myExpression = expression;
            this.myNameCandidate = this.getNameCandidate(functionalInterface);
            this.myFnType = functionalInterface.getCanonicalText();
        }

        private String getNameCandidate(PsiType functionalInterface) {
            PsiElement parent = this.myExpression.getParent();
            if (parent instanceof PsiExpressionList) {
                PsiParameter[] parameters;
                PsiMethod method2;
                int idx = ArrayUtil.indexOf((Object[])((PsiExpressionList)parent).getExpressions(), (Object)this.myExpression);
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiMethodCallExpression && idx >= 0 && (method2 = ((PsiMethodCallExpression)gParent).resolveMethod()) != null && idx < (parameters = method2.getParameterList().getParameters()).length) {
                    return parameters[idx].getName();
                }
            }
            return functionalInterface.getPresentableText().toLowerCase(Locale.ENGLISH);
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myFinalExpression != null);
            return this.myFinalExpression;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myExpression = ComplexExpressionFunctionHelper.replaceVarReference(this.myExpression, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myExpression);
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            String varName = context.declare(this.myNameCandidate, this.myFnType, this.myExpression.getText());
            this.myFinalExpression = context.createExpression(varName + "." + this.myMethodName + "(" + String.join((CharSequence)",", argumentValues) + ")");
        }
    }

    private static class MethodReferenceFunctionHelper
    extends FunctionHelper {
        private final String myType;
        private final String myQualifierType;
        private PsiMethodReferenceExpression myMethodRef;
        private PsiExpression myExpression;

        public MethodReferenceFunctionHelper(PsiType returnType, PsiType functionalInterfaceType, PsiMethodReferenceExpression methodRef) {
            super(returnType);
            this.myMethodRef = methodRef;
            this.myType = functionalInterfaceType.getCanonicalText();
            PsiExpression qualifier = methodRef.getQualifierExpression();
            PsiType type = qualifier == null ? null : qualifier.getType();
            this.myQualifierType = type == null ? null : type.getCanonicalText();
        }

        @Override
        String tryLightTransform(PsiType type) {
            PsiLambdaExpression lambda2;
            if (this.myMethodRef.isConstructor()) {
                return null;
            }
            if ((type = GenericsUtil.getVariableTypeByExpressionType((PsiType)type)) == null) {
                return null;
            }
            PsiElement element = this.myMethodRef.resolve();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            PsiMethod method2 = (PsiMethod)element;
            String var = "x";
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return null;
            }
            if (method2.getModifierList().hasExplicitModifier("static")) {
                if (method2.getParameterList().getParametersCount() != 1) {
                    return null;
                }
                lambda2 = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)this.myMethodRef.getProject()).createExpressionFromText("(" + type.getCanonicalText() + " " + var + ")->" + aClass.getQualifiedName() + "." + method2.getName() + "(" + var + ")", (PsiElement)this.myMethodRef);
            } else {
                lambda2 = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)this.myMethodRef.getProject()).createExpressionFromText("(" + type.getCanonicalText() + " " + var + ")->" + var + "." + this.myMethodRef.getReferenceName() + "()", (PsiElement)this.myMethodRef);
            }
            this.myExpression = (PsiExpression)lambda2.getBody();
            return var;
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myMethodRef);
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            PsiLambdaExpression lambda2;
            String type;
            String qualifierText;
            PsiMethodReferenceExpression methodRef = this.fromText(context, this.myMethodRef.getText());
            PsiExpression qualifier = methodRef.getQualifierExpression();
            if (qualifier != null && !ExpressionUtils.isSimpleExpression(context.createExpression(qualifierText = qualifier.getText())) && (type = this.myQualifierType) != null) {
                String nameCandidate = "expr";
                PsiType psiType = context.createType(this.myQualifierType);
                SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, psiType, true);
                if (info.names.length > 0) {
                    nameCandidate = info.names[0];
                }
                String expr = context.declare(nameCandidate, type, qualifierText);
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)context.createExpression("(" + type + " " + expr + ")->(" + this.myType + ")" + expr + "::" + this.myMethodRef.getReferenceName());
                PsiTypeCastExpression castExpr = (PsiTypeCastExpression)lambdaExpression.getBody();
                LOG.assertTrue(castExpr != null);
                methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
                LOG.assertTrue(methodRef != null);
            }
            if ((lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda(methodRef, true, true)) == null) {
                throw new IllegalStateException("Unable to convert method reference to lambda: " + methodRef.getText());
            }
            PsiElement body = lambda2.getBody();
            LOG.assertTrue(body instanceof PsiExpression);
            this.myExpression = (PsiExpression)body;
            EntryStream.zip((Object[])lambda2.getParameterList().getParameters(), (Object[])argumentValues).forKeyValue((param, newName) -> {
                this.myExpression = MethodReferenceFunctionHelper.replaceVarReference(this.myExpression, param.getName(), newName, context);
            });
        }

        @Override
        void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
            PsiElement body;
            PsiTypeCastExpression castExpr = (PsiTypeCastExpression)context.createExpression("(" + this.myType + ")" + this.myMethodRef.getText());
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
            PsiLambdaExpression lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda(methodRef, true, true);
            if (lambda2 != null && (body = lambda2.getBody()) instanceof PsiExpression) {
                FunctionHelper.suggestFromExpression(var, context.getProject(), (PsiExpression)body);
            }
        }

        @NotNull
        private PsiMethodReferenceExpression fromText(StreamToLoopInspection.StreamToLoopReplacementContext context, String text) {
            PsiTypeCastExpression castExpr = (PsiTypeCastExpression)context.createExpression("(" + this.myType + ")" + text);
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
            LOG.assertTrue(methodRef != null);
            PsiMethodReferenceExpression psiMethodReferenceExpression = methodRef;
            if (psiMethodReferenceExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/FunctionHelper$MethodReferenceFunctionHelper", "fromText"));
            }
            return psiMethodReferenceExpression;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            if (oldName.equals(newName)) {
                return;
            }
            PsiExpression qualifier = this.myMethodRef.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            qualifier = MethodReferenceFunctionHelper.replaceVarReference(qualifier, oldName, newName, context);
            this.myMethodRef = this.fromText(context, qualifier.getText() + "::" + this.myMethodRef.getReferenceName());
        }
    }
}

