/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.ConditionalExpression;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.codeInspection.streamToLoop.StreamVariable;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TerminalOperation
extends Operation {
    TerminalOperation() {
    }

    @Override
    final String wrap(StreamVariable inVar, StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        return this.generate(inVar, context);
    }

    @Override
    final void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        throw new IllegalStateException("Should not be called for terminal operation (tried to rename " + oldName + " -> " + newName + ")");
    }

    @Override
    final boolean changesVariable() {
        return true;
    }

    CollectorOperation asCollector() {
        return null;
    }

    abstract String generate(StreamVariable var1, StreamToLoopInspection.StreamToLoopReplacementContext var2);

    @Nullable
    static TerminalOperation createTerminal(@NotNull String name, @NotNull PsiExpression[] args, @NotNull PsiType elementType, @NotNull PsiType resultType, boolean isVoid) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "createTerminal"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "createTerminal"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "createTerminal"));
        }
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "createTerminal"));
        }
        if (isVoid) {
            if ((name.equals("forEach") || name.equals("forEachOrdered")) && args.length == 1) {
                FunctionHelper fn = FunctionHelper.create(args[0], 1, true);
                return fn == null ? null : new ForEachTerminalOperation(fn);
            }
            return null;
        }
        if (name.equals("count") && args.length == 0) {
            return TemplateBasedOperation.counting();
        }
        if (name.equals("sum") && args.length == 0) {
            return TemplateBasedOperation.summing(resultType);
        }
        if (name.equals("average") && args.length == 0) {
            if (elementType.equals(PsiType.DOUBLE)) {
                return new AverageTerminalOperation(true, true);
            }
            if (elementType.equals(PsiType.INT) || elementType.equals(PsiType.LONG)) {
                return new AverageTerminalOperation(false, true);
            }
        }
        if (name.equals("summaryStatistics") && args.length == 0) {
            return TemplateBasedOperation.summarizing(resultType);
        }
        if ((name.equals("findFirst") || name.equals("findAny")) && args.length == 0) {
            PsiType optionalElementType = OptionalUtil.getOptionalElementType(resultType);
            return optionalElementType == null ? null : new FindTerminalOperation(optionalElementType.getCanonicalText());
        }
        if (name.equals("toList") && args.length == 0) {
            return ToCollectionTerminalOperation.toList(resultType);
        }
        if (name.equals("toSet") && args.length == 0) {
            return ToCollectionTerminalOperation.toSet(resultType);
        }
        if ((name.equals("anyMatch") || name.equals("allMatch") || name.equals("noneMatch")) && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new MatchTerminalOperation(fn, name);
        }
        if (name.equals("reduce")) {
            FunctionHelper fn;
            if ((args.length == 2 || args.length == 3) && (fn = FunctionHelper.create(args[1], 2)) != null) {
                return new ReduceTerminalOperation(args[0], fn, resultType.getCanonicalText());
            }
            if (args.length == 1) {
                return ReduceToOptionalTerminalOperation.create(args[0], resultType);
            }
        }
        if (name.equals("toArray") && args.length < 2) {
            if (!(resultType instanceof PsiArrayType)) {
                return null;
            }
            PsiType componentType = ((PsiArrayType)resultType).getComponentType();
            if (componentType instanceof PsiPrimitiveType) {
                if (args.length == 0) {
                    return new ToPrimitiveArrayTerminalOperation(componentType.getCanonicalText());
                }
            } else {
                FunctionHelper fn = null;
                if (args.length == 1 && (fn = FunctionHelper.create(args[0], 1)) == null) {
                    return null;
                }
                return new ToArrayTerminalOperation(elementType, fn);
            }
        }
        if ((name.equals("max") || name.equals("min")) && args.length < 2) {
            return MinMaxTerminalOperation.create(args.length == 1 ? args[0] : null, elementType.getCanonicalText(), name.equals("max"));
        }
        if (name.equals("collect")) {
            if (args.length == 3) {
                FunctionHelper supplier = FunctionHelper.create(args[0], 0);
                if (supplier == null) {
                    return null;
                }
                FunctionHelper accumulator = FunctionHelper.create(args[1], 2);
                if (accumulator == null) {
                    return null;
                }
                return new ExplicitCollectTerminalOperation(supplier, accumulator);
            }
            if (args.length == 1) {
                return TerminalOperation.fromCollector(elementType.getCanonicalText(), resultType, args[0]);
            }
        }
        return null;
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static TerminalOperation fromCollector(@NotNull String elementType, @NotNull PsiType resultType, PsiExpression expr) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "fromCollector"));
        }
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "fromCollector"));
        }
        if (!(expr instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)expr;
        PsiExpression[] collectorArgs = collectorCall.getArgumentList().getExpressions();
        PsiMethod collector = collectorCall.resolveMethod();
        if (collector == null) {
            return null;
        }
        PsiClass collectorClass = collector.getContainingClass();
        if (collectorClass != null && "java.util.stream.Collectors".equals(collectorClass.getQualifiedName())) {
            return TerminalOperation.fromCollector(elementType, resultType, collector, collectorArgs);
        }
        return null;
    }

    @Nullable
    private static TerminalOperation fromCollector(@NotNull String elementType, @NotNull PsiType resultType, PsiMethod collector, PsiExpression[] collectorArgs) {
        String collectorName;
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "fromCollector"));
        }
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "fromCollector"));
        }
        switch (collectorName = collector.getName()) {
            case "toList": {
                if (collectorArgs.length != 0) {
                    return null;
                }
                return ToCollectionTerminalOperation.toList(resultType);
            }
            case "toSet": {
                if (collectorArgs.length != 0) {
                    return null;
                }
                return ToCollectionTerminalOperation.toSet(resultType);
            }
            case "toCollection": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 0);
                return fn == null ? null : new ToCollectionTerminalOperation(resultType, fn, null);
            }
            case "toMap": {
                FunctionHelper supplier;
                if (collectorArgs.length < 2 || collectorArgs.length > 4) {
                    return null;
                }
                FunctionHelper key2 = FunctionHelper.create(collectorArgs[0], 1);
                FunctionHelper value = FunctionHelper.create(collectorArgs[1], 1);
                if (key2 == null || value == null) {
                    return null;
                }
                PsiExpression merger = collectorArgs.length > 2 ? collectorArgs[2] : null;
                FunctionHelper functionHelper = supplier = collectorArgs.length == 4 ? FunctionHelper.create(collectorArgs[3], 0) : FunctionHelper.newObjectSupplier(resultType, "java.util.HashMap");
                if (supplier == null) {
                    return null;
                }
                return new ToMapTerminalOperation(key2, value, merger, supplier, resultType);
            }
            case "reducing": {
                switch (collectorArgs.length) {
                    case 1: {
                        return ReduceToOptionalTerminalOperation.create(collectorArgs[0], resultType);
                    }
                    case 2: {
                        FunctionHelper fn = FunctionHelper.create(collectorArgs[1], 2);
                        return fn == null ? null : new ReduceTerminalOperation(collectorArgs[0], fn, resultType.getCanonicalText());
                    }
                    case 3: {
                        FunctionHelper mapper = FunctionHelper.create(collectorArgs[1], 1);
                        FunctionHelper fn = FunctionHelper.create(collectorArgs[2], 2);
                        return fn == null || mapper == null ? null : new MappingTerminalOperation(mapper, new ReduceTerminalOperation(collectorArgs[0], fn, resultType.getCanonicalText()));
                    }
                }
                return null;
            }
            case "counting": {
                if (collectorArgs.length != 0) {
                    return null;
                }
                return TemplateBasedOperation.counting();
            }
            case "summingInt": 
            case "summingLong": 
            case "summingDouble": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                PsiPrimitiveType type = PsiPrimitiveType.getUnboxedType((PsiType)resultType);
                return fn == null || type == null ? null : new InlineMappingTerminalOperation(fn, TemplateBasedOperation.summing((PsiType)type));
            }
            case "summarizingInt": 
            case "summarizingLong": 
            case "summarizingDouble": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                return fn == null ? null : new InlineMappingTerminalOperation(fn, TemplateBasedOperation.summarizing(resultType));
            }
            case "averagingInt": 
            case "averagingLong": 
            case "averagingDouble": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                return fn == null ? null : new InlineMappingTerminalOperation(fn, new AverageTerminalOperation(collectorName.equals("averagingDouble"), false));
            }
            case "mapping": {
                if (collectorArgs.length != 2) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                if (fn == null) {
                    return null;
                }
                TerminalOperation downstreamOp = TerminalOperation.fromCollector(fn.getResultType(), resultType, collectorArgs[1]);
                return downstreamOp == null ? null : new MappingTerminalOperation(fn, downstreamOp);
            }
            case "groupingBy": 
            case "partitioningBy": {
                CollectorOperation downstreamCollector;
                if (collectorArgs.length == 0 || collectorArgs.length > 3 || collectorArgs.length == 3 && collectorName.equals("partitioningBy")) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                if (fn == null) {
                    return null;
                }
                PsiType resultSubType = PsiUtil.substituteTypeParameter((PsiType)resultType, (String)"java.util.Map", (int)1, (boolean)false);
                if (resultSubType == null) {
                    return null;
                }
                if (collectorArgs.length == 1) {
                    downstreamCollector = ToCollectionTerminalOperation.toList(resultSubType).asCollector();
                } else {
                    PsiExpression downstream = collectorArgs[collectorArgs.length - 1];
                    TerminalOperation downstreamOp = TerminalOperation.fromCollector(elementType, resultSubType, downstream);
                    if (downstreamOp == null) {
                        return null;
                    }
                    downstreamCollector = downstreamOp.asCollector();
                }
                if (downstreamCollector == null) {
                    return null;
                }
                if (collectorName.equals("partitioningBy")) {
                    return new PartitionByTerminalOperation(fn, resultType, downstreamCollector);
                }
                FunctionHelper supplier = collectorArgs.length == 3 ? FunctionHelper.create(collectorArgs[1], 0) : FunctionHelper.newObjectSupplier(resultType, "java.util.HashMap");
                return new GroupByTerminalOperation(fn, supplier, resultType, downstreamCollector);
            }
            case "minBy": 
            case "maxBy": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                return MinMaxTerminalOperation.create(collectorArgs[0], elementType, collectorName.equals("maxBy"));
            }
            case "joining": {
                switch (collectorArgs.length) {
                    case 0: {
                        return new TemplateBasedOperation("sb", "java.lang.StringBuilder", "new java.lang.StringBuilder()", "{acc}.append({item});", "{acc}.toString()");
                    }
                    case 1: 
                    case 3: {
                        String initializer = "new java.util.StringJoiner(" + StreamEx.of((Object[])collectorArgs).map(PsiElement::getText).joining((CharSequence)",") + ")";
                        return new TemplateBasedOperation("joiner", "java.util.StringJoiner", initializer, "{acc}.add({item});", "{acc}.toString()");
                    }
                }
                return null;
            }
        }
        return null;
    }

    @NotNull
    static PsiType correctTypeParameters(PsiType type, String superClass, Map<String, Function<PsiType, PsiType>> downstreamCorrectors) {
        PsiSubstitutor origSubstitutor;
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (aClass == null) {
            PsiType psiType = type;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "correctTypeParameters"));
            }
            return psiType;
        }
        PsiSubstitutor substitutor = origSubstitutor = ((PsiClassType)type).resolveGenerics().getSubstitutor();
        Project project2 = aClass.getProject();
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)project2).findClass(superClass, aClass.getResolveScope());
        if (baseClass == null) {
            PsiType psiType = type;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "correctTypeParameters"));
            }
            return psiType;
        }
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        for (PsiTypeParameter baseParameter : baseClass.getTypeParameters()) {
            PsiClass substitution = PsiUtil.resolveClassInClassTypeOnly((PsiType)superClassSubstitutor.substitute(baseParameter));
            if (!(substitution instanceof PsiTypeParameter)) continue;
            PsiTypeParameter subClassParameter = (PsiTypeParameter)substitution;
            PsiType origType = origSubstitutor.substitute(subClassParameter);
            PsiType replacedType = GenericsUtil.eliminateWildcards((PsiType)origType, (boolean)false, (boolean)true);
            replacedType = (PsiType)downstreamCorrectors.getOrDefault(subClassParameter.getName(), Function.identity()).apply(replacedType);
            if (replacedType == origType) continue;
            substitutor = substitutor.put(subClassParameter, replacedType);
        }
        Object object = substitutor == origSubstitutor ? type : JavaPsiFacade.getElementFactory((Project)project2).createType(aClass, substitutor);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/TerminalOperation", "correctTypeParameters"));
        }
        return object;
    }

    static class SortedTerminalOperation
    extends TerminalOperation {
        private final AccumulatedOperation myOrigin;
        @Nullable
        private final PsiExpression myComparator;

        SortedTerminalOperation(AccumulatedOperation origin, @Nullable PsiExpression comparator2) {
            this.myOrigin = origin;
            this.myComparator = comparator2;
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.myOrigin.registerReusedElements(consumer);
            if (this.myComparator != null) {
                consumer.accept((PsiElement)this.myComparator);
            }
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myOrigin.preprocessVariables(context, inVar, outVar);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String acc = this.myOrigin.initAccumulator(inVar, context);
            context.addAfterStep(acc + ".sort(" + (this.myComparator == null ? "null" : this.myComparator.getText()) + ");\n");
            return this.myOrigin.getAccumulatorUpdater(inVar, acc);
        }
    }

    static class ForEachTerminalOperation
    extends TerminalOperation {
        private FunctionHelper myFn;

        public ForEachTerminalOperation(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myFn.preprocessVariable(context, inVar, 0);
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.myFn.registerReusedElements(consumer);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myFn.transform(context, inVar.getName());
            return this.myFn.getStatementText();
        }
    }

    static class InlineMappingTerminalOperation
    extends AbstractMappingTerminalOperation {
        InlineMappingTerminalOperation(FunctionHelper mapper, TerminalOperation downstream) {
            super(mapper, downstream);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myMapper.transform(context, inVar.getName());
            StreamVariable updatedVar = new StreamVariable(this.myMapper.getResultType(), this.myMapper.getText());
            return this.myDownstream.generate(updatedVar, context);
        }

        @Override
        public void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String item) {
            this.myMapper.transform(context, item);
            this.myDownstreamCollector.transform(context, this.myMapper.getText());
        }

        @Override
        public String getAccumulatorUpdater(StreamVariable inVar, String acc) {
            return this.myDownstreamCollector.getAccumulatorUpdater(new StreamVariable(this.myMapper.getResultType(), this.myMapper.getText()), acc);
        }

        @Override
        public String getMerger(StreamVariable inVar, String map, String key2) {
            return this.myDownstreamCollector.getMerger(new StreamVariable(this.myMapper.getResultType(), this.myMapper.getText()), map, key2);
        }
    }

    static class MappingTerminalOperation
    extends AbstractMappingTerminalOperation {
        private StreamVariable myVariable;

        MappingTerminalOperation(FunctionHelper mapper, TerminalOperation downstream) {
            super(mapper, downstream);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.createVariable(context, inVar.getName());
            return this.myVariable.getDeclaration(this.myMapper.getText()) + this.myDownstream.generate(this.myVariable, context);
        }

        private void createVariable(StreamToLoopInspection.StreamToLoopReplacementContext context, String item) {
            this.myMapper.transform(context, item);
            this.myVariable = new StreamVariable(this.myMapper.getResultType());
            this.myDownstream.preprocessVariables(context, this.myVariable, StreamVariable.STUB);
            this.myMapper.suggestFinalOutputNames(context, null, null).forEach(this.myVariable::addOtherNameCandidate);
            this.myVariable.register(context);
        }

        @Override
        public void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String item) {
            this.createVariable(context, item);
            this.myDownstreamCollector.transform(context, this.myVariable.getName());
        }

        @Override
        public String getAccumulatorUpdater(StreamVariable inVar, String acc) {
            return this.myVariable.getDeclaration(this.myMapper.getText()) + this.myDownstreamCollector.getAccumulatorUpdater(this.myVariable, acc);
        }

        @Override
        public String getMerger(StreamVariable inVar, String map, String key2) {
            String merger = this.myDownstreamCollector.getMerger(this.myVariable, map, key2);
            return merger == null ? null : this.myVariable.getDeclaration(this.myMapper.getText()) + merger;
        }
    }

    static abstract class AbstractMappingTerminalOperation
    extends TerminalOperation
    implements CollectorOperation {
        final FunctionHelper myMapper;
        final TerminalOperation myDownstream;
        final CollectorOperation myDownstreamCollector;

        AbstractMappingTerminalOperation(FunctionHelper mapper, TerminalOperation downstream) {
            this.myMapper = mapper;
            this.myDownstream = downstream;
            this.myDownstreamCollector = downstream.asCollector();
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.myMapper.registerReusedElements(consumer);
            this.myDownstream.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myMapper.preprocessVariable(context, inVar, 0);
        }

        @Override
        public PsiType correctReturnType(PsiType type) {
            return this.myDownstreamCollector.correctReturnType(type);
        }

        @Override
        CollectorOperation asCollector() {
            return this.myDownstreamCollector == null ? null : this;
        }

        @Override
        public String getSupplier() {
            return this.myDownstreamCollector.getSupplier();
        }
    }

    static class PartitionByTerminalOperation
    extends TerminalOperation {
        private final String myResultType;
        private final CollectorOperation myCollector;
        private FunctionHelper myPredicate;

        public PartitionByTerminalOperation(FunctionHelper predicate, PsiType resultType, CollectorOperation collector) {
            this.myPredicate = predicate;
            this.myResultType = resultType.getCanonicalText();
            this.myCollector = collector;
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.myPredicate.registerReusedElements(consumer);
            this.myCollector.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myPredicate.preprocessVariable(context, inVar, 0);
            this.myCollector.preprocessVariables(context, inVar, outVar);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            PsiType resultType = context.createType(this.myResultType);
            resultType = PartitionByTerminalOperation.correctTypeParameters(resultType, "java.util.Map", Collections.singletonMap("V", this.myCollector::correctReturnType));
            String map = context.declareResult("map", resultType.getCanonicalText(), "new java.util.HashMap<>()", StreamToLoopInspection.ResultKind.FINAL);
            this.myPredicate.transform(context, inVar.getName());
            this.myCollector.transform(context, inVar.getName());
            context.addBeforeStep(map + ".put(false, " + this.myCollector.getSupplier() + ");");
            context.addBeforeStep(map + ".put(true, " + this.myCollector.getSupplier() + ");");
            String key2 = this.myPredicate.getText();
            String merger = this.myCollector.getMerger(inVar, map, key2);
            if (merger != null) {
                return merger;
            }
            return this.myCollector.getAccumulatorUpdater(inVar, map + ".get(" + key2 + ")");
        }
    }

    static class GroupByTerminalOperation
    extends CollectorBasedTerminalOperation {
        private final CollectorOperation myCollector;
        private FunctionHelper myKeyExtractor;
        private String myKeyVar;

        public GroupByTerminalOperation(FunctionHelper keyExtractor, FunctionHelper supplier, PsiType resultType, CollectorOperation collector) {
            super(resultType.getCanonicalText(), context -> "map", supplier);
            this.myKeyExtractor = keyExtractor;
            this.myCollector = collector;
        }

        @Override
        public PsiType correctReturnType(PsiType type) {
            return GroupByTerminalOperation.correctTypeParameters(type, "java.util.Map", Collections.singletonMap("V", this.myCollector::correctReturnType));
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            super.registerReusedElements(consumer);
            this.myKeyExtractor.registerReusedElements(consumer);
            this.myCollector.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myKeyExtractor.preprocessVariable(context, inVar, 0);
            this.myCollector.preprocessVariables(context, inVar, outVar);
        }

        @Override
        public void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String item) {
            super.transform(context, item);
            this.myKeyExtractor.transform(context, item);
            this.myCollector.transform(context, item);
            this.myKeyVar = context.registerVarName(Arrays.asList("k", "key"));
        }

        @Override
        public String getAccumulatorUpdater(StreamVariable inVar, String map) {
            String key2 = this.myKeyExtractor.getText();
            String merger = this.myCollector.getMerger(inVar, map, key2);
            if (merger != null) {
                return merger;
            }
            String acc = map + ".computeIfAbsent(" + key2 + "," + this.myKeyVar + "->" + this.myCollector.getSupplier() + ")";
            return this.myCollector.getAccumulatorUpdater(inVar, acc);
        }
    }

    static class ToMapTerminalOperation
    extends CollectorBasedTerminalOperation {
        private final FunctionHelper myKeyExtractor;
        private final FunctionHelper myValueExtractor;
        private final PsiExpression myMerger;

        ToMapTerminalOperation(FunctionHelper keyExtractor, FunctionHelper valueExtractor, PsiExpression merger, FunctionHelper supplier, PsiType resultType) {
            super(resultType.getCanonicalText(), context -> "map", supplier);
            this.myKeyExtractor = keyExtractor;
            this.myValueExtractor = valueExtractor;
            this.myMerger = merger;
        }

        @Override
        public PsiType correctReturnType(PsiType type) {
            return ToMapTerminalOperation.correctTypeParameters(type, "java.util.Map", Collections.emptyMap());
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            super.registerReusedElements(consumer);
            this.myKeyExtractor.registerReusedElements(consumer);
            this.myValueExtractor.registerReusedElements(consumer);
            if (this.myMerger != null) {
                consumer.accept((PsiElement)this.myMerger);
            }
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myKeyExtractor.preprocessVariable(context, inVar, 0);
            this.myValueExtractor.preprocessVariable(context, inVar, 0);
        }

        @Override
        public void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String item) {
            super.transform(context, item);
            this.myKeyExtractor.transform(context, item);
            this.myValueExtractor.transform(context, item);
        }

        @Override
        public String getAccumulatorUpdater(StreamVariable inVar, String map) {
            PsiReferenceExpression ref;
            PsiExpression body;
            PsiLambdaExpression lambda2;
            PsiParameter[] parameters;
            if (this.myMerger == null) {
                return "if(" + map + ".put(" + this.myKeyExtractor.getText() + "," + this.myValueExtractor.getText() + ")!=null) {\nthrow new java.lang.IllegalStateException(\"Duplicate key\");\n}\n";
            }
            if (this.myMerger instanceof PsiLambdaExpression && (parameters = (lambda2 = (PsiLambdaExpression)this.myMerger).getParameterList().getParameters()).length == 2 && (body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody())) instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)body).getQualifierExpression() == null) {
                if (Objects.equals(parameters[0].getName(), ref.getReferenceName())) {
                    return map + ".putIfAbsent(" + this.myKeyExtractor.getText() + "," + this.myValueExtractor.getText() + ");\n";
                }
                if (Objects.equals(parameters[1].getName(), ref.getReferenceName())) {
                    return map + ".put(" + this.myKeyExtractor.getText() + "," + this.myValueExtractor.getText() + ");\n";
                }
            }
            return map + ".merge(" + this.myKeyExtractor.getText() + "," + this.myValueExtractor.getText() + "," + this.myMerger.getText() + ");\n";
        }
    }

    static class MinMaxTerminalOperation
    extends TerminalOperation {
        private String myType;
        private String myTemplate;
        @Nullable
        private FunctionHelper myComparator;

        public MinMaxTerminalOperation(String type, String template, @Nullable FunctionHelper comparator2) {
            this.myType = type;
            this.myTemplate = template;
            this.myComparator = comparator2;
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            if (this.myComparator != null) {
                this.myComparator.registerReusedElements(consumer);
            }
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String comparePredicate;
            String seen = context.declare("seen", "boolean", "false");
            String best = context.declareResult("best", this.myType, TypeConversionUtil.isPrimitive((String)this.myType) ? "0" : "null", StreamToLoopInspection.ResultKind.UNKNOWN);
            context.setFinisher(new ConditionalExpression.Optional(this.myType, seen, best));
            if (this.myComparator != null) {
                this.myComparator.transform(context, inVar.getName(), best);
                PsiExpression expression = this.myComparator.getExpression();
                int expressionPrecedence = ParenthesesUtils.getPrecedence(expression);
                String text = expressionPrecedence >= 9 ? "(" + expression.getText() + ")" : expression.getText();
                comparePredicate = this.myTemplate.replace("{comparator}", text);
            } else {
                comparePredicate = this.myTemplate.replace("{best}", best).replace("{item}", inVar.getName());
            }
            return "if(!" + seen + " || " + comparePredicate + ") {\n" + seen + "=true;\n" + best + "=" + inVar + ";\n}\n";
        }

        @Nullable
        static MinMaxTerminalOperation create(@Nullable PsiExpression comparator2, String elementType, boolean max) {
            String sign;
            String string = sign = max ? ">" : "<";
            if (comparator2 == null) {
                if (PsiType.INT.equalsToText(elementType) || PsiType.LONG.equalsToText(elementType)) {
                    return new MinMaxTerminalOperation(elementType, "{item}" + sign + "{best}", null);
                }
                if (PsiType.DOUBLE.equalsToText(elementType)) {
                    return new MinMaxTerminalOperation(elementType, "java.lang.Double.compare({item},{best})" + sign + "0", null);
                }
            } else {
                FunctionHelper fn = FunctionHelper.create(comparator2, 2);
                if (fn != null) {
                    return new MinMaxTerminalOperation(elementType, "{comparator}" + sign + "0", fn);
                }
            }
            return null;
        }
    }

    static class ToCollectionTerminalOperation
    extends CollectorBasedTerminalOperation {
        private final boolean myList;

        public ToCollectionTerminalOperation(PsiType resultType, FunctionHelper fn, String desiredName) {
            super(resultType.getCanonicalText(), (StreamToLoopInspection.StreamToLoopReplacementContext context) -> fn.suggestFinalOutputNames((StreamToLoopInspection.StreamToLoopReplacementContext)context, desiredName, "collection").get(0), fn);
            this.myList = InheritanceUtil.isInheritor((PsiType)resultType, (String)"java.util.List");
        }

        @Override
        public String getAccumulatorUpdater(StreamVariable inVar, String acc) {
            return acc + ".add(" + inVar + ");\n";
        }

        @Override
        public PsiType correctReturnType(PsiType type) {
            return ToCollectionTerminalOperation.correctTypeParameters(type, "java.util.Collection", Collections.emptyMap());
        }

        public boolean isList() {
            return this.myList;
        }

        @NotNull
        private static ToCollectionTerminalOperation toList(@NotNull PsiType resultType) {
            if (resultType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/codeInspection/streamToLoop/TerminalOperation$ToCollectionTerminalOperation", "toList"));
            }
            ToCollectionTerminalOperation toCollectionTerminalOperation = new ToCollectionTerminalOperation(resultType, FunctionHelper.newObjectSupplier(resultType, "java.util.ArrayList"), "list");
            if (toCollectionTerminalOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/TerminalOperation$ToCollectionTerminalOperation", "toList"));
            }
            return toCollectionTerminalOperation;
        }

        @NotNull
        private static ToCollectionTerminalOperation toSet(@NotNull PsiType resultType) {
            if (resultType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/codeInspection/streamToLoop/TerminalOperation$ToCollectionTerminalOperation", "toSet"));
            }
            ToCollectionTerminalOperation toCollectionTerminalOperation = new ToCollectionTerminalOperation(resultType, FunctionHelper.newObjectSupplier(resultType, "java.util.HashSet"), "set");
            if (toCollectionTerminalOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/TerminalOperation$ToCollectionTerminalOperation", "toSet"));
            }
            return toCollectionTerminalOperation;
        }
    }

    static class TemplateBasedOperation
    extends AccumulatedOperation
    implements CollectorOperation {
        private String myAccName;
        private String myAccType;
        private String myAccInitializer;
        private String myUpdateTemplate;
        private String myFinisherTemplate;

        TemplateBasedOperation(String accName, String accType, String accInitializer, String updateTemplate, String finisherTemplate) {
            this.myAccName = accName;
            this.myAccType = accType;
            this.myAccInitializer = accInitializer;
            this.myUpdateTemplate = updateTemplate;
            this.myFinisherTemplate = finisherTemplate;
        }

        TemplateBasedOperation(String accName, String accType, String accInitializer, String updateTemplate) {
            this(accName, accType, accInitializer, updateTemplate, "{acc}");
        }

        @Override
        String initAccumulator(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            StreamToLoopInspection.ResultKind kind = this.myFinisherTemplate.equals("{acc}") ? (TypeConversionUtil.isPrimitive((String)this.myAccType) ? StreamToLoopInspection.ResultKind.NON_FINAL : StreamToLoopInspection.ResultKind.FINAL) : StreamToLoopInspection.ResultKind.UNKNOWN;
            String varName = context.declareResult(this.myAccName, this.myAccType, this.myAccInitializer, kind);
            context.setFinisher(this.myFinisherTemplate.replace("{acc}", varName));
            return varName;
        }

        @Override
        CollectorOperation asCollector() {
            return this.myFinisherTemplate.equals("{acc}") ? this : null;
        }

        @Override
        public String getSupplier() {
            return this.myAccInitializer;
        }

        @Override
        public String getAccumulatorUpdater(StreamVariable inVar, String acc) {
            return this.myUpdateTemplate.replace("{acc}", acc).replace("{item}", inVar.getName());
        }

        @Override
        public String getMerger(StreamVariable inVar, String map, String key2) {
            String boxedType = PsiTypesUtil.boxIfPossible((String)this.myAccType);
            if (boxedType.equals(this.myAccType)) {
                return null;
            }
            String val = this.myUpdateTemplate.equals("{acc}++;") ? "1L" : "(" + this.myAccType + ")" + inVar;
            String merger = boxedType + "::sum";
            return map + ".merge(" + key2 + "," + val + "," + merger + ");\n";
        }

        @NotNull
        static TemplateBasedOperation summing(PsiType type) {
            String defValue = type.equals(PsiType.DOUBLE) ? "0.0" : (type.equals(PsiType.LONG) ? "0L" : "0");
            TemplateBasedOperation templateBasedOperation = new TemplateBasedOperation("sum", type.getCanonicalText(), defValue, "{acc}+={item};");
            if (templateBasedOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/TerminalOperation$TemplateBasedOperation", "summing"));
            }
            return templateBasedOperation;
        }

        @NotNull
        static TemplateBasedOperation summarizing(@NotNull PsiType resultType) {
            if (resultType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/codeInspection/streamToLoop/TerminalOperation$TemplateBasedOperation", "summarizing"));
            }
            TemplateBasedOperation templateBasedOperation = new TemplateBasedOperation("stat", resultType.getCanonicalText(), "new " + resultType.getCanonicalText() + "()", "{acc}.accept({item});");
            if (templateBasedOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/TerminalOperation$TemplateBasedOperation", "summarizing"));
            }
            return templateBasedOperation;
        }

        @NotNull
        static TemplateBasedOperation counting() {
            TemplateBasedOperation templateBasedOperation = new TemplateBasedOperation("count", "long", "0L", "{acc}++;");
            if (templateBasedOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/TerminalOperation$TemplateBasedOperation", "counting"));
            }
            return templateBasedOperation;
        }
    }

    static abstract class CollectorBasedTerminalOperation
    extends AccumulatedOperation
    implements CollectorOperation {
        final String myType;
        final Function<StreamToLoopInspection.StreamToLoopReplacementContext, String> myAccNameSupplier;
        final FunctionHelper mySupplier;

        CollectorBasedTerminalOperation(String type, Function<StreamToLoopInspection.StreamToLoopReplacementContext, String> accNameSupplier, FunctionHelper accSupplier) {
            this.myType = type;
            this.myAccNameSupplier = accNameSupplier;
            this.mySupplier = accSupplier;
        }

        @Override
        String initAccumulator(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.transform(context, inVar.getName());
            PsiType resultType = this.correctReturnType(context.createType(this.myType));
            return context.declareResult(this.myAccNameSupplier.apply(context), resultType.getCanonicalText(), this.getSupplier(), StreamToLoopInspection.ResultKind.FINAL);
        }

        @Override
        CollectorOperation asCollector() {
            return this;
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.mySupplier.registerReusedElements(consumer);
        }

        @Override
        public void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String item) {
            this.mySupplier.transform(context, new String[0]);
        }

        @Override
        public String getSupplier() {
            return this.mySupplier.getText();
        }
    }

    static interface CollectorOperation {
        default public void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String item) {
        }

        default public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
        }

        default public void registerReusedElements(Consumer<PsiElement> consumer) {
        }

        public String getSupplier();

        public String getAccumulatorUpdater(StreamVariable var1, String var2);

        default public String getMerger(StreamVariable inVar, String map, String key2) {
            return null;
        }

        default public PsiType correctReturnType(PsiType type) {
            return type;
        }
    }

    static class MatchTerminalOperation
    extends TerminalOperation {
        private final FunctionHelper myFn;
        private final boolean myDefaultValue;
        private final boolean myNegatePredicate;

        public MatchTerminalOperation(FunctionHelper fn, String name) {
            this.myFn = fn;
            switch (name) {
                case "anyMatch": {
                    this.myDefaultValue = false;
                    this.myNegatePredicate = false;
                    break;
                }
                case "allMatch": {
                    this.myDefaultValue = true;
                    this.myNegatePredicate = true;
                    break;
                }
                case "noneMatch": {
                    this.myDefaultValue = true;
                    this.myNegatePredicate = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(name);
                }
            }
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.myFn.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myFn.preprocessVariable(context, inVar, 0);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String expression;
            this.myFn.transform(context, inVar.getName());
            if (this.myNegatePredicate) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression("(" + inVar.getDeclaration() + ")->" + this.myFn.getText());
                expression = BoolUtils.getNegatedExpressionText((PsiExpression)lambda2.getBody());
            } else {
                expression = this.myFn.getText();
            }
            return "if(" + expression + ") {\n" + context.assignAndBreak(new ConditionalExpression.Boolean("b", this.myDefaultValue)) + "}\n";
        }
    }

    static class FindTerminalOperation
    extends TerminalOperation {
        private String myType;

        public FindTerminalOperation(String type) {
            this.myType = type;
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            return context.assignAndBreak(new ConditionalExpression.Optional(this.myType, "found", inVar.getName()));
        }
    }

    static class ToArrayTerminalOperation
    extends AccumulatedOperation {
        private final String myType;
        private final FunctionHelper mySupplier;

        public ToArrayTerminalOperation(PsiType type, FunctionHelper supplier) {
            this.myType = type.getCanonicalText();
            this.mySupplier = supplier;
        }

        @Override
        String initAccumulator(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String list = context.declareResult("list", "java.util.List<" + this.myType + ">", "new java.util.ArrayList<>()", StreamToLoopInspection.ResultKind.UNKNOWN);
            String toArrayArg = "";
            if (this.mySupplier != null) {
                this.mySupplier.transform(context, "0");
                toArrayArg = this.mySupplier.getText();
            }
            context.setFinisher(list + ".toArray(" + toArrayArg + ")");
            return list;
        }

        @Override
        String getAccumulatorUpdater(StreamVariable inVar, String list) {
            return list + ".add(" + inVar + ");\n";
        }
    }

    static class ToPrimitiveArrayTerminalOperation
    extends TerminalOperation {
        private String myType;

        ToPrimitiveArrayTerminalOperation(String type) {
            this.myType = type;
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String arr = context.declareResult("arr", this.myType + "[]", "new " + this.myType + "[10]", StreamToLoopInspection.ResultKind.NON_FINAL);
            String count = context.declare("count", "int", "0");
            context.addAfterStep(arr + "=java.util.Arrays.copyOfRange(" + arr + ",0," + count + ");\n");
            return "if(" + arr + ".length==" + count + ") " + arr + "=java.util.Arrays.copyOf(" + arr + "," + count + "*2);\n" + arr + "[" + count + "++]=" + inVar + ";\n";
        }
    }

    static class AverageTerminalOperation
    extends TerminalOperation {
        private final boolean myDoubleAccumulator;
        private final boolean myUseOptional;

        public AverageTerminalOperation(boolean doubleAccumulator, boolean useOptional) {
            this.myDoubleAccumulator = doubleAccumulator;
            this.myUseOptional = useOptional;
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String sum = context.declareResult("sum", this.myDoubleAccumulator ? "double" : "long", "0", StreamToLoopInspection.ResultKind.UNKNOWN);
            String count = context.declare("count", "long", "0");
            String seenCheck = count + ">0";
            String result2 = (this.myDoubleAccumulator ? "" : "(double)") + sum + "/" + count;
            ConditionalExpression conditionalExpression = this.myUseOptional ? new ConditionalExpression.Optional("double", seenCheck, result2) : new ConditionalExpression.Plain("double", seenCheck, result2, "0.0");
            context.setFinisher(conditionalExpression);
            return sum + "+=" + inVar + ";\n" + count + "++;\n";
        }
    }

    static class ExplicitCollectTerminalOperation
    extends TerminalOperation {
        private final FunctionHelper mySupplier;
        private final FunctionHelper myAccumulator;

        public ExplicitCollectTerminalOperation(FunctionHelper supplier, FunctionHelper accumulator) {
            this.mySupplier = supplier;
            this.myAccumulator = accumulator;
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.mySupplier.registerReusedElements(consumer);
            this.myAccumulator.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myAccumulator.preprocessVariable(context, inVar, 1);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.mySupplier.transform(context, new String[0]);
            String candidate = this.mySupplier.suggestFinalOutputNames(context, this.myAccumulator.getParameterName(0), "acc").get(0);
            String acc = context.declareResult(candidate, this.mySupplier.getResultType(), this.mySupplier.getText(), StreamToLoopInspection.ResultKind.FINAL);
            this.myAccumulator.transform(context, acc, inVar.getName());
            return this.myAccumulator.getStatementText();
        }
    }

    static class ReduceToOptionalTerminalOperation
    extends TerminalOperation {
        private String myType;
        private FunctionHelper myUpdater;

        public ReduceToOptionalTerminalOperation(FunctionHelper updater, String type) {
            this.myType = type;
            this.myUpdater = updater;
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.myUpdater.registerReusedElements(consumer);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String seen = context.declare("seen", "boolean", "false");
            String accumulator = context.declareResult("acc", this.myType, TypeConversionUtil.isPrimitive((String)this.myType) ? "0" : "null", StreamToLoopInspection.ResultKind.UNKNOWN);
            this.myUpdater.transform(context, accumulator, inVar.getName());
            context.setFinisher(new ConditionalExpression.Optional(this.myType, seen, accumulator));
            String ifClause = "if(!" + seen + ") {\n" + seen + "=true;\n" + accumulator + "=" + inVar + ";\n}";
            if (this.myUpdater.getText().equals(accumulator)) {
                return ifClause + "\n";
            }
            return ifClause + " else {\n" + accumulator + "=" + this.myUpdater.getText() + ";\n}\n";
        }

        @Nullable
        static ReduceToOptionalTerminalOperation create(PsiExpression arg, PsiType resultType) {
            PsiType optionalElementType = OptionalUtil.getOptionalElementType(resultType);
            FunctionHelper fn = FunctionHelper.create(arg, 2);
            if (fn != null && optionalElementType != null) {
                return new ReduceToOptionalTerminalOperation(fn, optionalElementType.getCanonicalText());
            }
            return null;
        }
    }

    static class ReduceTerminalOperation
    extends TerminalOperation {
        private PsiExpression myIdentity;
        private String myType;
        private FunctionHelper myUpdater;

        public ReduceTerminalOperation(PsiExpression identity, FunctionHelper updater, String type) {
            this.myIdentity = identity;
            this.myType = type;
            this.myUpdater = updater;
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myIdentity);
            this.myUpdater.registerReusedElements(consumer);
        }

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String accumulator = context.declareResult("acc", this.myType, this.myIdentity.getText(), StreamToLoopInspection.ResultKind.NON_FINAL);
            this.myUpdater.transform(context, accumulator, inVar.getName());
            return accumulator + "=" + this.myUpdater.getText() + ";";
        }
    }

    static abstract class AccumulatedOperation
    extends TerminalOperation {
        AccumulatedOperation() {
        }

        abstract String initAccumulator(StreamVariable var1, StreamToLoopInspection.StreamToLoopReplacementContext var2);

        abstract String getAccumulatorUpdater(StreamVariable var1, String var2);

        @Override
        String generate(StreamVariable inVar, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String acc = this.initAccumulator(inVar, context);
            return this.getAccumulatorUpdater(inVar, acc);
        }
    }
}

