/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaGenerationUtil {
    @Contract(value="null -> false")
    public static boolean canBeUncheckedLambda(@Nullable PsiElement lambdaCandidate) {
        return LambdaGenerationUtil.canBeUncheckedLambda(lambdaCandidate, var -> false);
    }

    @Contract(value="null, _ -> false")
    public static boolean canBeUncheckedLambda(@Nullable PsiElement lambdaCandidate, @NotNull Predicate<PsiVariable> variableAllowedPredicate) {
        if (variableAllowedPredicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableAllowedPredicate", "com/intellij/codeInspection/util/LambdaGenerationUtil", "canBeUncheckedLambda"));
        }
        if (!(lambdaCandidate instanceof PsiExpression) && !(lambdaCandidate instanceof PsiStatement)) {
            return false;
        }
        if (!ExceptionUtil.getThrownCheckedExceptions(lambdaCandidate).isEmpty()) {
            return false;
        }
        CanBeLambdaBodyVisitor visitor = new CanBeLambdaBodyVisitor(lambdaCandidate, variableAllowedPredicate);
        lambdaCandidate.accept((PsiElementVisitor)visitor);
        return visitor.canBeLambdaBody();
    }

    private static class CanBeLambdaBodyVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myCanBeLambdaBody = true;
        private final PsiElement myRoot;
        private final Predicate<PsiVariable> myVariableAllowedPredicate;

        CanBeLambdaBodyVisitor(PsiElement root, Predicate<PsiVariable> variableAllowedPredicate) {
            this.myRoot = root;
            this.myVariableAllowedPredicate = variableAllowedPredicate;
        }

        public void visitElement(PsiElement element) {
            if (!this.myCanBeLambdaBody) {
                return;
            }
            super.visitElement(element);
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (!this.myCanBeLambdaBody) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement element = expression.resolve();
            if (element instanceof PsiVariable && !this.isAllowedInLambda(expression, (PsiVariable)element)) {
                this.myCanBeLambdaBody = false;
            }
        }

        private boolean isAllowedInLambda(PsiReferenceExpression expression, PsiVariable variable) {
            return variable instanceof PsiField || this.myVariableAllowedPredicate.test(variable) || PsiTreeUtil.isAncestor((PsiElement)this.myRoot, (PsiElement)variable, (boolean)true) || !PsiUtil.isAccessedForWriting((PsiExpression)expression) && HighlightControlFlowUtil.isEffectivelyFinal(variable, this.myRoot, null);
        }

        public void visitBreakStatement(PsiBreakStatement statement2) {
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null || !PsiTreeUtil.isAncestor((PsiElement)this.myRoot, (PsiElement)exitedStatement, (boolean)false)) {
                this.myCanBeLambdaBody = false;
            }
            super.visitBreakStatement(statement2);
        }

        public void visitContinueStatement(PsiContinueStatement statement2) {
            PsiStatement continuedStatement = statement2.findContinuedStatement();
            if (continuedStatement == null || !PsiTreeUtil.isAncestor((PsiElement)this.myRoot, (PsiElement)continuedStatement, (boolean)false)) {
                this.myCanBeLambdaBody = false;
            }
            super.visitContinueStatement(statement2);
        }

        public void visitReturnStatement(PsiReturnStatement statement2) {
            this.myCanBeLambdaBody = false;
        }

        public boolean canBeLambdaBody() {
            return this.myCanBeLambdaBody;
        }
    }
}

