/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OptionalUtil {
    private static final String OPTIONAL_INT = "java.util.OptionalInt";
    private static final String OPTIONAL_LONG = "java.util.OptionalLong";
    private static final String OPTIONAL_DOUBLE = "java.util.OptionalDouble";

    @NotNull
    @Contract(pure=true)
    public static String getOptionalClass(String type) {
        switch (type) {
            case "int": {
                if (OPTIONAL_INT == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getOptionalClass"));
                }
                return OPTIONAL_INT;
            }
            case "long": {
                if (OPTIONAL_LONG == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getOptionalClass"));
                }
                return OPTIONAL_LONG;
            }
            case "double": {
                if (OPTIONAL_DOUBLE == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getOptionalClass"));
                }
                return OPTIONAL_DOUBLE;
            }
        }
        if ("java.util.Optional" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getOptionalClass"));
        }
        return "java.util.Optional";
    }

    public static boolean isOptionalClassName(String className) {
        return "java.util.Optional".equals(className) || OPTIONAL_INT.equals(className) || OPTIONAL_LONG.equals(className) || OPTIONAL_DOUBLE.equals(className);
    }

    @Contract(value="null -> null")
    public static PsiType getOptionalElementType(PsiType type) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (aClass == null) {
            return null;
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        switch (className) {
            case "java.util.OptionalInt": {
                return PsiType.INT;
            }
            case "java.util.OptionalLong": {
                return PsiType.LONG;
            }
            case "java.util.OptionalDouble": {
                return PsiType.DOUBLE;
            }
            case "java.util.Optional": {
                PsiType[] parameters = ((PsiClassType)type).getParameters();
                if (parameters.length != 1) {
                    return null;
                }
                PsiType streamType = parameters[0];
                if (streamType instanceof PsiCapturedWildcardType) {
                    streamType = ((PsiCapturedWildcardType)streamType).getUpperBound();
                }
                return streamType;
            }
        }
        return null;
    }

    public static String generateOptionalUnwrap(String qualifier, PsiVariable var, PsiExpression trueExpression, PsiExpression falseExpression, PsiType targetType, boolean useOrElseGet) {
        if (!ExpressionUtils.isReferenceTo(trueExpression, var)) {
            PsiConditionalExpression condition;
            PsiExpression elseExpression;
            PsiTypeCastExpression castExpression;
            PsiTypeElement castType;
            if (trueExpression instanceof PsiTypeCastExpression && ExpressionUtils.isNullLiteral(falseExpression) && (castType = (castExpression = (PsiTypeCastExpression)trueExpression).getCastType()) != null && ExpressionUtils.isReferenceTo(castExpression.getOperand(), var)) {
                return "(" + castType.getText() + ")" + qualifier + ".orElse(null)";
            }
            if (ExpressionUtils.isLiteral((PsiElement)falseExpression, Boolean.FALSE) && PsiType.BOOLEAN.equals((Object)trueExpression.getType())) {
                return qualifier + ".filter(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ").isPresent()";
            }
            if (trueExpression instanceof PsiConditionalExpression && (elseExpression = (condition = (PsiConditionalExpression)trueExpression).getElseExpression()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseExpression, (PsiElement)elseExpression)) {
                return OptionalUtil.generateOptionalUnwrap(qualifier + ".filter(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)condition.getCondition()) + ")", var, condition.getThenExpression(), falseExpression, targetType, useOrElseGet);
            }
            if (OptionalUtil.isOptionalEmptyCall(falseExpression)) {
                if (trueExpression instanceof PsiMethodCallExpression && MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)trueExpression, "java.util.Optional", "of", 1)) {
                    PsiExpression arg = ((PsiMethodCallExpression)trueExpression).getArgumentList().getExpressions()[0];
                    if (ExpressionUtils.isReferenceTo(arg, var)) {
                        return qualifier;
                    }
                    return qualifier + ".map(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)arg) + ")";
                }
                return qualifier + ".flatMap(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
            }
            trueExpression = targetType == null ? trueExpression : RefactoringUtil.convertInitializerToNormalExpression(trueExpression, targetType);
            String typeArg = OptionalUtil.getMapTypeArgument(trueExpression, targetType, falseExpression);
            qualifier = qualifier + "." + typeArg + "map(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
        }
        if (useOrElseGet && !ExpressionUtils.isSimpleExpression(falseExpression)) {
            return qualifier + ".orElseGet(() -> " + falseExpression.getText() + ")";
        }
        return qualifier + ".orElse(" + falseExpression.getText() + ")";
    }

    @Contract(value="null -> false")
    public static boolean isOptionalEmptyCall(PsiExpression expression) {
        return expression instanceof PsiMethodCallExpression && MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)expression, "java.util.Optional", "empty", 0);
    }

    @NotNull
    public static String getMapTypeArgument(PsiExpression expression, PsiType type) {
        String string = OptionalUtil.getMapTypeArgument(expression, type, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getMapTypeArgument"));
        }
        return string;
    }

    @NotNull
    private static String getMapTypeArgument(PsiExpression expression, PsiType type, PsiExpression falseExpression) {
        if (!(type instanceof PsiClassType)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getMapTypeArgument"));
            }
            return "";
        }
        PsiExpression copy = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText(), (PsiElement)expression);
        PsiType exprType = copy.getType();
        if (exprType != null && !exprType.equals(PsiType.NULL) && !LambdaUtil.notInferredType((PsiType)exprType) && TypeConversionUtil.isAssignable((PsiType)type, (PsiType)exprType)) {
            if (falseExpression == null) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getMapTypeArgument"));
                }
                return "";
            }
            PsiType falseType = falseExpression.getType();
            if (falseType != null && falseType.isAssignableFrom(exprType)) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getMapTypeArgument"));
                }
                return "";
            }
        }
        String string = "<" + type.getCanonicalText() + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getMapTypeArgument"));
        }
        return string;
    }
}

