/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.api.index;

import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexStorageReader;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.classFilesIndex.indexer.api.IndexState;
import org.jetbrains.jps.classFilesIndex.indexer.api.storage.ClassFilesIndexStorageBase;
import org.jetbrains.jps.incremental.storage.BuildDataManager;

public abstract class ClassFilesIndexReaderBase<K, V> {
    public static final String VERSION_FILE_NAME = "version";
    private static final Logger LOG = Logger.getInstance(ClassFilesIndexReaderBase.class);
    @Nullable
    protected final ClassFilesIndexStorageReader<K, V> myIndex;
    @Nullable
    protected final Mappings myMappings;

    public static boolean checkIndexAndRecreateIfNeed(Project project2, int currentVersion, String canonicalIndexName) {
        File projectBuildSystemDirectory = BuildManager.getInstance().getProjectSystemDirectory(project2);
        assert (projectBuildSystemDirectory != null);
        File versionFile = new File(ClassFilesIndexStorageBase.getIndexDir((String)canonicalIndexName, (File)projectBuildSystemDirectory), VERSION_FILE_NAME);
        File indexDir = ClassFilesIndexStorageBase.getIndexDir((String)canonicalIndexName, (File)projectBuildSystemDirectory);
        if (versionFile.exists() && !ClassFilesIndexReaderBase.versionDiffers(projectBuildSystemDirectory, canonicalIndexName, currentVersion) && IndexState.load((File)indexDir) == IndexState.EXIST) {
            return true;
        }
        ClassFilesIndexReaderBase.recreateIndex(canonicalIndexName, currentVersion, projectBuildSystemDirectory, indexDir);
        return false;
    }

    protected ClassFilesIndexReaderBase(KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer, String canonicalIndexName, int indexVersion, Project project2) {
        if (ClassFilesIndexReaderBase.checkIndexAndRecreateIfNeed(project2, indexVersion, canonicalIndexName)) {
            ClassFilesIndexStorageReader<K, V> index = null;
            IOException exception = null;
            File projectBuildSystemDirectory = BuildManager.getInstance().getProjectSystemDirectory(project2);
            File indexDir = ClassFilesIndexStorageBase.getIndexDir((String)canonicalIndexName, (File)projectBuildSystemDirectory);
            try {
                index = new ClassFilesIndexStorageReader<K, V>(indexDir, keyDescriptor, valueExternalizer);
            }
            catch (IOException e) {
                exception = e;
                PersistentHashMap.deleteFilesStartingWith((File)ClassFilesIndexStorageBase.getIndexFile((File)indexDir));
            }
            if (exception != null) {
                ClassFilesIndexReaderBase.recreateIndex(canonicalIndexName, indexVersion, projectBuildSystemDirectory, indexDir);
                this.myIndex = null;
                this.myMappings = null;
            } else {
                this.myIndex = index;
                try {
                    this.myMappings = new Mappings(BuildDataManager.getMappingsRoot((File)projectBuildSystemDirectory), false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.myIndex = null;
            this.myMappings = null;
        }
    }

    private static void recreateIndex(String canonicalIndexName, int indexVersion, File projectBuildSystemDirectory, File indexDir) {
        if (indexDir.exists()) {
            FileUtil.delete((File)indexDir);
        }
        try {
            FileUtil.writeToFile((File)new File(ClassFilesIndexStorageBase.getIndexDir((String)canonicalIndexName, (File)projectBuildSystemDirectory), VERSION_FILE_NAME), (String)String.valueOf(indexVersion));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IndexState.NOT_EXIST.save(indexDir);
    }

    public boolean isEmpty() {
        return this.myIndex == null;
    }

    public final void close() {
        if (this.myIndex != null) {
            try {
                this.myIndex.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.myMappings != null) {
            this.myMappings.close();
        }
    }

    public final void delete() {
        try {
            if (this.myIndex != null) {
                this.myIndex.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getVersionFile(File projectBuildSystemDirectory, String canonicalIndexName) {
        return new File(ClassFilesIndexStorageBase.getIndexDir((String)canonicalIndexName, (File)projectBuildSystemDirectory), VERSION_FILE_NAME);
    }

    private static boolean versionDiffers(File projectBuildSystemDirectory, String canonicalIndexName, int currentVersion) {
        File versionFile = ClassFilesIndexReaderBase.getVersionFile(projectBuildSystemDirectory, canonicalIndexName);
        if (!versionFile.exists()) {
            return true;
        }
        try {
            return Integer.parseInt(FileUtil.loadFile((File)versionFile)) != currentVersion;
        }
        catch (IOException e) {
            LOG.error("error while reading version file " + versionFile.getAbsolutePath());
            return true;
        }
    }
}

