/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.server.BuildManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.impl.BuildDataPathsImpl;
import org.jetbrains.jps.model.java.impl.JavaModuleIndexImpl;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/compiler/impl/JavaModuleIndexBuildTask;", "Lcom/intellij/openapi/compiler/CompileTask;", "()V", "execute", "", "context", "Lcom/intellij/openapi/compiler/CompileContext;", "error", "", "message", "", "compiler-impl"})
public final class JavaModuleIndexBuildTask
implements CompileTask {
    public boolean execute(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Project project2 = context.getProject();
        File systemDir = BuildManager.getInstance().getProjectSystemDirectory(project2);
        if (systemDir == null) {
            this.error(context, "Internal error: no system directory for project: " + project2);
            return false;
        }
        List badModules = CollectionsKt.mutableListOf((Object[])new String[0]);
        Map paths = MapsKt.mutableMapOf((Pair[])new Pair[0]);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, compilerManager, badModules, paths){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ CompilerManager $compilerManager$inlined;
            final /* synthetic */ List $badModules$inlined;
            final /* synthetic */ Map $paths$inlined;
            {
                this.$project$inlined = project2;
                this.$compilerManager$inlined = compilerManager;
                this.$badModules$inlined = list;
                this.$paths$inlined = map;
            }

            public final T compute() {
                Object[] $receiver$iv = ModuleManager.getInstance((Project)this.$project$inlined).getModules();
                for (int j = 0; j < $receiver$iv.length; ++j) {
                    Object object;
                    Object object2;
                    Object element$iv = $receiver$iv[j];
                    Module module2 = (Module)element$iv;
                    ModuleFileIndex index = ModuleRootManager.getInstance((Module)module2).getFileIndex();
                    List sourceFiles = CollectionsKt.mutableListOf((Object[])new String[0]);
                    List testFiles = CollectionsKt.mutableListOf((Object[])new String[0]);
                    Iterable $receiver$iv2 = FilenameIndex.getVirtualFilesByName(this.$project$inlined, "module-info.java", module2.getModuleScope());
                    for (T element$iv2 : $receiver$iv2) {
                        VirtualFile file2 = (VirtualFile)element$iv2;
                        if (this.$compilerManager$inlined.isExcludedFromCompilation(file2)) continue;
                        Collection collection = index.isInTestSourceContent(file2) ? testFiles : sourceFiles;
                        String string = file2.getPath();
                        collection.add(string);
                    }
                    if (sourceFiles.size() + testFiles.size() > 1) {
                        object2 = this.$badModules$inlined;
                        object = module2.getName();
                        object2.add(object);
                        continue;
                    }
                    object2 = this.$paths$inlined;
                    object = TuplesKt.to((Object)(module2.getName() + ":S"), (Object)CollectionsKt.firstOrNull((List)sourceFiles));
                    object2.put(object.getFirst(), object.getSecond());
                    object2 = this.$paths$inlined;
                    object = TuplesKt.to((Object)(module2.getName() + ":T"), (Object)CollectionsKt.firstOrNull((List)testFiles));
                    object2.put(object.getFirst(), object.getSecond());
                }
                return (T)Unit.INSTANCE;
            }
        });
        Collection $i$f$runReadAction = badModules;
        if (!$i$f$runReadAction.isEmpty()) {
            Iterable $receiver$iv = badModules;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                String string = IdeBundle.message((String)"compiler.multiple.module.descriptors", (Object[])new Object[]{it});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"compi\u2026.module.descriptors\", it)");
                this.error(context, string);
            }
            return false;
        }
        try {
            JavaModuleIndexImpl.store((File)new BuildDataPathsImpl(systemDir).getDataStorageRoot(), (Map)paths);
        }
        catch (Exception e) {
            Logger.getInstance(JavaModuleIndexBuildTask.class).error((Throwable)e);
            this.error(context, "Internal error: can't save module index: " + e.getMessage());
            return false;
        }
        return true;
    }

    private final void error(@NotNull CompileContext $receiver, String message) {
        $receiver.addMessage(CompilerMessageCategory.ERROR, message, null, 0, 0);
    }
}

