/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.TypeMarker;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0011H\u0002\u00a8\u0006\u0016"}, d2={"isAllWhitespace", "", "obj", "Lorg/jdom/Content;", "readAttributes", "", "element", "Lorg/jdom/Element;", "input", "Ljava/io/DataInputStream;", "readContent", "readElement", "Ljava/io/InputStream;", "serializeElementToBinary", "out", "Ljava/io/OutputStream;", "writeAttributes", "Ljava/io/DataOutputStream;", "attributes", "", "Lorg/jdom/Attribute;", "writeElement", "projectModel-impl"})
public final class BinaryXmlOutputterKt {
    public static final void serializeElementToBinary(@NotNull Element element, @NotNull OutputStream out) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        BinaryXmlOutputterKt.writeElement(element, new DataOutputStream(out));
    }

    @NotNull
    public static final Element readElement(@NotNull InputStream input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return BinaryXmlOutputterKt.readElement(new DataInputStream(input));
    }

    @NotNull
    public static final Element readElement(@NotNull DataInputStream input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Element element = new Element(IOUtil.readUTF((DataInput)input));
        BinaryXmlOutputterKt.readAttributes(element, input);
        BinaryXmlOutputterKt.readContent(element, input);
        return element;
    }

    private static final void readContent(Element element, DataInputStream input) {
        while (true) {
            int n;
            if ((n = input.read()) == TypeMarker.ELEMENT.ordinal()) {
                element.addContent(BinaryXmlOutputterKt.readElement(input));
                continue;
            }
            if (n == TypeMarker.TEXT.ordinal()) {
                element.addContent((Content)new Text(IOUtil.readUTF((DataInput)input)));
                continue;
            }
            if (n == TypeMarker.CDATA.ordinal()) {
                element.addContent((Content)new CDATA(IOUtil.readUTF((DataInput)input)));
                continue;
            }
            if (n == TypeMarker.ELEMENT_END.ordinal()) break;
        }
    }

    private static final void writeElement(Element element, DataOutputStream out) {
        IOUtil.writeUTF((DataOutput)out, (String)element.getName());
        BinaryXmlOutputterKt.writeAttributes(out, element.getAttributes());
        List content = element.getContent();
        for (Content item : content) {
            if (item instanceof Element) {
                out.writeByte(TypeMarker.ELEMENT.ordinal());
                BinaryXmlOutputterKt.writeElement((Element)item, out);
                continue;
            }
            if (item instanceof Text) {
                if (BinaryXmlOutputterKt.isAllWhitespace(item)) continue;
                out.writeByte(TypeMarker.TEXT.ordinal());
                IOUtil.writeUTF((DataOutput)out, (String)((Text)item).getText());
                continue;
            }
            if (!(item instanceof CDATA)) continue;
            out.writeByte(TypeMarker.CDATA.ordinal());
            IOUtil.writeUTF((DataOutput)out, (String)((CDATA)item).getText());
        }
        out.writeByte(TypeMarker.ELEMENT_END.ordinal());
    }

    private static final void writeAttributes(DataOutputStream out, List<? extends Attribute> attributes) {
        List<? extends Attribute> list = attributes;
        int size = list != null ? list.size() : 0;
        out.write(size);
        if (size == 0) {
            return;
        }
        if (size > 255) {
            throw (Throwable)new UnsupportedOperationException("attributes size > 255");
        }
        List<? extends Attribute> list2 = attributes;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        for (Attribute attribute : list2) {
            IOUtil.writeUTF((DataOutput)out, (String)attribute.getName());
            IOUtil.writeUTF((DataOutput)out, (String)attribute.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void readAttributes(Element element, DataInputStream input) {
        int n = 0;
        int size = input.readUnsignedByte();
        int n2 = size - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                element.setAttribute(new Attribute(IOUtil.readUTF((DataInput)input), IOUtil.readUTF((DataInput)input)));
                if (i2 == n2) break;
                ++i2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isAllWhitespace(Content obj) {
        Object object;
        Content content = obj;
        if (!(content instanceof Text)) {
            content = null;
        }
        if ((object = (Text)content) == null || (object = object.getText()) == null) {
            return false;
        }
        Object str = object;
        int n = 0;
        int n2 = ((String)str).length() - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                if (!Verifier.isXMLWhitespace((char)((String)str).charAt((int)i2))) {
                    return false;
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        return true;
    }
}

