/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.LineSeparator;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001/BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\n\u0010&\u001a\u0004\u0018\u00010'H\u0014J\n\u0010(\u001a\u0004\u0018\u00010'H\u0002J\u0012\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u001a\u0010\u0015\u001a\u00020*2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00112\b\u0010-\u001a\u0004\u0018\u00010\u0003J\b\u0010.\u001a\u00020\u0005H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00038\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00060"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "rootElementName", "pathMacroManager", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "blockSavingTheContent", "", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<set-?>", "getFile", "()Ljava/nio/file/Path;", "setFile", "(Ljava/nio/file/Path;)V", "isUseXmlProlog", "()Z", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "resolveVirtualFileOnlyOnWrite", "getResolveVirtualFileOnlyOnWrite", "setResolveVirtualFileOnlyOnWrite", "(Z)V", "virtualFile", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "states", "Lcom/intellij/configurationStore/StateMap;", "loadLocalData", "Lorg/jdom/Element;", "loadLocalDataUsingIo", "processReadException", "", "e", "Ljava/lang/Exception;", "ioFileIfChanged", "toString", "FileSaveSession", "configuration-store-impl"})
public class FileBasedStorage
extends XmlElementStorage {
    private volatile VirtualFile cachedVirtualFile;
    private LineSeparator lineSeparator;
    private boolean blockSavingTheContent;
    private boolean resolveVirtualFileOnlyOnWrite;
    @NotNull
    private volatile Path file;
    private final boolean isUseXmlProlog = false;

    public final boolean getResolveVirtualFileOnlyOnWrite() {
        return this.resolveVirtualFileOnlyOnWrite;
    }

    public final void setResolveVirtualFileOnlyOnWrite(boolean bl) {
        this.resolveVirtualFileOnlyOnWrite = bl;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    private final void setFile(Path path) {
        this.file = path;
    }

    protected boolean isUseXmlProlog() {
        return this.isUseXmlProlog;
    }

    public final void setFile(@Nullable VirtualFile virtualFile, @Nullable Path ioFileIfChanged) {
        this.cachedVirtualFile = virtualFile;
        if (ioFileIfChanged != null) {
            this.file = ioFileIfChanged;
        }
    }

    @Override
    @NotNull
    protected FileSaveSession createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkParameterIsNotNull((Object)states, (String)"states");
        return new FileSaveSession(states, this);
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        VirtualFile result2 = this.cachedVirtualFile;
        if (result2 == null) {
            this.cachedVirtualFile = result2 = LocalFileSystem.getInstance().findFileByPath(PathKt.getSystemIndependentPath((Path)this.file));
        }
        return this.cachedVirtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Element loadLocalData() {
        this.blockSavingTheContent = false;
        try {
            VirtualFile file2;
            if (Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$MODULE_FILE$") ^ true) {
                return this.loadLocalDataUsingIo();
            }
            VirtualFile virtualFile = file2 = this.resolveVirtualFileOnlyOnWrite ? this.cachedVirtualFile : this.getVirtualFile();
            if (file2 == null || file2.isDirectory() || !file2.isValid()) {
                void $receiver$iv;
                Exception e$iv;
                Logger logger = ComponentStoreImplKt.getLOG();
                Object var3_6 = null;
                boolean bl = true;
                Object var5_8 = null;
                if (bl & true) {
                    e$iv = null;
                }
                if ($receiver$iv.isDebugEnabled()) {
                    void var7_9 = $receiver$iv;
                    String string = "Document was not loaded for " + this.getFileSpec() + ", not a file";
                    var7_9.debug(string, (Throwable)e$iv);
                }
            } else if (file2.getLength() == 0L) {
                this.processReadException(null);
            } else {
                CharBuffer charBuffer;
                CharBuffer charBuffer2 = charBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(file2.contentsToByteArray()));
                Intrinsics.checkExpressionValueIsNotNull((Object)charBuffer2, (String)"charBuffer");
                this.lineSeparator = FileBasedStorageKt.detectLineSeparators(charBuffer2, this.isUseXmlProlog() ? null : LineSeparator.LF);
                CharBuffer charBuffer3 = charBuffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)charBuffer3, (String)"charBuffer");
                return JdomKt.loadElement((CharSequence)charBuffer3);
            }
            return null;
        }
        catch (JDOMException e) {
            this.processReadException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.processReadException(e);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Element loadLocalDataUsingIo() {
        BasicFileAttributes attributes;
        try {
            attributes = Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            void $receiver$iv2;
            Exception e$iv2;
            Logger logger = ComponentStoreImplKt.getLOG();
            Object var4_7 = null;
            boolean bl = true;
            Object var6_11 = null;
            if (bl & true) {
                e$iv2 = null;
            }
            if ($receiver$iv2.isDebugEnabled()) {
                void var8_12 = $receiver$iv2;
                String string = "Document was not loaded for " + this.getFileSpec() + ", doesn't exist";
                var8_12.debug(string, (Throwable)e$iv2);
            }
            return null;
        }
        if (!attributes.isRegularFile()) {
            void $receiver$iv;
            Exception e$iv;
            Logger e = ComponentStoreImplKt.getLOG();
            Object $receiver$iv2 = null;
            boolean e$iv2 = true;
            Object var5_10 = null;
            if (e$iv2 & true) {
                e$iv = null;
            }
            if ($receiver$iv.isDebugEnabled()) {
                void var8_13 = $receiver$iv;
                String string = "Document was not loaded for " + this.getFileSpec() + ", not a file";
                var8_13.debug(string, (Throwable)e$iv);
            }
        } else if (attributes.size() == 0L) {
            this.processReadException(null);
        } else {
            CharSequence data = PathKt.readChars((Path)this.file);
            this.lineSeparator = FileBasedStorageKt.detectLineSeparators(data, this.isUseXmlProlog() ? null : LineSeparator.LF);
            return JdomKt.loadElement((CharSequence)data);
        }
        return null;
    }

    private final void processReadException(Exception e) {
        boolean contentTruncated = e == null;
        boolean bl = this.blockSavingTheContent = !contentTruncated && (Intrinsics.areEqual((Object)ProjectStoreImplKt.PROJECT_FILE, (Object)this.getFileSpec()) || StringsKt.startsWith$default((String)this.getFileSpec(), (String)ProjectStoreImplKt.PROJECT_CONFIG_DIR, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$MODULE_FILE$") || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$WORKSPACE_FILE$"));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            String string;
            if (e != null) {
                ComponentStoreImplKt.getLOG().info((Throwable)e);
            }
            StringBuilder stringBuilder = new StringBuilder().append("Cannot load settings from file '").append(this.file).append("': ");
            if (contentTruncated) {
                string = "content truncated";
            } else {
                Exception exception = e;
                if (exception == null) {
                    Intrinsics.throwNpe();
                }
                string = exception.getMessage();
            }
            new Notification("System Messages", "Load Settings", stringBuilder.append(string).append("\n").append(this.blockSavingTheContent ? "Please correct the file content" : "File content will be recreated").toString(), NotificationType.WARNING).notify(null);
        }
    }

    @NotNull
    public String toString() {
        return PathKt.getSystemIndependentPath((Path)this.file);
    }

    public FileBasedStorage(@NotNull Path file2, @NotNull String fileSpec, @Nullable String rootElementName, @Nullable TrackingPathMacroSubstitutor pathMacroManager, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        super(fileSpec, rootElementName, pathMacroManager, roamingType, provider);
        this.file = file2;
        if (ApplicationManager.getApplication().isUnitTestMode() && StringsKt.startsWith$default((CharSequence)((Object)file2).toString(), (char)'$', (boolean)false, (int)2, null)) {
            throw (Throwable)((Object)new AssertionError((Object)("It seems like some macros were not expanded for path: " + file2)));
        }
    }

    public /* synthetic */ FileBasedStorage(Path path, String string, String string2, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 0x10) != 0) {
            roamingType = null;
        }
        if ((n & 0x20) != 0) {
            streamProvider = null;
        }
        this(path, string, string2, trackingPathMacroSubstitutor, roamingType, streamProvider);
    }

    public static final /* synthetic */ void access$setBlockSavingTheContent$p(FileBasedStorage $this, boolean bl) {
        $this.blockSavingTheContent = bl;
    }

    @NotNull
    public static final /* synthetic */ Path access$getFile$p(FileBasedStorage $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setFile$p(FileBasedStorage $this, @NotNull Path path) {
        $this.file = path;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getCachedVirtualFile$p(FileBasedStorage $this) {
        return $this.cachedVirtualFile;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "Lcom/intellij/configurationStore/FileBasedStorage;", "storageData", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/FileBasedStorage;)V", "save", "", "saveLocally", "element", "Lorg/jdom/Element;", "configuration-store-impl"})
    protected static class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession<FileBasedStorage> {
        @Override
        public void save() {
            if (!((FileBasedStorage)this.getStorage()).blockSavingTheContent) {
                super.save();
            }
        }

        @Override
        protected void saveLocally(@Nullable Element element) {
            if (((FileBasedStorage)this.getStorage()).lineSeparator == null) {
                ((FileBasedStorage)this.getStorage()).lineSeparator = ((FileBasedStorage)this.getStorage()).isUseXmlProlog() ? LineSeparator.LF : LineSeparator.getSystemLineSeparator();
            }
            VirtualFile virtualFile = ((FileBasedStorage)this.getStorage()).getVirtualFile();
            if (element == null) {
                FileBasedStorageKt.access$deleteFile(((FileBasedStorage)this.getStorage()).getFile(), this, virtualFile);
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = null;
            } else {
                LineSeparator lineSeparator;
                FileBasedStorage fileBasedStorage = (FileBasedStorage)this.getStorage();
                Path path = ((FileBasedStorage)this.getStorage()).getFile();
                if (((FileBasedStorage)this.getStorage()).isUseXmlProlog()) {
                    lineSeparator = ((FileBasedStorage)this.getStorage()).lineSeparator;
                    if (lineSeparator == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    lineSeparator = LineSeparator.LF;
                }
                fileBasedStorage.cachedVirtualFile = FileBasedStorageKt.writeFile(path, this, virtualFile, element, lineSeparator, ((FileBasedStorage)this.getStorage()).isUseXmlProlog());
            }
        }

        public FileSaveSession(@NotNull StateMap storageData, @NotNull FileBasedStorage storage2) {
            Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
            Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
            super(storageData, (XmlElementStorage)storage2);
        }
    }
}

