/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt$deleteFile$;
import com.intellij.configurationStore.FileBasedStorageKt$doWrite$;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CharIterator;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0000\u001a0\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a:\u0010\u0017\u001a\u00020\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u001a\u001a\u00020\u0016*\u00020\u001b2\b\b\u0002\u0010\u0011\u001a\u00020\u001cH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"XML_PROLOG", "", "deleteFile", "", "file", "Ljava/nio/file/Path;", "requestor", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "detectLineSeparators", "Lcom/intellij/util/LineSeparator;", "chars", "", "defaultSeparator", "doWrite", "content", "lineSeparator", "prependXmlProlog", "", "isEqualContent", "result", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "writeFile", "element", "Lorg/jdom/Element;", "toBufferExposingByteArray", "Lorg/jdom/Parent;", "", "configuration-store-impl"})
public final class FileBasedStorageKt {
    private static final byte[] XML_PROLOG;

    @NotNull
    public static final VirtualFile writeFile(@Nullable Path file2, @NotNull Object requestor, @Nullable VirtualFile virtualFile, @NotNull Element element, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if (!(file2 == null || virtualFile != null && virtualFile.isValid())) {
            virtualFile2 = StorageUtilKt.getOrCreateVirtualFile(requestor, file2);
        } else {
            virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
        }
        VirtualFile result2 = virtualFile2;
        if ((ComponentStoreImplKt.getLOG().isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) && !FileUtilRt.isTooLarge((long)result2.getLength())) {
            Parent parent = (Parent)element;
            String string = lineSeparator.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
            BufferExposingByteArrayOutputStream content = FileBasedStorageKt.toBufferExposingByteArray(parent, string);
            if (FileBasedStorageKt.isEqualContent(result2, lineSeparator, content, prependXmlProlog)) {
                throw (Throwable)new IllegalStateException("Content equals, but it must be handled not on this level: " + result2.getName());
            }
            if (StorageUtilKt.getDEBUG_LOG() != null && ApplicationManager.getApplication().isUnitTestMode()) {
                StorageUtilKt.setDEBUG_LOG(result2.getPath() + ":" + "\n" + content + "\n" + "Old Content:" + "\n" + LoadTextUtil.loadText(result2));
            }
        }
        FileBasedStorageKt.doWrite(requestor, result2, element, lineSeparator, prependXmlProlog);
        return result2;
    }

    private static final boolean isEqualContent(VirtualFile result2, LineSeparator lineSeparator, BufferExposingByteArrayOutputStream content, boolean prependXmlProlog) {
        boolean bl;
        block3: {
            int headerLength;
            int n = headerLength = !prependXmlProlog ? 0 : XML_PROLOG.length + lineSeparator.getSeparatorBytes().length;
            if ((int)result2.getLength() != headerLength + content.size()) {
                return false;
            }
            byte[] oldContent = result2.contentsToByteArray();
            if (!(!prependXmlProlog || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparator.getSeparatorBytes()))) {
                return false;
            }
            Iterable $receiver$iv = (Iterable)new IntRange(headerLength, oldContent.length - 1);
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv = ((IntIterator)iterator).nextInt();
                int it = element$iv;
                if (oldContent[it] == content.getInternalBuffer()[it - headerLength]) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final void doWrite(Object requestor, VirtualFile file2, Object content, LineSeparator lineSeparator, boolean prependXmlProlog) {
        void result$iv;
        Ref.ObjectRef byteArray;
        block7: {
            Element element;
            block9: {
                block8: {
                    void $receiver$iv;
                    Exception e$iv;
                    Logger logger = ComponentStoreImplKt.getLOG();
                    Object var6_6 = null;
                    boolean bl = true;
                    Object var8_8 = null;
                    if (bl & true) {
                        e$iv = null;
                    }
                    if ($receiver$iv.isDebugEnabled()) {
                        void var10_9 = $receiver$iv;
                        String string = "Save " + file2.getPresentableUrl();
                        var10_9.debug(string, (Throwable)e$iv);
                    }
                    if (file2.isWritable()) break block7;
                    Object object = content;
                    if (!(object instanceof Element)) {
                        object = null;
                    }
                    if ((element = (Element)object) == null) break block8;
                    Parent parent = (Parent)element;
                    String string = lineSeparator.getSeparatorString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
                    element = FileBasedStorageKt.toBufferExposingByteArray(parent, string);
                    if (element != null) break block9;
                }
                Object object = content;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                }
                element = (BufferExposingByteArrayOutputStream)object;
            }
            byteArray = element;
            throw (Throwable)new ReadOnlyModificationException(file2, new StateStorage.SaveSession(requestor, file2, (BufferExposingByteArrayOutputStream)byteArray, lineSeparator, prependXmlProlog){
                final /* synthetic */ Object $requestor;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ BufferExposingByteArrayOutputStream $byteArray;
                final /* synthetic */ LineSeparator $lineSeparator;
                final /* synthetic */ boolean $prependXmlProlog;

                public final void save() {
                    FileBasedStorageKt.access$doWrite(this.$requestor, this.$file, this.$byteArray, this.$lineSeparator, this.$prependXmlProlog);
                }
                {
                    this.$requestor = object;
                    this.$file = virtualFile;
                    this.$byteArray = bufferExposingByteArrayOutputStream;
                    this.$lineSeparator = lineSeparator;
                    this.$prependXmlProlog = bl;
                }
            });
        }
        byteArray = new Ref.ObjectRef();
        byteArray.element = null;
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable((Ref.ObjectRef)result$iv, file2, requestor, prependXmlProlog, lineSeparator, content){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ VirtualFile $file$inlined;
            final /* synthetic */ Object $requestor$inlined;
            final /* synthetic */ boolean $prependXmlProlog$inlined;
            final /* synthetic */ LineSeparator $lineSeparator$inlined;
            final /* synthetic */ Object $content$inlined;
            {
                this.$result = objectRef;
                this.$file$inlined = virtualFile;
                this.$requestor$inlined = object;
                this.$prependXmlProlog$inlined = bl;
                this.$lineSeparator$inlined = lineSeparator;
                this.$content$inlined = object2;
            }

            public final void run() {
                this.$result.element = ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                    final /* synthetic */ doWrite$$inlined$runUndoTransparentWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final T compute() {
                        Closeable closeable = this.this$0.$file$inlined.getOutputStream(this.this$0.$requestor$inlined);
                        boolean bl = false;
                        try {
                            OutputStream out = (OutputStream)closeable;
                            if (this.this$0.$prependXmlProlog$inlined) {
                                out.write(FileBasedStorageKt.access$getXML_PROLOG$p());
                                out.write(this.this$0.$lineSeparator$inlined.getSeparatorBytes());
                            }
                            if (this.this$0.$content$inlined instanceof Element) {
                                JDOMUtil.write((Parent)((Parent)this.this$0.$content$inlined), (OutputStream)out, (String)this.this$0.$lineSeparator$inlined.getSeparatorString());
                            } else {
                                Object object = this.this$0.$content$inlined;
                                if (object == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                                }
                                ((BufferExposingByteArrayOutputStream)object).writeTo(out);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Exception exception) {
                            bl = true;
                            try {
                                Closeable closeable2 = closeable;
                                if (closeable2 != null) {
                                    closeable2.close();
                                }
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            throw (Throwable)exception;
                        }
                        finally {
                            if (!bl) {
                                Closeable closeable3 = closeable;
                                if (closeable3 != null) {
                                    closeable3.close();
                                }
                            }
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
        });
        Object cfr_ignored_0 = result$iv.element;
    }

    @NotNull
    public static final BufferExposingByteArrayOutputStream toBufferExposingByteArray(@NotNull Parent $receiver, @NotNull String lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.write((Parent)$receiver, (OutputStream)((OutputStream)out), (String)lineSeparator);
        return out;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferExposingByteArrayOutputStream toBufferExposingByteArray$default(Parent parent, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "\n";
        }
        return FileBasedStorageKt.toBufferExposingByteArray(parent, string);
    }

    @NotNull
    public static final LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        CharIterator charIterator = StringsKt.iterator((CharSequence)chars);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if (c == '\r') {
                return LineSeparator.CRLF;
            }
            if (c != '\n') continue;
            return LineSeparator.LF;
        }
        LineSeparator lineSeparator = defaultSeparator;
        if (lineSeparator == null) {
            LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
            lineSeparator = lineSeparator2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
        }
        return lineSeparator;
    }

    private static final void deleteFile(Path file2, Object requestor, VirtualFile virtualFile) {
        if (virtualFile == null) {
            ComponentStoreImplKt.getLOG().warn("Cannot find virtual file " + file2);
        }
        if (virtualFile == null) {
            if (PathKt.exists((Path)file2)) {
                PathKt.delete((Path)file2);
            }
        } else if (virtualFile.exists()) {
            if (virtualFile.isWritable()) {
                FileBasedStorageKt.deleteFile(requestor, virtualFile);
            } else {
                throw (Throwable)new ReadOnlyModificationException(virtualFile, new StateStorage.SaveSession(requestor, virtualFile){
                    final /* synthetic */ Object $requestor;
                    final /* synthetic */ VirtualFile $virtualFile;

                    public final void save() {
                        FileBasedStorageKt.deleteFile(this.$requestor, this.$virtualFile);
                    }
                    {
                        this.$requestor = object;
                        this.$virtualFile = virtualFile;
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void deleteFile(@NotNull Object requestor, @NotNull VirtualFile virtualFile) {
        void result$iv;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable((Ref.ObjectRef)result$iv, virtualFile, requestor){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            final /* synthetic */ Object $requestor$inlined;
            {
                this.$result = objectRef;
                this.$virtualFile$inlined = virtualFile;
                this.$requestor$inlined = object;
            }

            public final void run() {
                this.$result.element = ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                    final /* synthetic */ deleteFile$$inlined$runUndoTransparentWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        this.this$0.$virtualFile$inlined.delete(this.this$0.$requestor$inlined);
                        return (T)Unit.INSTANCE;
                    }
                });
            }
        });
        Object cfr_ignored_0 = result$iv.element;
    }

    static {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Charset charset = null;
        boolean bl = true;
        Object var3_3 = null;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        XML_PROLOG = byArray;
    }

    public static final /* synthetic */ void access$deleteFile(@NotNull Path file2, @NotNull Object requestor, @Nullable VirtualFile virtualFile) {
        FileBasedStorageKt.deleteFile(file2, requestor, virtualFile);
    }

    public static final /* synthetic */ void access$doWrite(@NotNull Object requestor, @NotNull VirtualFile file2, @NotNull Object content, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        FileBasedStorageKt.doWrite(requestor, file2, content, lineSeparator, prependXmlProlog);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$getXML_PROLOG$p() {
        return XML_PROLOG;
    }
}

