/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u0007J\u000f\u0010\"\u001a\t\u0018\u00010#\u00a2\u0006\u0002\b$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0007H\u0016J\r\u0010(\u001a\u00070&\u00a2\u0006\u0002\b)H\u0016J\u0006\u0010*\u001a\u00020&J\b\u0010+\u001a\u00020&H\u0016J\u0006\u0010,\u001a\u00020\u0012J9\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020/0.\"\u0004\b\u0000\u001002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H0022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0014\u00a2\u0006\u0002\u00107J\u0006\u00108\u001a\u00020&J\u0006\u00109\u001a\u00020\u0007J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020#H\u0016J\u000e\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u0007J \u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020&2\u0006\u0010C\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0007H\u0004R\u0014\u0010\u0006\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006E"}, d2={"Lcom/intellij/configurationStore/ProjectStoreBase;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "(Lcom/intellij/openapi/project/impl/ProjectImpl;)V", "isDirectoryBased", "", "()Z", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "setLoadPolicy", "(Lcom/intellij/configurationStore/StateLoadPolicy;)V", "getProject$configuration_store_impl", "()Lcom/intellij/openapi/project/impl/ProjectImpl;", "scheme", "Lcom/intellij/openapi/components/StorageScheme;", "getScheme", "()Lcom/intellij/openapi/components/StorageScheme;", "setScheme", "(Lcom/intellij/openapi/components/StorageScheme;)V", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "clearStorages", "", "convertProfiles", "profileIterator", "", "Lorg/jdom/Element;", "isInspection", "getDirectoryStoreFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "getDirectoryStorePath", "", "ignoreProjectStorageScheme", "getDirectoryStorePathOrBase", "Lorg/jetbrains/annotations/NotNull;", "getProjectBasePath", "getProjectFilePath", "getStorageScheme", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "(Lcom/intellij/openapi/components/PersistentStateComponent;Lcom/intellij/openapi/components/State;Lcom/intellij/openapi/components/StateStorageOperation;)[Lcom/intellij/openapi/components/Storage;", "getWorkspaceFilePath", "isOptimiseTestLoadSpeed", "isProjectFile", "file", "loadProjectFromTemplate", "defaultProject", "Lcom/intellij/openapi/project/Project;", "setOptimiseTestLoadSpeed", "value", "setPath", "filePath", "refreshVfs", "useOldWorkspaceContentIfExists", "configuration-store-impl"})
public abstract class ProjectStoreBase
extends ComponentStoreImpl
implements IProjectStore {
    @NotNull
    private StorageScheme scheme;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final ProjectImpl project;

    @NotNull
    public final StorageScheme getScheme() {
        return this.scheme;
    }

    public final void setScheme(@NotNull StorageScheme storageScheme) {
        Intrinsics.checkParameterIsNotNull((Object)storageScheme, (String)"<set-?>");
        this.scheme = storageScheme;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    @Override
    public final boolean isOptimiseTestLoadSpeed() {
        return Intrinsics.areEqual((Object)((Object)this.loadPolicy), (Object)((Object)StateLoadPolicy.LOAD)) ^ true;
    }

    @Override
    @NotNull
    public final StorageScheme getStorageScheme() {
        return this.scheme;
    }

    @Override
    @NotNull
    public abstract StateStorageManagerImpl getStorageManager();

    protected final boolean isDirectoryBased() {
        return Intrinsics.areEqual((Object)this.scheme, (Object)StorageScheme.DIRECTORY_BASED);
    }

    @Override
    public final void setOptimiseTestLoadSpeed(boolean value) {
        this.loadPolicy = value ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return this.getStorageManager().expandMacro(ProjectStoreImplKt.PROJECT_FILE);
    }

    @Override
    @NotNull
    public final String getWorkspaceFilePath() {
        return this.getStorageManager().expandMacro("$WORKSPACE_FILE$");
    }

    @Override
    public final void clearStorages() {
        this.getStorageManager().clearStorages();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void loadProjectFromTemplate(@NotNull Project defaultProject) {
        Intrinsics.checkParameterIsNotNull((Object)defaultProject, (String)"defaultProject");
        defaultProject.save();
        v0 = ServiceKt.getStateStore((ComponentManager)defaultProject);
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        }
        v1 = ((DefaultProjectStoreImpl)v0).getStateCopy();
        if (v1 == null) {
            return;
        }
        element = v1;
        $receiver$iv = ComponentStoreImplKt.getLOG();
        try {
            ProjectStoreImplKt.removeWorkspaceComponentConfiguration(defaultProject, element);
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            $receiver$iv.error(e$iv);
        }
        if (this.isDirectoryBased()) {
            $receiver$iv = ComponentStoreImplKt.getLOG();
            try {
                for (Element component : element.getChildren("component")) {
                    v2 = var6_8 = component.getAttributeValue("name");
                    if (v2 == null) continue;
                    switch (v2.hashCode()) {
                        case 932379142: {
                            if (!var6_8.equals("CopyrightManager")) ** break;
                            break;
                        }
                        case -334315511: {
                            if (!var6_8.equals("InspectionProjectProfileManager")) ** break;
                            this.convertProfiles(component.getChildren("profile").iterator(), true);
                            ** break;
                        }
                    }
                    this.convertProfiles(component.getChildren("copyright").iterator(), false);
lbl38:
                    // 5 sources

                }
            }
            catch (ProcessCanceledException e$iv) {
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
        v3 = StateStorageManagerImpl.getOrCreateStorage$default(this.getStorageManager(), ProjectStoreImplKt.PROJECT_FILE, null, null, null, false, null, 62, null);
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.XmlElementStorage");
        }
        ((XmlElementStorage)v3).setDefaultState(element);
    }

    public final void convertProfiles(@NotNull Iterator<? extends Element> profileIterator, boolean isInspection) {
        Iterator<? extends Element> iterator;
        Intrinsics.checkParameterIsNotNull(profileIterator, (String)"profileIterator");
        Iterator<? extends Element> iterator2 = iterator = profileIterator;
        while (iterator2.hasNext()) {
            Object object;
            Object v0;
            Element profile2;
            block3: {
                Iterable iterable;
                profile2 = iterator2.next();
                Iterable iterable2 = iterable = (Iterable)profile2.getChildren("option");
                for (Object t : iterable2) {
                    Element it = (Element)t;
                    if (!Intrinsics.areEqual((Object)it.getAttributeValue("name"), (Object)"myName")) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((object = (Element)v0) == null || (object = object.getAttributeValue("value")) == null) {
                continue;
            }
            Object schemeName = object;
            profileIterator.remove();
            Element wrapper = JdomKt.attribute((Element)new Element("component"), (String)"name", (String)(isInspection ? "InspectionProjectProfileManager" : "CopyrightManager"));
            wrapper.addContent(profile2);
            Path path = Paths.get(this.getStorageManager().expandMacro(ProjectStoreImplKt.PROJECT_CONFIG_DIR), isInspection ? "inspectionProfiles" : "copyright", FileUtil.sanitizeFileName((String)schemeName, (boolean)true) + ".xml");
            JDOMUtil.write((Parent)((Parent)wrapper), (OutputStream)PathKt.outputStream((Path)path), (String)"\n");
        }
    }

    @Override
    @NotNull
    public final String getProjectBasePath() {
        if (this.isDirectoryBased()) {
            String path = PathUtilRt.getParentPath((String)this.getStorageManager().expandMacro(ProjectStoreImplKt.PROJECT_CONFIG_DIR));
            if (Registry.is((String)"store.basedir.parent.detection", (boolean)true) && StringsKt.startsWith$default((String)PathUtilRt.getFileName((String)path), (String)(".idea" + "."), (boolean)false, (int)2, null)) {
                String string = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)path));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getParentPath\u2026ilRt.getParentPath(path))");
                return string;
            }
            String string = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            return string;
        }
        String string = PathUtilRt.getParentPath((String)this.getProjectFilePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getParentPath(projectFilePath)");
        return string;
    }

    protected final void setPath(@NotNull String filePath, boolean refreshVfs, boolean useOldWorkspaceContentIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        StateStorageManagerImpl storageManager2 = this.getStorageManager();
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (FileUtilRt.extensionEquals((String)filePath, (String)"ipr")) {
            this.scheme = StorageScheme.DEFAULT;
            storageManager2.addMacro(ProjectStoreImplKt.PROJECT_FILE, filePath);
            String workspacePath = ProjectStoreImplKt.access$composeWsPath(filePath);
            storageManager2.addMacro("$WORKSPACE_FILE$", workspacePath);
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed$default(null, (Function0)((Function0)new Function0<Unit>(fs, filePath, workspacePath){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $filePath;
                    final /* synthetic */ String $workspacePath;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$filePath), this.$fs.refreshAndFindFileByPath(this.$workspacePath)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$filePath = string;
                        this.$workspacePath = string2;
                        super(0);
                    }
                }), (int)1, null);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!new File(filePath).exists());
            }
        } else {
            File workspace;
            String string;
            this.scheme = StorageScheme.DIRECTORY_BASED;
            boolean isDir = !useOldWorkspaceContentIfExists || PathKt.isDirectory((Path)Paths.get(filePath, new String[0]));
            StringBuilder stringBuilder = new StringBuilder();
            if (isDir) {
                string = filePath;
            } else {
                String string2 = PathUtilRt.getParentPath((String)filePath);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getParentPath(filePath)");
            }
            String configDir = stringBuilder.append(string).append("/").append(".idea").toString();
            storageManager2.addMacro(ProjectStoreImplKt.PROJECT_CONFIG_DIR, configDir);
            storageManager2.addMacro(ProjectStoreImplKt.PROJECT_FILE, configDir + "/misc.xml");
            storageManager2.addMacro("$WORKSPACE_FILE$", configDir + "/workspace.xml");
            if (!isDir && !(workspace = new File(this.getWorkspaceFilePath())).exists()) {
                ProjectStoreImplKt.access$useOldWorkspaceContent(filePath, workspace);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!PathKt.exists((Path)Paths.get(filePath, new String[0])));
            }
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed$default(null, (Function0)((Function0)new Function0<Unit>(fs, configDir){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $configDir;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$configDir)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$configDir = string;
                        super(0);
                    }
                }), (int)1, null);
            }
        }
    }

    @Override
    @NotNull
    protected <T> Storage[] getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Collection $receiver$iv;
        List result2;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Storage[] storages = stateSpec.storages();
        Object[] objectArray = storages;
        if (objectArray.length == 0) {
            FileStorageAnnotation[] elements$iv = new FileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
            return elements$iv;
        }
        if (this.isDirectoryBased()) {
            Collection $receiver$iv2;
            result2 = null;
            for (int j = 0; j < storages.length; ++j) {
                Storage storage2 = storages[j];
                if (!(Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath(storage2), (Object)ProjectStoreImplKt.PROJECT_FILE) ^ true)) continue;
                if (result2 == null) {
                    result2 = (List)new SmartList();
                }
                result2.add(storage2);
            }
            if (UtilKt.isNullOrEmpty(result2)) {
                FileStorageAnnotation[] elements$iv = new FileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
                return elements$iv;
            }
            List list = result2;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            CollectionsKt.sortWith((List)list, ComponentStoreImplKt.getDeprecatedComparator());
            result2.add(ProjectStoreImplKt.getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION());
            Collection collection = $receiver$iv2 = (Collection)result2;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            Storage[] storageArray = thisCollection$iv.toArray(new Storage[thisCollection$iv.size()]);
            if (storageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return storageArray;
        }
        result2 = null;
        boolean hasOnlyDeprecatedStorages = true;
        for (int $i$f$toTypedArray = 0; $i$f$toTypedArray < storages.length; ++$i$f$toTypedArray) {
            Storage storage3 = storages[$i$f$toTypedArray];
            if (!Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath(storage3), (Object)ProjectStoreImplKt.PROJECT_FILE) && !Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath(storage3), (Object)"$WORKSPACE_FILE$")) continue;
            if (result2 == null) {
                result2 = (List)new SmartList();
            }
            result2.add(storage3);
            if (storage3.deprecated()) continue;
            hasOnlyDeprecatedStorages = false;
        }
        if (UtilKt.isNullOrEmpty(result2)) {
            FileStorageAnnotation[] elements$iv = new FileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
            return elements$iv;
        }
        if (hasOnlyDeprecatedStorages) {
            List list = result2;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        List list = result2;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        CollectionsKt.sortWith((List)list, ComponentStoreImplKt.getDeprecatedComparator());
        Collection collection = $receiver$iv = (Collection)result2;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Storage[] storageArray = thisCollection$iv.toArray(new Storage[thisCollection$iv.size()]);
        if (storageArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return storageArray;
    }

    @Override
    public boolean isProjectFile(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!file2.isInLocalFileSystem() || !ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2, (FileType)file2.getFileType())) {
            return false;
        }
        String filePath = file2.getPath();
        if (!this.isDirectoryBased()) {
            return Intrinsics.areEqual((Object)filePath, (Object)this.getProjectFilePath()) || Intrinsics.areEqual((Object)filePath, (Object)this.getWorkspaceFilePath());
        }
        return FileUtil.isAncestor((String)PathUtilRt.getParentPath((String)this.getProjectFilePath()), (String)filePath, (boolean)false);
    }

    @Override
    @Nullable
    public String getDirectoryStorePath(boolean ignoreProjectStorageScheme) {
        return !ignoreProjectStorageScheme && !this.isDirectoryBased() ? null : StringKt.nullize$default((String)PathUtilRt.getParentPath((String)this.getProjectFilePath()), (boolean)false, (int)1, null);
    }

    @Override
    @Nullable
    public VirtualFile getDirectoryStoreFile() {
        VirtualFile virtualFile;
        String string = this.getDirectoryStorePath();
        if (string != null) {
            String string2;
            String it = string2 = string;
            virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getDirectoryStorePathOrBase() {
        return PathUtilRt.getParentPath((String)this.getProjectFilePath());
    }

    @Override
    @NotNull
    public final ProjectImpl getProject$configuration_store_impl() {
        return this.project;
    }

    public ProjectStoreBase(@NotNull ProjectImpl project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.scheme = StorageScheme.DEFAULT;
        this.loadPolicy = StateLoadPolicy.LOAD;
    }
}

