/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u001a#\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a5\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u00160\u00152\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u0016\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"\u001a\u0018\u0010#\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0003\"\u0015\u0010\t\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"DEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION", "Lcom/intellij/configurationStore/FileStorageAnnotation;", "getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION", "()Lcom/intellij/configurationStore/FileStorageAnnotation;", "PROJECT_CONFIG_DIR", "", "PROJECT_FILE", "PROJECT_FILE_STORAGE_ANNOTATION", "getPROJECT_FILE_STORAGE_ANNOTATION", "nameFile", "Ljava/nio/file/Path;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getNameFile", "(Lcom/intellij/openapi/components/impl/stores/IProjectStore;)Ljava/nio/file/Path;", "composeWsPath", "filePath", "dropUnableToSaveProjectNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "readOnlyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFilesList", "kotlin.jvm.PlatformType", "readonlyFiles", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "(Ljava/util/List;)[Lcom/intellij/openapi/vfs/VirtualFile;", "removeWorkspaceComponentConfiguration", "defaultProject", "element", "Lorg/jdom/Element;", "useOldWorkspaceContent", "ws", "Ljava/io/File;", "configuration-store-impl"})
public final class ProjectStoreImplKt {
    @NotNull
    public static final String PROJECT_FILE = "$PROJECT_FILE$";
    @NotNull
    public static final String PROJECT_CONFIG_DIR = "$PROJECT_CONFIG_DIR$";
    @NotNull
    private static final FileStorageAnnotation PROJECT_FILE_STORAGE_ANNOTATION = new FileStorageAnnotation(PROJECT_FILE, false);
    @NotNull
    private static final FileStorageAnnotation DEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION = new FileStorageAnnotation(PROJECT_FILE, true);

    @NotNull
    public static final Path getNameFile(@NotNull IProjectStore $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = Paths.get($receiver.getDirectoryStorePath(), ".name");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(directoryStore\u2026h, ProjectImpl.NAME_FILE)");
        return path;
    }

    @NotNull
    public static final FileStorageAnnotation getPROJECT_FILE_STORAGE_ANNOTATION() {
        return PROJECT_FILE_STORAGE_ANNOTATION;
    }

    @NotNull
    public static final FileStorageAnnotation getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION() {
        return DEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION;
    }

    private static final void dropUnableToSaveProjectNotification(Project project2, VirtualFile[] readOnlyFiles) {
        ProjectManagerImpl.UnableToSaveProjectNotification[] notifications = (ProjectManagerImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectManagerImpl.UnableToSaveProjectNotification.class, project2);
        Object[] objectArray = (Object[])notifications;
        if (objectArray.length == 0) {
            Notifications.Bus.notify((Notification)new ProjectManagerImpl.UnableToSaveProjectNotification(project2, readOnlyFiles), (Project)project2);
        } else {
            notifications[0].myFiles = readOnlyFiles;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile[] getFilesList(List<? extends Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        void var2_2;
        int size$iv = readonlyFiles.size();
        VirtualFile[] result$iv = new VirtualFile[size$iv];
        int n = 0;
        int n2 = size$iv - 1;
        if (n <= n2) {
            void i$iv;
            do {
                void it;
                VirtualFile virtualFile;
                void var5_5 = ++i$iv;
                void var9_7 = i$iv;
                VirtualFile[] virtualFileArray = result$iv;
                virtualFileArray[var9_7] = virtualFile = (VirtualFile)readonlyFiles.get((int)it).second;
            } while (i$iv != n2);
        }
        return var2_2;
    }

    private static final String composeWsPath(String filePath) {
        return FileUtilRt.getNameWithoutExtension((String)filePath) + ".iws";
    }

    private static final void useOldWorkspaceContent(String filePath, File ws) {
        File oldWs = new File(ProjectStoreImplKt.composeWsPath(filePath));
        if (!oldWs.exists()) {
            return;
        }
        try {
            FileUtil.copyContent((File)oldWs, (File)ws);
        }
        catch (IOException e) {
            ComponentStoreImplKt.getLOG().error((Throwable)e);
        }
    }

    public static final void removeWorkspaceComponentConfiguration(@NotNull Project defaultProject, @NotNull Element element) {
        Iterator iterator;
        Iterator element$iv;
        Intrinsics.checkParameterIsNotNull((Object)defaultProject, (String)"defaultProject");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        List componentElements = element.getChildren("component");
        if (componentElements.isEmpty()) {
            return;
        }
        THashSet workspaceComponentNames = new THashSet((Collection)CollectionsKt.listOf((Object)"GradleLocalSettings"));
        PersistentStateComponent[] projectComponents = (PersistentStateComponent[])defaultProject.getComponents(PersistentStateComponent.class);
        Object[] $receiver$iv = projectComponents;
        List errors$iv = null;
        for (int j = 0; j < $receiver$iv.length; ++j) {
            element$iv = $receiver$iv[j];
            try {
                Storage storage2;
                CharSequence charSequence;
                PersistentStateComponent it = (PersistentStateComponent)element$iv;
                State stateAnnotation = StoreUtil.getStateSpec(it.getClass());
                if (stateAnnotation == null || (charSequence = (CharSequence)stateAnnotation.name()) == null || charSequence.length() == 0) continue;
                if ((Storage)ArraysKt.firstOrNull((Object[])ComponentStoreImplKt.sortByDeprecated(stateAnnotation.storages())) == null) {
                    continue;
                }
                if (Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath(storage2), (Object)"$WORKSPACE_FILE$") ^ true) continue;
                workspaceComponentNames.add((Object)stateAnnotation.name());
                continue;
            }
            catch (Throwable e$iv) {
                if (errors$iv == null) {
                    errors$iv = (List)new SmartList();
                }
                errors$iv.add(e$iv);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)errors$iv);
        Iterator iterator2 = element$iv = (iterator = componentElements.iterator());
        while (iterator2.hasNext()) {
            Element componentElement = (Element)iterator2.next();
            String name = componentElement.getAttributeValue("name");
            if (name == null || !workspaceComponentNames.contains((Object)name)) continue;
            iterator.remove();
        }
    }

    @NotNull
    public static final /* synthetic */ VirtualFile[] access$getFilesList(@NotNull List readonlyFiles) {
        return ProjectStoreImplKt.getFilesList(readonlyFiles);
    }

    public static final /* synthetic */ void access$dropUnableToSaveProjectNotification(@NotNull Project project2, @NotNull VirtualFile[] readOnlyFiles) {
        ProjectStoreImplKt.dropUnableToSaveProjectNotification(project2, readOnlyFiles);
    }

    @NotNull
    public static final /* synthetic */ String access$composeWsPath(@NotNull String filePath) {
        return ProjectStoreImplKt.composeWsPath(filePath);
    }

    public static final /* synthetic */ void access$useOldWorkspaceContent(@NotNull String filePath, @NotNull File ws) {
        ProjectStoreImplKt.useOldWorkspaceContent(filePath, ws);
    }
}

