/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.GErrorStruct;
import com.intellij.credentialStore.LinuxSecretLibraryKt;
import com.intellij.credentialStore.SecretCredentialStore;
import com.intellij.credentialStore.SecretLibrary;
import com.intellij.util.io.jna.DisposableMemory;
import com.sun.jna.Pointer;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u001b\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0096\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/credentialStore/SecretCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "schemeName", "", "(Ljava/lang/String;)V", "accountAttributeNamePointer", "Lcom/intellij/util/io/jna/DisposableMemory;", "getAccountAttributeNamePointer", "()Lcom/intellij/util/io/jna/DisposableMemory;", "accountAttributeNamePointer$delegate", "Lkotlin/Lazy;", "scheme", "Lcom/sun/jna/Pointer;", "getScheme", "()Lcom/sun/jna/Pointer;", "scheme$delegate", "serviceAttributeNamePointer", "getServiceAttributeNamePointer", "serviceAttributeNamePointer$delegate", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "", "credentials", "credential-store"})
public final class SecretCredentialStore
implements CredentialStore {
    private final Lazy serviceAttributeNamePointer$delegate;
    private final Lazy accountAttributeNamePointer$delegate;
    private final Lazy scheme$delegate;
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final DisposableMemory getServiceAttributeNamePointer() {
        Lazy lazy = this.serviceAttributeNamePointer$delegate;
        SecretCredentialStore secretCredentialStore = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (DisposableMemory)((Object)lazy.getValue());
    }

    private final DisposableMemory getAccountAttributeNamePointer() {
        Lazy lazy = this.accountAttributeNamePointer$delegate;
        SecretCredentialStore secretCredentialStore = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (DisposableMemory)((Object)lazy.getValue());
    }

    private final Pointer getScheme() {
        Lazy lazy = this.scheme$delegate;
        SecretCredentialStore secretCredentialStore = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (Pointer)lazy.getValue();
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Object v3;
        Object it;
        GErrorStruct[] elements$iv$iv;
        GErrorStruct[] errorRef$iv;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        String method$iv = "secret_password_lookup_sync";
        GErrorStruct[] errorRef = errorRef$iv = (elements$iv$iv = new GErrorStruct[]{null});
        String string = attributes.getServiceName();
        Charset charset = null;
        boolean bl = true;
        Object var9_9 = null;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        DisposableMemory serviceNamePointer = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
        if (attributes.getUserName() == null) {
            String string3 = LinuxSecretLibraryKt.access$getLIBRARY$p().secret_password_lookup_sync(this.getScheme(), null, errorRef, (Pointer)this.getServiceAttributeNamePointer(), (Pointer)serviceNamePointer, null);
            if (string3 != null) {
                string = string3;
                it = string;
                return CredentialStoreKt.splitData((String)it);
            }
            v3 = null;
        } else {
            SecretLibrary secretLibrary = LinuxSecretLibraryKt.access$getLIBRARY$p();
            Pointer pointer = this.getScheme();
            Pointer[] pointerArray = new Pointer[5];
            pointerArray[0] = (Pointer)this.getServiceAttributeNamePointer();
            pointerArray[1] = (Pointer)serviceNamePointer;
            pointerArray[2] = (Pointer)this.getAccountAttributeNamePointer();
            String string4 = attributes.getUserName();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            string = string4;
            it = null;
            boolean $i$a$1$let = true;
            var9_9 = null;
            int n = 3;
            Pointer[] pointerArray2 = pointerArray;
            Pointer[] pointerArray3 = pointerArray;
            GErrorStruct[] gErrorStructArray = errorRef;
            Pointer pointer2 = null;
            Pointer pointer3 = pointer;
            SecretLibrary secretLibrary2 = secretLibrary;
            if ($i$a$1$let & true) {
                it = Charsets.UTF_8;
            }
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string5.getBytes((Charset)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray2;
            pointerArray2[n] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray3, false, 2, null);
            pointerArray3[4] = null;
            String string6 = secretLibrary2.secret_password_lookup_sync(pointer3, pointer2, gErrorStructArray, pointerArray3);
            if (string6 != null) {
                string = string6;
                it = string;
                return CredentialStoreKt.splitData((String)it);
            }
            v3 = null;
        }
        Object result$iv = v3;
        GErrorStruct error$iv = (GErrorStruct)((Object)((Object[])errorRef$iv)[0]);
        if (error$iv != null && error$iv.code != 0) {
            if (error$iv.code == 32584 || error$iv.code == 32618 || error$iv.code == 32606 || error$iv.code == 32642) {
                CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
            } else {
                CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        GErrorStruct[] elements$iv$iv;
        GErrorStruct[] errorRef$iv;
        String accountName;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        String string = attributes.getServiceName();
        Charset charset = null;
        boolean bl = true;
        Object var7_8 = null;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        DisposableMemory serviceNamePointer = LinuxSecretLibraryKt.stringPointer$default(byArray, false, 2, null);
        String string3 = attributes.getUserName();
        if (string3 == null) {
            Credentials credentials2 = credentials;
            string3 = accountName = credentials2 != null ? credentials2.getUserName() : null;
        }
        if (CredentialAttributesKt.isEmpty((Credentials)credentials)) {
            GErrorStruct[] elements$iv$iv2;
            GErrorStruct[] errorRef$iv2;
            String method$iv = "secret_password_store_sync";
            GErrorStruct[] errorRef = errorRef$iv2 = (elements$iv$iv2 = new GErrorStruct[]{null});
            if (accountName == null) {
                LinuxSecretLibraryKt.access$getLIBRARY$p().secret_password_clear_sync(this.getScheme(), null, errorRef, (Pointer)this.getServiceAttributeNamePointer(), (Pointer)serviceNamePointer, null);
            } else {
                Pointer[] pointerArray = new Pointer[5];
                pointerArray[0] = (Pointer)this.getServiceAttributeNamePointer();
                pointerArray[1] = (Pointer)serviceNamePointer;
                pointerArray[2] = (Pointer)this.getAccountAttributeNamePointer();
                String string4 = accountName;
                Charset charset2 = null;
                boolean bl2 = true;
                Object var12_19 = null;
                int n = 3;
                Pointer[] pointerArray2 = pointerArray;
                Pointer[] pointerArray3 = pointerArray;
                GErrorStruct[] gErrorStructArray = errorRef;
                Pointer pointer = null;
                Pointer pointer2 = this.getScheme();
                SecretLibrary secretLibrary = LinuxSecretLibraryKt.access$getLIBRARY$p();
                if (bl2 & true) {
                    charset2 = Charsets.UTF_8;
                }
                byte[] byArray2 = string4.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray3 = byArray2;
                pointerArray2[n] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray3, false, 2, null);
                pointerArray3[4] = null;
                secretLibrary.secret_password_clear_sync(pointer2, pointer, gErrorStructArray, pointerArray3);
            }
            Unit result$iv = Unit.INSTANCE;
            GErrorStruct error$iv = (GErrorStruct)((Object)((Object[])errorRef$iv2)[0]);
            if (error$iv != null && error$iv.code != 0) {
                if (error$iv.code == 32584 || error$iv.code == 32618 || error$iv.code == 32606 || error$iv.code == 32642) {
                    CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
                } else {
                    CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
                }
            }
            return;
        }
        Credentials credentials3 = credentials;
        if (credentials3 == null) {
            Intrinsics.throwNpe();
        }
        DisposableMemory passwordPointer = LinuxSecretLibraryKt.stringPointer(CredentialStoreKt.serialize(credentials3, !attributes.isPasswordMemoryOnly()), true);
        String method$iv = "secret_password_store_sync";
        GErrorStruct[] errorRef = errorRef$iv = (elements$iv$iv = new GErrorStruct[]{null});
        try {
            if (accountName == null) {
                LinuxSecretLibraryKt.access$getLIBRARY$p().secret_password_store_sync(this.getScheme(), null, (Pointer)serviceNamePointer, (Pointer)passwordPointer, null, errorRef, (Pointer)this.getServiceAttributeNamePointer(), (Pointer)serviceNamePointer, null);
            } else {
                Pointer[] pointerArray = new Pointer[5];
                pointerArray[0] = (Pointer)this.getServiceAttributeNamePointer();
                pointerArray[1] = (Pointer)serviceNamePointer;
                pointerArray[2] = (Pointer)this.getAccountAttributeNamePointer();
                String string5 = accountName;
                Charset charset3 = null;
                boolean bl3 = true;
                Object var13_22 = null;
                int n = 3;
                Pointer[] pointerArray4 = pointerArray;
                Pointer[] pointerArray5 = pointerArray;
                GErrorStruct[] gErrorStructArray = errorRef;
                Pointer pointer = null;
                Pointer pointer3 = (Pointer)passwordPointer;
                Pointer pointer4 = (Pointer)serviceNamePointer;
                Pointer pointer5 = null;
                Pointer pointer6 = this.getScheme();
                SecretLibrary secretLibrary = LinuxSecretLibraryKt.access$getLIBRARY$p();
                if (bl3 & true) {
                    charset3 = Charsets.UTF_8;
                }
                byte[] byArray4 = string5.getBytes(charset3);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray5 = byArray4;
                pointerArray4[n] = (Pointer)LinuxSecretLibraryKt.stringPointer$default(byArray5, false, 2, null);
                pointerArray5[4] = null;
                secretLibrary.secret_password_store_sync(pointer6, pointer5, pointer4, pointer3, pointer, gErrorStructArray, pointerArray5);
            }
        }
        finally {
            passwordPointer.dispose();
        }
        Unit result$iv = Unit.INSTANCE;
        GErrorStruct error$iv = (GErrorStruct)((Object)((Object[])errorRef$iv)[0]);
        if (error$iv != null && error$iv.code != 0) {
            if (error$iv.code == 32584 || error$iv.code == 32618 || error$iv.code == 32606 || error$iv.code == 32642) {
                CredentialStoreKt.getLOG().warn("gnome-keyring not installed or kde doesn't support Secret Service API. " + method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
            } else {
                CredentialStoreKt.getLOG().error(method$iv + " error code " + error$iv.code + ", error message " + error$iv.message);
            }
        }
    }

    public SecretCredentialStore(@NotNull String schemeName) {
        Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
        this.serviceAttributeNamePointer$delegate = LazyKt.lazy((Function0)serviceAttributeNamePointer.2.INSTANCE);
        this.accountAttributeNamePointer$delegate = LazyKt.lazy((Function0)accountAttributeNamePointer.2.INSTANCE);
        this.scheme$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pointer>(this, schemeName){
            final /* synthetic */ SecretCredentialStore this$0;
            final /* synthetic */ String $schemeName;

            @NotNull
            public final Pointer invoke() {
                return LinuxSecretLibraryKt.access$getLIBRARY$p().secret_schema_new(this.$schemeName, LinuxSecretLibraryKt.access$getSECRET_SCHEMA_NONE$p(), new Object[]{SecretCredentialStore.access$getServiceAttributeNamePointer$p(this.this$0), LinuxSecretLibraryKt.access$getSECRET_SCHEMA_ATTRIBUTE_STRING$p(), SecretCredentialStore.access$getAccountAttributeNamePointer$p(this.this$0), LinuxSecretLibraryKt.access$getSECRET_SCHEMA_ATTRIBUTE_STRING$p(), null});
            }
            {
                this.this$0 = secretCredentialStore;
                this.$schemeName = string;
                super(0);
            }
        }));
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SecretCredentialStore.class), "serviceAttributeNamePointer", "getServiceAttributeNamePointer()Lcom/intellij/util/io/jna/DisposableMemory;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SecretCredentialStore.class), "accountAttributeNamePointer", "getAccountAttributeNamePointer()Lcom/intellij/util/io/jna/DisposableMemory;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SecretCredentialStore.class), "scheme", "getScheme()Lcom/sun/jna/Pointer;"))};
    }

    @NotNull
    public static final /* synthetic */ DisposableMemory access$getServiceAttributeNamePointer$p(SecretCredentialStore $this) {
        return $this.getServiceAttributeNamePointer();
    }

    @NotNull
    public static final /* synthetic */ DisposableMemory access$getAccountAttributeNamePointer$p(SecretCredentialStore $this) {
        return $this.getAccountAttributeNamePointer();
    }
}

