/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDebugEnvironment
implements DebugEnvironment {
    private final GlobalSearchScope mySearchScope;
    private final RemoteConnection myRemoteConnection;
    private final long myPollTimeout;
    private final ExecutionEnvironment environment;
    private final RunProfileState state;
    private final boolean myNeedParametersSet;

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/DefaultDebugEnvironment", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/DefaultDebugEnvironment", "<init>"));
        }
        this(environment, state, remoteConnection, pollConnection ? 30000L : 0L);
    }

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, RemoteConnection remoteConnection, long pollTimeout) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/DefaultDebugEnvironment", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/DefaultDebugEnvironment", "<init>"));
        }
        this.environment = environment;
        this.state = state;
        this.myRemoteConnection = remoteConnection;
        this.myPollTimeout = pollTimeout;
        this.mySearchScope = DefaultDebugEnvironment.createSearchScope(environment.getProject(), environment.getRunProfile());
        this.myNeedParametersSet = remoteConnection.isServerMode() && remoteConnection.isUseSockets() && "0".equals(remoteConnection.getAddress());
    }

    private static GlobalSearchScope createSearchScope(final @NotNull Project project2, @Nullable RunProfile runProfile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/DefaultDebugEnvironment", "createSearchScope"));
        }
        GlobalSearchScope scope = SearchScopeProvider.createSearchScope((Project)project2, (RunProfile)runProfile);
        if (scope.equals(GlobalSearchScope.allScope((Project)project2))) {
            return new DelegatingGlobalSearchScope(scope){
                final ProjectFileIndex myProjectFileIndex;
                final Comparator<VirtualFile> myScopeComparator;
                {
                    super(arg0);
                    this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
                    this.myScopeComparator = Comparator.comparing(arg_0 -> ((ProjectFileIndex)this.myProjectFileIndex).isInSource(arg_0)).thenComparing(arg_0 -> ((ProjectFileIndex)this.myProjectFileIndex).isInLibrarySource(arg_0)).thenComparing((x$0, x$1) -> super.compare(x$0, x$1));
                }

                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    if (file1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/debugger/DefaultDebugEnvironment$1", "compare"));
                    }
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/debugger/DefaultDebugEnvironment$1", "compare"));
                    }
                    return this.myScopeComparator.compare(file1, file2);
                }
            };
        }
        return scope;
    }

    @Override
    public ExecutionResult createExecutionResult() throws ExecutionException {
        if (this.myNeedParametersSet && this.state instanceof JavaCommandLine) {
            DebuggerManagerImpl.createDebugParameters(((JavaCommandLine)this.state).getJavaParameters(), true, 0, this.myRemoteConnection.getAddress(), false);
        }
        return this.state.execute(this.environment.getExecutor(), this.environment.getRunner());
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/DefaultDebugEnvironment", "getSearchScope"));
        }
        return globalSearchScope;
    }

    @Override
    public boolean isRemote() {
        return this.state instanceof RemoteState;
    }

    @Override
    public RemoteConnection getRemoteConnection() {
        return this.myRemoteConnection;
    }

    @Override
    public long getPollTimeout() {
        return this.myPollTimeout;
    }

    @Override
    public String getSessionName() {
        return this.environment.getRunProfile().getName();
    }

    @Override
    @Nullable
    public Sdk getAlternativeJre() {
        return AlternativeJreClassFinder.getAlternativeJre(this.environment.getRunProfile());
    }

    @Override
    @Nullable
    public Sdk getRunJre() {
        if (this.state instanceof JavaCommandLine) {
            try {
                return ((JavaCommandLine)this.state).getJavaParameters().getJdk();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return ProjectRootManager.getInstance((Project)this.environment.getProject()).getProjectSdk();
    }
}

