/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

class ReloadClassesWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.ReloadClassesWorker");
    private final DebuggerSession myDebuggerSession;
    private final HotSwapProgress myProgress;

    public ReloadClassesWorker(DebuggerSession session2, HotSwapProgress progress) {
        this.myDebuggerSession = session2;
        this.myProgress = progress;
    }

    private DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession.getProcess();
    }

    private void processException(Throwable e) {
        if (e.getMessage() != null) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, e.getMessage());
        }
        if (e instanceof ProcessCanceledException) {
            this.myProgress.addMessage(this.myDebuggerSession, 3, DebuggerBundle.message((String)"error.operation.canceled", (Object[])new Object[0]));
            return;
        }
        if (e instanceof UnsupportedOperationException) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.operation.not.supported.by.vm", (Object[])new Object[0]));
        } else if (e instanceof NoClassDefFoundError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.class.def.not.found", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else if (e instanceof VerifyError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.verification.error", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else if (e instanceof UnsupportedClassVersionError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.unsupported.class.version", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else if (e instanceof ClassFormatError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.class.format.error", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else if (e instanceof ClassCircularityError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.class.circularity.error", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.exception.while.reloading", (Object[])new Object[]{e.getClass().getName(), e.getLocalizedMessage()}));
        }
    }

    public void reloadClasses(Map<String, HotSwapFile> modifiedClasses) {
        JavaExecutionStack stack;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (modifiedClasses == null || modifiedClasses.size() == 0) {
            this.myProgress.addMessage(this.myDebuggerSession, 3, DebuggerBundle.message((String)"status.hotswap.loaded.classes.up.to.date", (Object[])new Object[0]));
            return;
        }
        DebugProcessImpl debugProcess = this.getDebugProcess();
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess.getVirtualMachineProxy();
        Project project2 = debugProcess.getProject();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
        breakpointManager.disableBreakpoints(debugProcess);
        try {
            RedefineProcessor redefineProcessor = new RedefineProcessor(virtualMachineProxy);
            int processedEntriesCount = 0;
            for (Map.Entry<String, HotSwapFile> entry : modifiedClasses.entrySet()) {
                if (debugProcess.isDetached() || debugProcess.isDetaching() || redefineProcessor.getProcessedClassesCount() == 0 && this.myProgress.isCancelled()) break;
                ++processedEntriesCount;
                String qualifiedName = entry.getKey();
                if (qualifiedName != null) {
                    this.myProgress.setText(qualifiedName);
                    this.myProgress.setFraction((double)processedEntriesCount / (double)modifiedClasses.size());
                }
                try {
                    redefineProcessor.processClass(qualifiedName, entry.getValue().file);
                }
                catch (IOException e) {
                    this.reportProblem(qualifiedName, e);
                }
            }
            if (redefineProcessor.getProcessedClassesCount() == 0 && this.myProgress.isCancelled()) {
                return;
            }
            redefineProcessor.processPending();
            this.myProgress.setFraction(1.0);
            int partiallyRedefinedClassesCount = redefineProcessor.getPartiallyRedefinedClassesCount();
            if (partiallyRedefinedClassesCount == 0) {
                this.myProgress.addMessage(this.myDebuggerSession, 3, DebuggerBundle.message((String)"status.classes.reloaded", (Object[])new Object[]{redefineProcessor.getProcessedClassesCount()}));
            } else {
                String message = DebuggerBundle.message((String)"status.classes.not.all.versions.reloaded", (Object[])new Object[]{partiallyRedefinedClassesCount, redefineProcessor.getProcessedClassesCount()});
                this.myProgress.addMessage(this.myDebuggerSession, 5, message);
            }
            LOG.debug("classes reloaded");
        }
        catch (Throwable e) {
            this.processException(e);
        }
        debugProcess.onHotSwapFinished();
        DebuggerContextImpl context = this.myDebuggerSession.getContextManager().getContext();
        SuspendContextImpl suspendContext = context.getSuspendContext();
        if (suspendContext != null && (stack = suspendContext.getActiveExecutionStack()) != null) {
            stack.initTopFrame();
        }
        Semaphore waitSemaphore = new Semaphore();
        waitSemaphore.down();
        SwingUtilities.invokeLater(() -> {
            try {
                if (!project2.isDisposed()) {
                    breakpointManager.reloadBreakpoints();
                    debugProcess.getRequestsManager().clearWarnings();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("requests updated");
                        LOG.debug("time stamp set");
                    }
                    this.myDebuggerSession.refresh(false);
                    XDebugSession session2 = this.myDebuggerSession.getXDebugSession();
                    if (session2 != null) {
                        session2.rebuildViews();
                    }
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            finally {
                waitSemaphore.up();
            }
        });
        waitSemaphore.waitFor();
        if (!project2.isDisposed()) {
            try {
                breakpointManager.enableBreakpoints(debugProcess);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportProblem(String qualifiedName, @Nullable Exception ex) {
        String reason = null;
        if (ex != null) {
            reason = ex.getLocalizedMessage();
        }
        if (reason == null || reason.length() == 0) {
            reason = DebuggerBundle.message((String)"error.io.error", (Object[])new Object[0]);
        }
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append(qualifiedName).append(" : ").append(reason);
            this.myProgress.addMessage(this.myDebuggerSession, 4, buf.toString());
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    private static class RedefineProcessor {
        private static final int CLASSES_CHUNK_SIZE = 100;
        private final VirtualMachineProxyImpl myVirtualMachineProxy;
        private final Map<ReferenceType, byte[]> myRedefineMap = new HashMap<ReferenceType, byte[]>();
        private int myProcessedClassesCount;
        private int myPartiallyRedefinedClassesCount;

        public RedefineProcessor(VirtualMachineProxyImpl virtualMachineProxy) {
            this.myVirtualMachineProxy = virtualMachineProxy;
        }

        public void processClass(String qualifiedName, File file2) throws Throwable {
            List<ReferenceType> vmClasses = this.myVirtualMachineProxy.classesByName(qualifiedName);
            if (vmClasses.isEmpty()) {
                return;
            }
            byte[] content = FileUtil.loadFileBytes((File)file2);
            if (vmClasses.size() == 1) {
                this.myRedefineMap.put(vmClasses.get(0), content);
                if (this.myRedefineMap.size() >= 100) {
                    this.processChunk();
                }
                return;
            }
            int redefinedVersionsCount = 0;
            Throwable error = null;
            for (ReferenceType vmClass : vmClasses) {
                try {
                    this.myVirtualMachineProxy.redefineClasses(Collections.singletonMap(vmClass, content));
                    ++redefinedVersionsCount;
                }
                catch (Throwable t) {
                    error = t;
                }
            }
            if (redefinedVersionsCount == 0) {
                throw error;
            }
            if (redefinedVersionsCount < vmClasses.size()) {
                ++this.myPartiallyRedefinedClassesCount;
            }
            ++this.myProcessedClassesCount;
        }

        private void processChunk() throws Throwable {
            try {
                this.myVirtualMachineProxy.redefineClasses(this.myRedefineMap);
                this.myProcessedClassesCount += this.myRedefineMap.size();
            }
            finally {
                this.myRedefineMap.clear();
            }
        }

        public void processPending() throws Throwable {
            if (this.myRedefineMap.size() > 0) {
                this.processChunk();
            }
        }

        public int getProcessedClassesCount() {
            return this.myProcessedClassesCount;
        }

        public int getPartiallyRedefinedClassesCount() {
            return this.myPartiallyRedefinedClassesCount;
        }
    }
}

