/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.component;

import com.intellij.debugger.memory.component.TrackedStacksContainer;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.openapi.util.Key;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryViewDebugProcessData {
    public static final Key<MemoryViewDebugProcessData> KEY = Key.create((String)"MemoryView.DebugProcessData");
    private final TrackedStacksContainer myStacksContainer = new MyStackContainer();

    @NotNull
    public TrackedStacksContainer getTrackedStacks() {
        TrackedStacksContainer trackedStacksContainer = this.myStacksContainer;
        if (trackedStacksContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData", "getTrackedStacks"));
        }
        return trackedStacksContainer;
    }

    private static class MyStackContainer
    implements TrackedStacksContainer {
        private final Map<ReferenceType, Map<ObjectReference, List<StackFrameItem>>> myType2Reference2Stack = new ConcurrentHashMap<ReferenceType, Map<ObjectReference, List<StackFrameItem>>>();
        private final Map<ReferenceType, Map<ObjectReference, List<StackFrameItem>>> myPinnedType2Reference2Stack = new ConcurrentHashMap<ReferenceType, Map<ObjectReference, List<StackFrameItem>>>();

        private MyStackContainer() {
        }

        @Override
        @Nullable
        public List<StackFrameItem> getStack(@NotNull ObjectReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData$MyStackContainer", "getStack"));
            }
            List<StackFrameItem> stack = MyStackContainer.extract(this.myType2Reference2Stack, reference);
            return stack != null ? stack : MyStackContainer.extract(this.myPinnedType2Reference2Stack, reference);
        }

        @Override
        public void addStack(@NotNull ObjectReference ref, @NotNull List<StackFrameItem> frames) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData$MyStackContainer", "addStack"));
            }
            if (frames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData$MyStackContainer", "addStack"));
            }
            this.myType2Reference2Stack.computeIfAbsent(ref.referenceType(), referenceType -> new ConcurrentHashMap()).put(ref, frames);
        }

        @Override
        public void pinStacks(@NotNull ReferenceType referenceType) {
            if (referenceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceType", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData$MyStackContainer", "pinStacks"));
            }
            Map<ObjectReference, List<StackFrameItem>> ref2Stack = this.myType2Reference2Stack.get(referenceType);
            if (ref2Stack != null) {
                this.myPinnedType2Reference2Stack.put(referenceType, ref2Stack);
            }
        }

        @Override
        public void unpinStacks(@NotNull ReferenceType referenceType) {
            if (referenceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceType", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData$MyStackContainer", "unpinStacks"));
            }
            this.myPinnedType2Reference2Stack.remove(referenceType);
        }

        @Override
        public void release() {
            this.myType2Reference2Stack.clear();
        }

        @Override
        public void clear() {
            this.release();
            this.myPinnedType2Reference2Stack.clear();
        }

        @Nullable
        private static List<StackFrameItem> extract(@NotNull Map<ReferenceType, Map<ObjectReference, List<StackFrameItem>>> map, @NotNull ObjectReference ref) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData$MyStackContainer", "extract"));
            }
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/component/MemoryViewDebugProcessData$MyStackContainer", "extract"));
            }
            Map<ObjectReference, List<StackFrameItem>> ref2Stack = map.get(ref.referenceType());
            return ref2Stack != null ? ref2Stack.get(ref) : null;
        }
    }
}

