/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.InstancesTree;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.ObjectReference;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class InstancesWithStackFrameView {
    private static final float DEFAULT_SPLITTER_PROPORTION = 0.7f;
    private static final String EMPTY_TEXT_WHEN_ITEM_NOT_SELECTED = "Select instance to see stack frame";
    private static final String EMPTY_TEXT_WHEN_STACK_NOT_FOUND = "No stack frame for this instance";
    private static final String TEXT_FOR_ARRAYS = "Arrays could not be tracked";
    private float myHidedProportion;
    private final JBSplitter mySplitter;
    private boolean myIsHided;

    InstancesWithStackFrameView(@NotNull XDebugSession debugSession, @NotNull InstancesTree tree, @NotNull StackFrameList list, final @NotNull String className) {
        JBLabel stackTraceLabel;
        if (debugSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugSession", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView", "<init>"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView", "<init>"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView", "<init>"));
        }
        this.mySplitter = new JBSplitter(false, 0.7f);
        this.myIsHided = false;
        this.mySplitter.setFirstComponent((JComponent)new JBScrollPane((Component)((Object)tree)));
        Project project2 = debugSession.getProject();
        list.setEmptyText(EMPTY_TEXT_WHEN_ITEM_NOT_SELECTED);
        if (InstancesWithStackFrameView.isArrayType(className)) {
            stackTraceLabel = new JBLabel(TEXT_FOR_ARRAYS, 0);
        } else {
            ActionLink actionLink = new ActionLink("Enable tracking for new instances", AllIcons.Debugger.MemoryView.ClassTracked, new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Project project2 = e.getProject();
                    if (project2 != null && !project2.isDisposed()) {
                        InstancesTracker.getInstance(project2).add(className, TrackingType.CREATION);
                    }
                }
            });
            actionLink.setHorizontalAlignment(0);
            actionLink.setPaintUnderline(false);
            stackTraceLabel = actionLink;
        }
        this.mySplitter.setSplitterProportionKey("InstancesWithStackFrameView.SplitterKey");
        JBScrollPane stackComponent = new JBScrollPane((Component)((Object)list));
        if (!project2.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance(project2);
            tracker.addTrackerListener(new InstancesTrackerListener((JComponent)stackComponent, (JLabel)stackTraceLabel){
                final /* synthetic */ JComponent val$stackComponent;
                final /* synthetic */ JLabel val$stackTraceLabel;
                {
                    this.val$stackComponent = jComponent;
                    this.val$stackTraceLabel = jLabel;
                }

                @Override
                public void classChanged(@NotNull String name, @NotNull TrackingType type) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView$2", "classChanged"));
                    }
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView$2", "classChanged"));
                    }
                    if (Objects.equals(className, name) && type == TrackingType.CREATION) {
                        InstancesWithStackFrameView.this.mySplitter.setSecondComponent(this.val$stackComponent);
                    }
                }

                @Override
                public void classRemoved(@NotNull String name) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView$2", "classRemoved"));
                    }
                    if (Objects.equals(name, className)) {
                        InstancesWithStackFrameView.this.mySplitter.setSecondComponent((JComponent)this.val$stackTraceLabel);
                    }
                }
            }, tree);
            this.mySplitter.setSecondComponent((JComponent)(tracker.isTracked(className) ? stackComponent : stackTraceLabel));
        }
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.myHidedProportion = 0.7f;
        MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)DebuggerManager.getInstance((Project)project2).getDebugProcess(debugSession.getDebugProcess().getProcessHandler()).getUserData(MemoryViewDebugProcessData.KEY);
        tree.addTreeSelectionListener(e -> {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView", "lambda$new$0"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView", "lambda$new$0"));
            }
            ObjectReference ref = tree.getSelectedReference();
            if (ref != null && data != null) {
                List<StackFrameItem> stack = data.getTrackedStacks().getStack(ref);
                if (stack != null) {
                    list.setFrameItems(stack);
                    if (this.mySplitter.getProportion() == 1.0f) {
                        this.mySplitter.setProportion(0.7f);
                    }
                    return;
                }
                list.setEmptyText(EMPTY_TEXT_WHEN_STACK_NOT_FOUND);
            } else {
                list.setEmptyText(EMPTY_TEXT_WHEN_ITEM_NOT_SELECTED);
            }
            list.setFrameItems(Collections.emptyList());
        });
    }

    JComponent getComponent() {
        return this.mySplitter;
    }

    private static boolean isArrayType(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView", "isArrayType"));
        }
        return className.contains("[]");
    }

    private void hideStackFrame() {
        if (!this.myIsHided) {
            this.myHidedProportion = this.mySplitter.getProportion();
            this.mySplitter.getSecondComponent().setVisible(false);
            this.mySplitter.setProportion(1.0f);
            this.myIsHided = true;
        }
    }

    private void showStackFrame() {
        if (this.myIsHided) {
            this.mySplitter.getSecondComponent().setVisible(true);
            this.mySplitter.setProportion(this.myHidedProportion);
            this.myIsHided = false;
        }
    }
}

