/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class SingleAlarmWithMutableDelay {
    private final Alarm myAlarm;
    private final Task myTask;
    private volatile int myDelayMillis;

    public SingleAlarmWithMutableDelay(@NotNull Task task, @NotNull Disposable parentDisposable) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/debugger/memory/utils/SingleAlarmWithMutableDelay", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/debugger/memory/utils/SingleAlarmWithMutableDelay", "<init>"));
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
        this.myTask = task;
    }

    public void setDelay(int millis) {
        this.myDelayMillis = millis;
    }

    public void cancelAndRequest(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/utils/SingleAlarmWithMutableDelay", "cancelAndRequest"));
        }
        if (!this.myAlarm.isDisposed()) {
            this.cancelAllRequests();
            this.addRequest(() -> {
                if (suspendContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/utils/SingleAlarmWithMutableDelay", "lambda$cancelAndRequest$0"));
                }
                this.myTask.run(suspendContext);
            });
        }
    }

    public void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    private void addRequest(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/debugger/memory/utils/SingleAlarmWithMutableDelay", "addRequest"));
        }
        this.myAlarm.addRequest(runnable2, this.myDelayMillis);
    }

    @FunctionalInterface
    public static interface Task {
        public void run(@NotNull SuspendContextImpl var1);
    }
}

