/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.DefaultSyntheticProvider;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameItem {
    private static final Logger LOG = Logger.getInstance(StackFrameItem.class);
    private static final List<XNamedValue> VARS_CAPTURE_DISABLED = Collections.singletonList(JavaStackFrame.createMessageNode(DebuggerBundle.message((String)"message.node.local.variables.capture.disabled", (Object[])new Object[0]), null));
    private static final List<XNamedValue> VARS_NOT_CAPTURED = Collections.singletonList(JavaStackFrame.createMessageNode(DebuggerBundle.message((String)"message.node.local.variables.not.captured", (Object[])new Object[0]), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON));
    private static final XNamedValue VAR_NO_DEBUG_INFO = JavaStackFrame.createMessageNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE.getLabel(), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
    private final Location myLocation;
    private final List<XNamedValue> myVariables;

    public StackFrameItem(Location location, List<XNamedValue> variables) {
        this.myLocation = location;
        this.myVariables = variables;
    }

    @NotNull
    public String path() {
        String string = this.myLocation.declaringType().name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/utils/StackFrameItem", "path"));
        }
        return string;
    }

    public int line() {
        return DebuggerUtilsEx.getLineNumber(this.myLocation, false);
    }

    @NotNull
    public static List<StackFrameItem> createFrames(@NotNull SuspendContextImpl suspendContext, boolean withVars) throws EvaluateException {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/utils/StackFrameItem", "createFrames"));
        }
        ThreadReferenceProxyImpl threadReferenceProxy = suspendContext.getThread();
        if (threadReferenceProxy != null) {
            ArrayList<StackFrameItem> res = new ArrayList<StackFrameItem>();
            for (StackFrameProxyImpl frame : threadReferenceProxy.forceFrames()) {
                try {
                    Location location;
                    List<XNamedValue> vars;
                    block24: {
                        vars = null;
                        location = frame.location();
                        Method method2 = location.method();
                        if (withVars) {
                            if (!DebuggerSettings.getInstance().CAPTURE_VARIABLES) {
                                vars = VARS_CAPTURE_DISABLED;
                            } else if (method2.isNative() || method2.isBridge() || DefaultSyntheticProvider.checkIsSynthetic(method2)) {
                                vars = VARS_NOT_CAPTURED;
                            } else {
                                vars = new ArrayList<XNamedValue>();
                                try {
                                    ObjectReference thisObject = frame.thisObject();
                                    if (thisObject != null) {
                                        vars.add(StackFrameItem.createVariable(thisObject, "this", VariableItem.VarType.OBJECT));
                                    }
                                }
                                catch (EvaluateException e) {
                                    LOG.debug((Throwable)e);
                                }
                                try {
                                    for (LocalVariableProxyImpl localVariableProxyImpl : frame.visibleVariables()) {
                                        try {
                                            VariableItem.VarType varType = localVariableProxyImpl.getVariable().isArgument() ? VariableItem.VarType.PARAM : VariableItem.VarType.OBJECT;
                                            vars.add(StackFrameItem.createVariable(frame.getValue(localVariableProxyImpl), localVariableProxyImpl.name(), varType));
                                        }
                                        catch (EvaluateException e) {
                                            LOG.debug((Throwable)e);
                                        }
                                    }
                                }
                                catch (EvaluateException e) {
                                    if (e.getCause() instanceof AbsentInformationException) {
                                        vars.add(VAR_NO_DEBUG_INFO);
                                        try {
                                            for (Map.Entry<DecompiledLocalVariable, Value> entry : LocalVariablesUtil.fetchValues(frame, suspendContext.getDebugProcess(), false).entrySet()) {
                                                vars.add(StackFrameItem.createVariable(entry.getValue(), entry.getKey().getDisplayName(), VariableItem.VarType.PARAM));
                                            }
                                        }
                                        catch (Exception exception) {
                                            LOG.info((Throwable)exception);
                                            break block24;
                                        }
                                    }
                                    LOG.debug((Throwable)e);
                                }
                            }
                        }
                    }
                    StackFrameItem frameItem = new StackFrameItem(location, vars);
                    res.add(frameItem);
                    List<StackFrameItem> list = StackCapturingLineBreakpoint.getRelatedStack(frame, suspendContext);
                    if (ContainerUtil.isEmpty(list)) continue;
                    res.add(null);
                    res.addAll(list);
                    break;
                }
                catch (EvaluateException e) {
                    LOG.debug((Throwable)e);
                }
            }
            ArrayList<StackFrameItem> arrayList = res;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/utils/StackFrameItem", "createFrames"));
            }
            return arrayList;
        }
        List<StackFrameItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/utils/StackFrameItem", "createFrames"));
        }
        return list;
    }

    private static VariableItem createVariable(Value value, String name, VariableItem.VarType varType) {
        String type = null;
        String valueText = "null";
        if (value instanceof ObjectReference) {
            valueText = value instanceof StringReference ? ((StringReference)value).value() : "";
            type = value.type().name() + "@" + ((ObjectReference)value).uniqueID();
        } else if (value != null) {
            valueText = value.toString();
        }
        return new VariableItem(name, type, valueText, varType);
    }

    public CapturedStackFrame createFrame(DebugProcessImpl debugProcess) {
        return new CapturedStackFrame(debugProcess, this);
    }

    public static class CapturedStackFrame
    extends XStackFrame
    implements JVMStackFrameInfoProvider,
    XDebuggerFramesList.ItemWithSeparatorAbove {
        private final XSourcePosition mySourcePosition;
        private final boolean myIsSynthetic;
        private final boolean myIsInLibraryContent;
        private final String myPath;
        private final String myMethodName;
        private final int myLineNumber;
        private final List<XNamedValue> myVariables;
        private volatile boolean myWithSeparator;
        private static final XDebuggerTreeNodeHyperlink CAPTURE_SETTINGS_OPENER = new XDebuggerTreeNodeHyperlink(" settings"){

            public void onClick(MouseEvent event) {
                ShowSettingsUtil.getInstance().showSettingsDialog(null, CaptureConfigurable.class);
                event.consume();
            }
        };

        public CapturedStackFrame(DebugProcessImpl debugProcess, StackFrameItem item) {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.mySourcePosition = DebuggerUtilsEx.toXSourcePosition(debugProcess.getPositionManager().getSourcePosition(item.myLocation));
            this.myIsSynthetic = DebuggerUtils.isSynthetic((TypeComponent)item.myLocation.method());
            this.myIsInLibraryContent = DebuggerUtilsEx.isInLibraryContent(this.mySourcePosition != null ? this.mySourcePosition.getFile() : null, debugProcess.getProject());
            this.myPath = item.path();
            this.myMethodName = item.myLocation.method().name();
            this.myLineNumber = item.line();
            this.myVariables = item.myVariables;
        }

        @Nullable
        public XSourcePosition getSourcePosition() {
            return this.mySourcePosition;
        }

        @Override
        public boolean isSynthetic() {
            return this.myIsSynthetic;
        }

        @Override
        public boolean isInLibraryContent() {
            return this.myIsInLibraryContent;
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/memory/utils/StackFrameItem$CapturedStackFrame", "customizePresentation"));
            }
            component.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)6)));
            component.append(String.format("%s:%d, %s", this.myMethodName, this.myLineNumber, StringUtil.getShortName((String)this.myPath)), this.getAttributes());
            String packageName = StringUtil.getPackageName((String)this.myPath);
            if (!packageName.trim().isEmpty()) {
                component.append(String.format(" (%s)", packageName), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            }
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/memory/utils/StackFrameItem$CapturedStackFrame", "computeChildren"));
            }
            if (this.myVariables == VARS_CAPTURE_DISABLED) {
                node.setMessage(DebuggerBundle.message((String)"message.node.local.variables.capture.disabled", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, CAPTURE_SETTINGS_OPENER);
            } else if (this.myVariables != null) {
                XValueChildrenList children2 = new XValueChildrenList();
                this.myVariables.forEach(arg_0 -> ((XValueChildrenList)children2).add(arg_0));
                node.addChildren(children2, true);
            } else {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
        }

        private SimpleTextAttributes getAttributes() {
            if (this.isSynthetic() || this.isInLibraryContent()) {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }

        @Override
        public boolean hasSeparatorAbove() {
            return this.myWithSeparator;
        }

        public void setWithSeparator(boolean withSeparator) {
            this.myWithSeparator = withSeparator;
        }

        public String toString() {
            if (this.mySourcePosition != null) {
                return this.mySourcePosition.getFile().getName() + ":" + (this.mySourcePosition.getLine() + 1);
            }
            return "<position unknown>";
        }
    }

    private static class VariableItem
    extends XNamedValue {
        private final String myType;
        private final String myValue;
        private final VarType myVarType;

        public VariableItem(String name, String type, String value, VarType varType) {
            super(name);
            this.myType = type;
            this.myValue = value;
            this.myVarType = varType;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Icon icon;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/memory/utils/StackFrameItem$VariableItem", "computePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/debugger/memory/utils/StackFrameItem$VariableItem", "computePresentation"));
            }
            final ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            final String type = Registry.is((String)"debugger.showTypes") ? classRenderer.renderTypeName(this.myType) : null;
            Icon icon2 = icon = this.myVarType == VarType.PARAM ? PlatformIcons.PARAMETER_ICON : AllIcons.Debugger.Value;
            if (this.myType != null && this.myType.startsWith("java.lang.String@")) {
                node.setPresentation(icon, (XValuePresentation)new XStringValuePresentation(this.myValue){

                    @Nullable
                    public String getType() {
                        return classRenderer.SHOW_STRINGS_TYPE ? type : null;
                    }
                }, false);
                return;
            }
            node.setPresentation(icon, type, this.myValue, false);
        }

        static enum VarType {
            PARAM,
            OBJECT;

        }
    }
}

