/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffPsiFileSupport {
    public static final Key<Boolean> KEY = Key.create((String)"Diff.DiffPsiFileSupport");

    public static boolean isDiffFile(@Nullable PsiFile file2) {
        return file2 != null && DiffPsiFileSupport.isDiffFile(file2.getVirtualFile());
    }

    public static boolean isDiffFile(@Nullable VirtualFile file2) {
        return file2 != null && file2.getUserData(KEY) == Boolean.TRUE;
    }

    public static class HighlightingSettingProvider
    extends DefaultHighlightingSettingProvider {
        @Nullable
        public FileHighlightingSetting getDefaultSetting(@NotNull Project project2, @NotNull VirtualFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/contents/DiffPsiFileSupport$HighlightingSettingProvider", "getDefaultSetting"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/DiffPsiFileSupport$HighlightingSettingProvider", "getDefaultSetting"));
            }
            if (!DiffPsiFileSupport.isDiffFile(file2)) {
                return null;
            }
            return FileHighlightingSetting.SKIP_INSPECTION;
        }
    }

    public static class IntentionFilter
    implements IntentionActionFilter {
        @Override
        public boolean accept(@NotNull IntentionAction intentionAction, @Nullable PsiFile file2) {
            if (intentionAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/diff/contents/DiffPsiFileSupport$IntentionFilter", "accept"));
            }
            return !DiffPsiFileSupport.isDiffFile(file2);
        }
    }

    public static class HighlightFilter
    implements HighlightInfoFilter {
        @Override
        public boolean accept(@NotNull HighlightInfo info, @Nullable PsiFile file2) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/diff/contents/DiffPsiFileSupport$HighlightFilter", "accept"));
            }
            if (!DiffPsiFileSupport.isDiffFile(file2)) {
                return true;
            }
            return info.getSeverity() != HighlightSeverity.ERROR;
        }
    }
}

