/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.lang;

import com.intellij.diff.lang.LangDiffIgnoredRangeProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaDiffIgnoredRangeProvider
extends LangDiffIgnoredRangeProvider {
    @Override
    @NotNull
    public String getDescription() {
        if ("Ignore imports and formatting" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "getDescription"));
        }
        return "Ignore imports and formatting";
    }

    @Override
    protected boolean accepts(@NotNull Project project2, @NotNull Language language) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "accepts"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "accepts"));
        }
        return JavaLanguage.INSTANCE.equals(language);
    }

    @Override
    @NotNull
    protected List<TextRange> computeIgnoredRanges(@NotNull Project project2, @NotNull CharSequence text, @NotNull Language language) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "computeIgnoredRanges"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "computeIgnoredRanges"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "computeIgnoredRanges"));
        }
        List list = (List)ReadAction.compute(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "lambda$computeIgnoredRanges$0"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "lambda$computeIgnoredRanges$0"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "lambda$computeIgnoredRanges$0"));
            }
            final ArrayList result2 = new ArrayList();
            PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("", language, text);
            psiFile.accept(new PsiElementVisitor(){

                public void visitElement(PsiElement element) {
                    if (element.getTextLength() == 0) {
                        return;
                    }
                    if (JavaDiffIgnoredRangeProvider.isIgnored(element)) {
                        result2.add(element.getTextRange());
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return result2;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "computeIgnoredRanges"));
        }
        return list;
    }

    private static boolean isIgnored(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/diff/lang/JavaDiffIgnoredRangeProvider", "isIgnored"));
        }
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        return element instanceof PsiImportList;
    }
}

