/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideDiffChangeBase {
    @NotNull
    private final MergeConflictType myType;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters;
    @NotNull
    protected final List<RangeHighlighter> myInnerHighlighters;

    public ThreesideDiffChangeBase(@NotNull MergeConflictType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "<init>"));
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myInnerHighlighters = new ArrayList<RangeHighlighter>();
        this.myType = type;
    }

    protected void installHighlighters() {
        assert (this.myHighlighters.isEmpty());
        this.createHighlighter(ThreeSide.BASE);
        if (this.isChange(Side.LEFT)) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.isChange(Side.RIGHT)) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
    }

    protected void installInnerHighlighters() {
        assert (this.myInnerHighlighters.isEmpty());
        this.createInnerHighlighter(ThreeSide.BASE);
        if (this.isChange(Side.LEFT)) {
            this.createInnerHighlighter(ThreeSide.LEFT);
        }
        if (this.isChange(Side.RIGHT)) {
            this.createInnerHighlighter(ThreeSide.RIGHT);
        }
    }

    protected void destroyHighlighters() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    protected void destroyInnerHighlighters() {
        for (RangeHighlighter highlighter : this.myInnerHighlighters) {
            highlighter.dispose();
        }
        this.myInnerHighlighters.clear();
    }

    public abstract int getStartLine(@NotNull ThreeSide var1);

    public abstract int getEndLine(@NotNull ThreeSide var1);

    public abstract boolean isResolved(@NotNull ThreeSide var1);

    @NotNull
    protected abstract Editor getEditor(@NotNull ThreeSide var1);

    @Nullable
    protected abstract MergeInnerDifferences getInnerFragments();

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = this.myType.getDiffType();
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public MergeConflictType getType() {
        MergeConflictType mergeConflictType = this.myType;
        if (mergeConflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getType"));
        }
        return mergeConflictType;
    }

    public boolean isConflict() {
        return this.getDiffType() == TextDiffType.CONFLICT;
    }

    public boolean isChange(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isChange"));
        }
        return this.myType.isChange(side);
    }

    public boolean isChange(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isChange"));
        }
        return this.myType.isChange(side);
    }

    protected void createHighlighter(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "createHighlighter"));
        }
        Editor editor = this.getEditor(side);
        TextDiffType type = this.getDiffType();
        int startLine = this.getStartLine(side);
        int endLine = this.getEndLine(side);
        boolean resolved = this.isResolved(side);
        boolean ignored = !resolved && this.getInnerFragments() != null;
        boolean shouldHideWithoutLineNumbers = side == ThreeSide.BASE && !this.isChange(Side.LEFT) && this.isChange(Side.RIGHT);
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(editor, startLine, endLine, type, ignored, resolved, shouldHideWithoutLineNumbers));
    }

    protected void createInnerHighlighter(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "createInnerHighlighter"));
        }
        if (this.isResolved(side)) {
            return;
        }
        MergeInnerDifferences innerFragments = this.getInnerFragments();
        if (innerFragments == null) {
            return;
        }
        List<TextRange> ranges = innerFragments.get(side);
        if (ranges == null) {
            return;
        }
        Editor editor = this.getEditor(side);
        int start = DiffUtil.getLinesRange(editor.getDocument(), this.getStartLine(side), this.getEndLine(side)).getStartOffset();
        for (TextRange fragment : ranges) {
            int innerStart = start + fragment.getStartOffset();
            int innerEnd = start + fragment.getEndOffset();
            this.myInnerHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, innerStart, innerEnd, this.getDiffType()));
        }
    }
}

