/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.OnesideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OnesideTextDiffViewer
extends OnesideDiffViewer<TextEditorHolder> {
    @NotNull
    private final List<? extends EditorEx> myEditableEditors;
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction;

    public OnesideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "<init>"));
        }
        super(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        this.myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected TextEditorHolder createEditorHolder(@NotNull EditorHolderFactory<TextEditorHolder> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "createEditorHolder"));
        }
        TextEditorHolder holder = super.createEditorHolder(factory);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        if (forceReadOnly[0]) {
            holder.getEditor().setViewer(true);
        }
        TextEditorHolder textEditorHolder = holder;
        if (textEditorHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "createEditorHolder"));
        }
        return textEditorHolder;
    }

    @Override
    @Nullable
    protected JComponent createTitle() {
        List<JComponent> textTitles = DiffUtil.createTextTitles(this.myRequest, ContainerUtil.list((Object[])new EditorEx[]{this.getEditor(), this.getEditor()}));
        return (JComponent)this.getSide().select(textTitles);
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "getTextSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        List<AnAction> list = TextDiffViewerUtil.createEditorPopupActions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "createEditorPopupActions"));
        }
        return list;
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
    }

    protected void destroyEditorListeners() {
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        List<EditorEx> list = Collections.singletonList(this.getEditor());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "getEditors"));
        }
        return list;
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        List<? extends EditorEx> list = this.myEditableEditors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "getEditableEditors"));
        }
        return list;
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = ((TextEditorHolder)this.getEditorHolder()).getEditor();
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "getEditor"));
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getContent() {
        DocumentContent documentContent = (DocumentContent)super.getContent();
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "getContent"));
        }
        return documentContent;
    }

    protected void scrollToLine(int line) {
        DiffUtil.scrollEditor(this.getEditor(), line, false);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getContent().getNavigatable(LineCol.fromCaret((Editor)this.getEditor()));
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer", "canShowRequest"));
        }
        return OnesideDiffViewer.canShowRequest(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getEditor();
        }
        return super.getData(dataId);
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = OnesideTextDiffViewer.this.getEditors();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer$MyInitialScrollPositionHelper", "getEditors"));
            }
            return list;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            Side side = (Side)this.myScrollToLine.first;
            if (side != OnesideTextDiffViewer.this.getSide()) {
                return false;
            }
            OnesideTextDiffViewer.this.scrollToLine((Integer)this.myScrollToLine.second);
            return true;
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
            }
            if (editor != OnesideTextDiffViewer.this.getEditor()) {
                return null;
            }
            return OnesideTextDiffViewer.this.getContent().getNavigatable(new LineCol(line));
        }
    }
}

