/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.treeHash.AbstractTreeHasher;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreeHashingUtils;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeHasherBase
extends AbstractTreeHasher {
    private final FragmentsCollector myCallback;
    private final int myDiscardCost;
    private final DuplicatesProfile myProfile;

    TreeHasherBase(@Nullable FragmentsCollector callback, @NotNull DuplicatesProfile profile2, int discardCost, boolean forIndexing) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/dupLocator/treeHash/TreeHasherBase", "<init>"));
        }
        super(callback, forIndexing);
        this.myCallback = callback;
        this.myDiscardCost = discardCost;
        this.myProfile = profile2;
    }

    @Override
    protected int getDiscardCost(PsiElement root) {
        if (this.myDiscardCost >= 0) {
            return this.myDiscardCost;
        }
        return this.myProfile.getDuplocatorState(this.myProfile.getLanguage(root)).getDiscardCost();
    }

    @Override
    protected TreeHashResult hash(@NotNull PsiElement root, PsiFragment upper, @NotNull NodeSpecificHasher hasher) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dupLocator/treeHash/TreeHasherBase", "hash"));
        }
        if (hasher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasher", "com/intellij/dupLocator/treeHash/TreeHasherBase", "hash"));
        }
        TreeHashResult result2 = this.computeHash(root, upper, hasher);
        int discardCost = this.getDiscardCost(root);
        if (result2.getCost() < discardCost) {
            return new TreeHashResult(0, result2.getCost(), result2.getFragment());
        }
        return result2;
    }

    private TreeHashResult computeHash(PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        List<PsiElement> children2;
        EquivalenceDescriptor descriptor;
        EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(root);
        if (descriptorProvider != null && (descriptor = descriptorProvider.buildDescriptor(root)) != null) {
            return this.computeHash(root, upper, descriptor, hasher);
        }
        if (root instanceof PsiFile && (children2 = hasher.getNodeChildren(root)).size() <= 20) {
            return this.hashCodeBlock(children2, upper, hasher, true);
        }
        NodeSpecificHasherBase ssrNodeSpecificHasher = (NodeSpecificHasherBase)hasher;
        if (TreeHasherBase.shouldBeAnonymized(root, ssrNodeSpecificHasher)) {
            return this.computeElementHash(root, upper, hasher);
        }
        if (this.myForIndexing) {
            return this.computeElementHash(root, upper, hasher);
        }
        PsiElement element = DuplocatorUtil.getOnlyChild(root, ssrNodeSpecificHasher.getNodeFilter());
        if (element != root) {
            TreeHashResult result2 = this.hash(element, upper, hasher);
            int cost = hasher.getNodeCost(root);
            return new TreeHashResult(result2.getHash(), result2.getCost() + cost, result2.getFragment());
        }
        return this.computeElementHash(element, upper, hasher);
    }

    @Override
    public boolean shouldAnonymize(PsiElement root, NodeSpecificHasher hasher) {
        return TreeHasherBase.shouldBeAnonymized(root, (NodeSpecificHasherBase)hasher);
    }

    @Override
    protected TreeHashResult computeElementHash(@NotNull PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeElementHash"));
        }
        if (this.myForIndexing) {
            return TreeHashingUtils.computeElementHashForIndexing(this, this.myCallBack, root, upper, hasher);
        }
        List<PsiElement> children2 = hasher.getNodeChildren(root);
        int size = children2.size();
        int[] childHashes = new int[size];
        int[] childCosts = new int[size];
        TreePsiFragment fragment = this.buildFragment(hasher, root, this.getCost(root));
        if (upper != null) {
            fragment.setParent(upper);
        }
        if (size == 0 && !(root instanceof LeafElement)) {
            return new TreeHashResult(0, hasher.getNodeCost(root), fragment);
        }
        for (int i2 = 0; i2 < size; ++i2) {
            TreeHashResult res = this.hash(children2.get(i2), fragment, hasher);
            childHashes[i2] = res.getHash();
            childCosts[i2] = res.getCost();
        }
        int c = hasher.getNodeCost(root) + AbstractTreeHasher.vector(childCosts);
        int h1 = hasher.getNodeHash(root);
        int discardCost = this.getDiscardCost(root);
        for (int i3 = 0; i3 < size; ++i3) {
            if (childCosts[i3] > discardCost || !this.ignoreChildHash(children2.get(i3))) continue;
            childHashes[i3] = 0;
        }
        int h = h1 + AbstractTreeHasher.vector(childHashes);
        if (TreeHasherBase.shouldBeAnonymized(root, (NodeSpecificHasherBase)hasher)) {
            h = 0;
        }
        if (this.myCallBack != null) {
            this.myCallBack.add(h, c, fragment);
        }
        return new TreeHashResult(h, c, fragment);
    }

    @Override
    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher, boolean forceHash) {
        if (!this.myForIndexing) {
            return super.hashCodeBlock(statements, upper, hasher, forceHash);
        }
        return TreeHashingUtils.hashCodeBlockForIndexing(this, this.myCallBack, statements, upper, hasher);
    }

    private TreeHashResult computeHash(PsiElement element, PsiFragment parent, EquivalenceDescriptor descriptor, NodeSpecificHasher hasher) {
        Couple<Integer> childHashResult;
        NodeSpecificHasherBase ssrHasher = (NodeSpecificHasherBase)hasher;
        PsiElement element2 = DuplocatorUtil.skipNodeIfNeccessary(element, descriptor, ssrHasher.getNodeFilter());
        boolean canSkip = element2 != element;
        TreePsiFragment fragment = this.buildFragment(hasher, element, 0);
        if (parent != null) {
            fragment.setParent(parent);
        }
        int hash = canSkip ? 0 : hasher.getNodeHash(element);
        int cost = hasher.getNodeCost(element);
        for (SingleChildDescriptor singleChildDescriptor : descriptor.getSingleChildDescriptors()) {
            childHashResult = this.computeHash(singleChildDescriptor, (PsiFragment)fragment, hasher);
            hash = hash * 31 + (Integer)childHashResult.first;
            cost += ((Integer)childHashResult.second).intValue();
        }
        for (MultiChildDescriptor multiChildDescriptor : descriptor.getMultiChildDescriptors()) {
            childHashResult = this.computeHash(multiChildDescriptor, (PsiFragment)fragment, hasher);
            hash = hash * 31 + (Integer)childHashResult.first;
            cost += ((Integer)childHashResult.second).intValue();
        }
        for (Object object : descriptor.getConstants()) {
            int constantHash = object != null ? object.hashCode() : 0;
            hash = hash * 31 + constantHash;
        }
        for (PsiElement[] psiElementArray : descriptor.getCodeBlocks()) {
            List<PsiElement> filteredBlock = TreeHasherBase.filter(psiElementArray, ssrHasher);
            TreeHashResult childHashResult2 = this.hashCodeBlock(filteredBlock, fragment, hasher);
            hash = hash * 31 + childHashResult2.getHash();
            cost += childHashResult2.getCost();
        }
        if (this.myCallback != null) {
            this.myCallback.add(hash, cost, fragment);
        }
        return new TreeHashResult(hash, cost, fragment);
    }

    public static List<PsiElement> filter(PsiElement[] elements, NodeSpecificHasherBase hasher) {
        ArrayList<PsiElement> filteredElements = new ArrayList<PsiElement>();
        for (PsiElement element : elements) {
            if (hasher.getNodeFilter().accepts(element)) continue;
            filteredElements.add(element);
        }
        return filteredElements;
    }

    @NotNull
    private Couple<Integer> computeHash(SingleChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement element = childDescriptor.getElement();
        if (element == null) {
            Couple couple = Couple.of((Object)0, (Object)0);
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHash"));
            }
            return couple;
        }
        Couple<Integer> result2 = this.doComputeHash(childDescriptor, parentFragment, nodeSpecificHasher);
        DuplicatesProfileBase duplicatesProfile = ((NodeSpecificHasherBase)nodeSpecificHasher).getDuplicatesProfile();
        PsiElementRole role = duplicatesProfile.getRole(element);
        if (role != null && !duplicatesProfile.getDuplocatorState(duplicatesProfile.getLanguage(element)).distinguishRole(role)) {
            Couple couple = Couple.of((Object)0, (Object)result2.second);
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHash"));
            }
            return couple;
        }
        Couple<Integer> couple = result2;
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHash"));
        }
        return couple;
    }

    private static boolean shouldBeAnonymized(PsiElement element, NodeSpecificHasherBase nodeSpecificHasher) {
        DuplicatesProfileBase duplicatesProfile = nodeSpecificHasher.getDuplicatesProfile();
        PsiElementRole role = duplicatesProfile.getRole(element);
        return role != null && !duplicatesProfile.getDuplocatorState(duplicatesProfile.getLanguage(element)).distinguishRole(role);
    }

    @NotNull
    private Couple<Integer> doComputeHash(SingleChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement element = childDescriptor.getElement();
        switch (childDescriptor.getType()) {
            case OPTIONALLY_IN_PATTERN: 
            case DEFAULT: {
                TreeHashResult result2 = this.hash(element, parentFragment, nodeSpecificHasher);
                Couple couple = Couple.of((Object)result2.getHash(), (Object)result2.getCost());
                if (couple == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "doComputeHash"));
                }
                return couple;
            }
            case CHILDREN_OPTIONALLY_IN_PATTERN: 
            case CHILDREN: {
                TreeHashResult[] childResults = this.computeHashesForChildren(element, parentFragment, nodeSpecificHasher);
                int[] hashes = TreeHasherBase.getHashes(childResults);
                int[] costs = TreeHasherBase.getCosts(childResults);
                int hash = AbstractTreeHasher.vector(hashes, 31);
                int cost = AbstractTreeHasher.vector(costs);
                Couple couple = Couple.of((Object)hash, (Object)cost);
                if (couple == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "doComputeHash"));
                }
                return couple;
            }
            case CHILDREN_IN_ANY_ORDER: {
                TreeHashResult[] childResults = this.computeHashesForChildren(element, parentFragment, nodeSpecificHasher);
                int[] hashes = TreeHasherBase.getHashes(childResults);
                int[] costs = TreeHasherBase.getCosts(childResults);
                int hash = AbstractTreeHasher.vector(hashes);
                int cost = AbstractTreeHasher.vector(costs);
                Couple couple = Couple.of((Object)hash, (Object)cost);
                if (couple == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "doComputeHash"));
                }
                return couple;
            }
        }
        Couple couple = Couple.of((Object)0, (Object)0);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "doComputeHash"));
        }
        return couple;
    }

    @NotNull
    private Couple<Integer> computeHash(MultiChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement[] elements = childDescriptor.getElements();
        if (elements == null) {
            Couple couple = Couple.of((Object)0, (Object)0);
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHash"));
            }
            return couple;
        }
        switch (childDescriptor.getType()) {
            case OPTIONALLY_IN_PATTERN: 
            case DEFAULT: {
                TreeHashResult[] childResults = this.computeHashes(elements, parentFragment, nodeSpecificHasher);
                int[] hashes = TreeHasherBase.getHashes(childResults);
                int[] costs = TreeHasherBase.getCosts(childResults);
                int hash = AbstractTreeHasher.vector(hashes, 31);
                int cost = AbstractTreeHasher.vector(costs);
                Couple couple = Couple.of((Object)hash, (Object)cost);
                if (couple == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHash"));
                }
                return couple;
            }
            case IN_ANY_ORDER: {
                TreeHashResult[] childResults = this.computeHashes(elements, parentFragment, nodeSpecificHasher);
                int[] hashes = TreeHasherBase.getHashes(childResults);
                int[] costs = TreeHasherBase.getCosts(childResults);
                int hash = AbstractTreeHasher.vector(hashes);
                int cost = AbstractTreeHasher.vector(costs);
                Couple couple = Couple.of((Object)hash, (Object)cost);
                if (couple == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHash"));
                }
                return couple;
            }
        }
        Couple couple = Couple.of((Object)0, (Object)0);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHash"));
        }
        return couple;
    }

    @NotNull
    private TreeHashResult[] computeHashesForChildren(PsiElement element, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        ArrayList<TreeHashResult> result2 = new ArrayList<TreeHashResult>();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            TreeHashResult childResult = this.hash(element, parentFragment, nodeSpecificHasher);
            result2.add(childResult);
        }
        TreeHashResult[] treeHashResultArray = result2.toArray(new TreeHashResult[result2.size()]);
        if (treeHashResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHashesForChildren"));
        }
        return treeHashResultArray;
    }

    @NotNull
    private TreeHashResult[] computeHashes(PsiElement[] elements, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        TreeHashResult[] result2 = new TreeHashResult[elements.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            result2[i2] = this.hash(elements[i2], parentFragment, nodeSpecificHasher);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/TreeHasherBase", "computeHashes"));
        }
        return result2;
    }

    private static int[] getHashes(TreeHashResult[] results) {
        int[] hashes = new int[results.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            hashes[i2] = results[i2].getHash();
        }
        return hashes;
    }

    private static int[] getCosts(TreeHashResult[] results) {
        int[] costs = new int[results.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            costs[i2] = results[i2].getCost();
        }
        return costs;
    }
}

